/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.libpst;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.libpst.EmailVisitor;
import org.apache.tika.parser.microsoft.libpst.LibPstParserConfig;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.FileProcessResult;
import org.apache.tika.utils.ProcessUtils;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LibPstParser
implements Parser,
Initializable {
    public static final MediaType MS_OUTLOOK_PST_MIMETYPE = MediaType.application((String)"vnd.ms-outlook-pst");
    private static final Set<MediaType> SUPPORTED = Set.of(MS_OUTLOOK_PST_MIMETYPE);
    private static final Logger LOGGER = LoggerFactory.getLogger(LibPstParser.class);
    private static final int MAX_STDOUT = 100000;
    private static final int MAX_STDERR = 10000;
    private static final String READ_PST_COMMAND = "readpst";
    private final LibPstParserConfig defaultConfig = new LibPstParserConfig();
    private String readPstPath = "";

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        TikaInputStream tis = TikaInputStream.cast((InputStream)inputStream);
        TemporaryResources tmp = null;
        if (tis == null) {
            tmp = new TemporaryResources();
            tis = TikaInputStream.get((InputStream)inputStream, (TemporaryResources)tmp, (Metadata)metadata);
        }
        try {
            this._parse(tis.getPath(), contentHandler, metadata, parseContext);
        }
        finally {
            IOUtils.closeQuietly((Closeable)tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _parse(Path pst, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws TikaException, IOException, SAXException {
        LibPstParserConfig activeConfig = (LibPstParserConfig)parseContext.get(LibPstParserConfig.class, (Object)this.defaultConfig);
        Path outDir = Files.createTempDirectory("libpst-", new FileAttribute[0]);
        Path debugFile = activeConfig.isDebug() ? Files.createTempFile("tika-libpst-debug", ".txt", new FileAttribute[0]) : null;
        try {
            ProcessBuilder pb = this.getProcessBuilder(pst, activeConfig, outDir, debugFile);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(contentHandler, metadata);
            FileProcessResult fileProcessResult = ProcessUtils.execute((ProcessBuilder)pb, (long)(activeConfig.getTimeoutSeconds() * 1000L), (int)100000, (int)10000);
            xhtml.startDocument();
            this.processContents(outDir, activeConfig, xhtml, metadata, parseContext);
            if (fileProcessResult.isTimeout()) {
                throw new TikaException("Timeout exception: " + fileProcessResult.getProcessTimeMillis());
            }
            if (fileProcessResult.getExitValue() != 0) {
                LOGGER.warn("libpst bad exit value {}: {}", (Object)fileProcessResult.getExitValue(), (Object)fileProcessResult.getStderr());
                throw new TikaException("Bad exit value: " + fileProcessResult.getExitValue());
            }
            xhtml.endDocument();
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)outDir.toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't delete temporary directory: " + outDir.toAbsolutePath(), (Throwable)e);
            }
            try {
                if (debugFile != null) {
                    Files.delete(debugFile);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't delete debug file?!", (Throwable)e);
            }
        }
    }

    private void processContents(Path outDir, LibPstParserConfig config, XHTMLContentHandler xhtml, Metadata metadata, ParseContext parseContext) throws IOException {
        Files.walkFileTree(outDir, new EmailVisitor(outDir, config.isProcessEmailAsMsg(), xhtml, metadata, parseContext));
    }

    private ProcessBuilder getProcessBuilder(Path pst, LibPstParserConfig config, Path outDir, Path debugFile) throws TikaConfigException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getFullReadPstCommand());
        if (config.isDebug()) {
            commands.add("-d");
            commands.add(ProcessUtils.escapeCommandLine((String)debugFile.toAbsolutePath().toString()));
        }
        if (config.isIncludeDeleted()) {
            commands.add("-D");
        }
        if (config.isProcessEmailAsMsg()) {
            commands.add("-m");
        } else {
            commands.add("-e");
        }
        commands.add("-o");
        commands.add(ProcessUtils.escapeCommandLine((String)outDir.toAbsolutePath().toString()));
        commands.add(ProcessUtils.escapeCommandLine((String)pst.toAbsolutePath().toString()));
        LOGGER.debug("command arguments: " + commands);
        return new ProcessBuilder(commands);
    }

    public void initialize(Map<String, Param> map) throws TikaConfigException {
        if (this.readPstPath.contains("\u0000")) {
            throw new TikaConfigException("path can't include null values");
        }
        String fullReadPstCommand = this.getFullReadPstCommand();
        if (!Files.isRegularFile(Paths.get(fullReadPstCommand, new String[0]), new LinkOption[0])) {
            throw new TikaConfigException("I regret I can't find the readpst executable: " + fullReadPstCommand);
        }
        try {
            this.check();
        }
        catch (IOException e) {
            LOGGER.error("Couldn't get version of libpst", (Throwable)e);
            throw new TikaConfigException("Unable to check version of readpst. Is it installed?!", (Throwable)e);
        }
    }

    public void checkInitialization(InitializableProblemHandler initializableProblemHandler) throws TikaConfigException {
    }

    private void check() throws TikaConfigException, IOException {
        String fullReadPstCommand = this.getFullReadPstCommand();
        ProcessBuilder pb = new ProcessBuilder(ProcessUtils.escapeCommandLine((String)fullReadPstCommand), "-V");
        FileProcessResult result = ProcessUtils.execute((ProcessBuilder)pb, (long)30000L, (int)10000, (int)10000);
        if (result.getExitValue() != 0) {
            throw new TikaConfigException("bad exit value for LibPstParser. It must be installed and on the path if this parser is configured. Exit value: " + result.getExitValue());
        }
        if (result.isTimeout()) {
            throw new TikaConfigException("timeout trying to get version from readpst?!");
        }
    }

    public boolean checkQuietly() {
        try {
            this.check();
        }
        catch (IOException | TikaConfigException e) {
            return false;
        }
        return true;
    }

    private String getFullReadPstCommand() throws TikaConfigException {
        if (StringUtils.isBlank((String)this.readPstPath)) {
            return READ_PST_COMMAND;
        }
        if (!this.readPstPath.endsWith("/") && this.readPstPath.endsWith("\\")) {
            return this.readPstPath + "/readpst";
        }
        return this.readPstPath + READ_PST_COMMAND;
    }

    @Field
    public void setTimeoutSeconds(long timeoutSeconds) {
        this.defaultConfig.setTimeoutSeconds(timeoutSeconds);
    }

    @Field
    public void setProcessEmailAsMsg(boolean processEmailAsMsg) {
        this.defaultConfig.setProcessEmailAsMsg(processEmailAsMsg);
    }

    @Field
    public void setIncludeDeleted(boolean includeDeleted) {
        this.defaultConfig.setIncludeDeleted(includeDeleted);
    }

    @Field
    public void setMaxEmails(int maxEmails) {
        this.defaultConfig.setMaxEmails(maxEmails);
    }

    @Field
    public void setReadPstPath(String readPstPath) {
        this.readPstPath = readPstPath;
    }
}

