/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mbox;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.mailcommons.MailDateParser;
import org.apache.tika.parser.mailcommons.MailUtil;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MboxParser
implements Parser {
    public static final String MBOX_MIME_TYPE = "application/mbox";
    public static final String MBOX_RECORD_DIVIDER = "From ";
    public static final int MAIL_MAX_SIZE = 50000000;
    private static final long serialVersionUID = -1762689436731160661L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"mbox"));
    private static final Pattern EMAIL_HEADER_PATTERN = Pattern.compile("([^ ]+):[ \t]*(.*)");
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("<(.*@.*)>");
    private static final String EMAIL_HEADER_METADATA_PREFIX = "MboxParser-";
    private static final String EMAIL_FROMLINE_METADATA = "MboxParser-from";
    private final Map<Integer, Metadata> trackingMetadata = new HashMap<Integer, Metadata>();
    private boolean tracking = false;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        EmbeddedDocumentExtractor extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        String charsetName = "windows-1252";
        metadata.set("Content-Type", MBOX_MIME_TYPE);
        metadata.set("Content-Encoding", charsetName);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        InputStreamReader isr = new InputStreamReader(stream, charsetName);
        try (BufferedReader reader = new BufferedReader(isr);){
            String curLine = reader.readLine();
            int mailItem = 0;
            do {
                if (curLine.startsWith(MBOX_RECORD_DIVIDER)) {
                    Metadata mailMetadata = new Metadata();
                    LinkedList<Object> multiline = new LinkedList<Object>();
                    mailMetadata.add(EMAIL_FROMLINE_METADATA, curLine.substring(MBOX_RECORD_DIVIDER.length()));
                    mailMetadata.set("Content-Type", "message/rfc822");
                    mailMetadata.set(TikaCoreProperties.CONTENT_TYPE_PARSER_OVERRIDE, "message/rfc822");
                    curLine = reader.readLine();
                    if (curLine == null) {
                        break;
                    }
                    UnsynchronizedByteArrayOutputStream message = new UnsynchronizedByteArrayOutputStream(100000);
                    do {
                        if (curLine.startsWith(" ") || curLine.startsWith("\t")) {
                            Iterator latestLine = (String)multiline.poll();
                            latestLine = (String)((Object)latestLine) + " " + curLine.trim();
                            multiline.add(latestLine);
                        } else {
                            multiline.add(curLine);
                        }
                        message.write(curLine.getBytes(charsetName));
                        message.write(10);
                    } while ((curLine = reader.readLine()) != null && !curLine.startsWith(MBOX_RECORD_DIVIDER) && message.size() < 50000000);
                    for (String string : multiline) {
                        this.saveHeaderInMetadata(mailMetadata, string);
                    }
                    InputStream messageStream = message.toInputStream();
                    message = null;
                    if (extractor.shouldParseEmbedded(mailMetadata)) {
                        extractor.parseEmbedded(messageStream, (ContentHandler)xhtml, mailMetadata, true);
                    }
                    if (!this.tracking) continue;
                    this.getTrackingMetadata().put(mailItem++, mailMetadata);
                    continue;
                }
                curLine = reader.readLine();
            } while (curLine != null && !Thread.currentThread().isInterrupted());
        }
        xhtml.endDocument();
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void setTracking(boolean tracking) {
        this.tracking = tracking;
    }

    public Map<Integer, Metadata> getTrackingMetadata() {
        return this.trackingMetadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveHeaderInMetadata(Metadata metadata, String curLine) {
        Matcher headerMatcher = EMAIL_HEADER_PATTERN.matcher(curLine);
        if (!headerMatcher.matches()) {
            return;
        }
        String headerTag = headerMatcher.group(1).toLowerCase(Locale.ROOT);
        String headerContent = headerMatcher.group(2);
        if (headerTag.equalsIgnoreCase("From")) {
            metadata.set(TikaCoreProperties.CREATOR, headerContent);
            MailUtil.setPersonAndEmail((String)headerContent, (Property)Message.MESSAGE_FROM_NAME, (Property)Message.MESSAGE_FROM_EMAIL, (Metadata)metadata);
            return;
        } else if (headerTag.equalsIgnoreCase("To") || headerTag.equalsIgnoreCase("Cc") || headerTag.equalsIgnoreCase("Bcc")) {
            Matcher address = EMAIL_ADDRESS_PATTERN.matcher(headerContent);
            if (address.find()) {
                metadata.add("Message-Recipient-Address", address.group(1));
            } else if (headerContent.indexOf(64) > -1) {
                metadata.add("Message-Recipient-Address", headerContent);
            }
            String property = "Message-To";
            if (headerTag.equalsIgnoreCase("Cc")) {
                property = "Message-Cc";
            } else if (headerTag.equalsIgnoreCase("Bcc")) {
                property = "Message-Bcc";
            }
            metadata.add(property, headerContent);
            return;
        } else if (headerTag.equalsIgnoreCase("Subject")) {
            metadata.add(TikaCoreProperties.SUBJECT, headerContent);
            return;
        } else if (headerTag.equalsIgnoreCase("Date")) {
            try {
                Date date = MailDateParser.parseDateLenient((String)headerContent);
                if (date == null) return;
                metadata.set(TikaCoreProperties.CREATED, date);
                return;
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception exception) {
                return;
            }
        } else if (headerTag.equalsIgnoreCase("Message-Id")) {
            metadata.set(TikaCoreProperties.IDENTIFIER, headerContent);
            return;
        } else if (headerTag.equalsIgnoreCase("In-Reply-To")) {
            metadata.set(TikaCoreProperties.RELATION, headerContent);
            return;
        } else if (headerTag.equalsIgnoreCase("Content-Type")) {
            metadata.add("Content-Type", headerContent);
            metadata.set(TikaCoreProperties.FORMAT, headerContent);
            return;
        } else {
            metadata.add(EMAIL_HEADER_METADATA_PREFIX + headerTag, headerContent);
        }
    }
}

