/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.langdetect;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public abstract class LanguageDetectorTest {
    protected String[] getTestLanguages() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream is = this.getClass().getResourceAsStream("language-codes.txt");){
            List lines = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
            for (String line : lines) {
                String[] parsed;
                String language;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || !this.hasTestLanguage(language = (parsed = line.split("\t"))[0])) continue;
                result.add(language);
            }
            String[] stringArray = result.toArray(new String[0]);
            return stringArray;
        }
    }

    protected boolean hasTestLanguage(String language) {
        InputStream stream = LanguageDetectorTest.class.getResourceAsStream("/language-tests/" + language + ".test");
        if (stream != null) {
            IOUtils.closeQuietly((InputStream)stream);
            return true;
        }
        return false;
    }

    protected void writeTo(String language, Writer writer) throws IOException {
        this.writeTo(language, writer, Integer.MAX_VALUE);
    }

    protected void writeTo(String language, Writer writer, int limit) throws IOException {
        try (InputStream stream = LanguageDetectorTest.class.getResourceAsStream("/language-tests/" + language + ".test");){
            this.copyAtMost(new InputStreamReader(stream, StandardCharsets.UTF_8), writer, limit);
        }
    }

    protected int copyAtMost(Reader input, Writer output, int limit) throws IOException {
        int count;
        int bytesToCopy;
        char[] buffer = new char[4096];
        int n = 0;
        for (count = 0; -1 != (n = input.read(buffer)) && count < limit; count += bytesToCopy) {
            bytesToCopy = Math.min(limit - count, n);
            output.write(buffer, 0, bytesToCopy);
        }
        return count;
    }
}

