/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.general;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.fuzzing.general.ByteDeleter;
import org.apache.tika.fuzzing.general.ByteFlipper;
import org.apache.tika.fuzzing.general.ByteInjector;
import org.apache.tika.fuzzing.general.SpanSwapper;
import org.apache.tika.fuzzing.general.Truncator;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralTransformer
implements Transformer {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralTransformer.class);
    private final int maxTransforms;
    private final Transformer[] transformers;
    private final Set<MediaType> supportedTypes;
    Random random = new Random();

    public GeneralTransformer() {
        this(new ByteDeleter(), new ByteFlipper(), new ByteInjector(), new Truncator(), new SpanSwapper());
    }

    public GeneralTransformer(Transformer ... transformers) {
        this(transformers.length, transformers);
    }

    public GeneralTransformer(int maxTransforms, Transformer ... transformers) {
        this.maxTransforms = maxTransforms < 0 ? transformers.length : maxTransforms;
        this.transformers = transformers;
        HashSet<MediaType> tmpTypes = new HashSet<MediaType>();
        for (Transformer transformer : transformers) {
            tmpTypes.addAll(transformer.getSupportedTypes());
        }
        this.supportedTypes = Collections.unmodifiableSet(tmpTypes);
    }

    @Override
    public Set<MediaType> getSupportedTypes() {
        return this.supportedTypes;
    }

    @Override
    public void transform(InputStream is, OutputStream os) throws IOException, TikaException {
        if (this.maxTransforms == 0) {
            IOUtils.copy((InputStream)is, (OutputStream)os);
            return;
        }
        int transformerCount = this.maxTransforms == 1 ? 1 : 1 + this.random.nextInt(this.maxTransforms);
        int[] transformerIndices = new int[transformerCount];
        for (int i = 0; i < transformerCount; ++i) {
            transformerIndices[i] = this.random.nextInt(this.transformers.length);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        for (int transformerIndex : transformerIndices) {
            byte[] bytes = bos.toByteArray();
            bos = new ByteArrayOutputStream();
            this.transformers[transformerIndex].transform(new ByteArrayInputStream(bytes), bos);
            bos.flush();
            if (bos.toByteArray().length != 0) continue;
            LOG.warn("zero length: " + String.valueOf(this.transformers[transformerIndex]));
        }
        os.write(bos.toByteArray());
    }
}

