/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class FuzzingCLIConfig {
    private static final int DEFAULT_NUM_ITERATIONS = 100;
    private static final int DEFAULT_MAX_TRANSFORMERS = 1;
    private static final int DEFAULT_RETRIES = 1;
    static Options OPTIONS;
    int perFileIterations = 100;
    int maxTransformers = 1;
    long timeoutMS;
    int retries = 1;
    Path tikaConfig;
    Path problemsDir;

    public static FuzzingCLIConfig parse(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(OPTIONS, args);
        FuzzingCLIConfig config = new FuzzingCLIConfig();
        config.tikaConfig = Paths.get(commandLine.getOptionValue("c"), new String[0]);
        config.problemsDir = Paths.get(commandLine.getOptionValue("o"), new String[0]);
        config.retries = commandLine.hasOption("r") ? Integer.parseInt(commandLine.getOptionValue("r")) : 1;
        config.maxTransformers = commandLine.hasOption("t") ? Integer.parseInt(commandLine.getOptionValue("t")) : 1;
        return config;
    }

    public Path getProblemsDirectory() {
        return this.problemsDir;
    }

    public Path getTikaConfig() {
        return this.tikaConfig;
    }

    public int getMaxTransformers() {
        return this.maxTransformers;
    }

    public int getPerFileIterations() {
        return this.perFileIterations;
    }

    public int getRetries() {
        return this.retries;
    }

    static {
        Option problems = new Option("o", "output", true, "directory for problems files");
        problems.setRequired(true);
        OPTIONS = new Options().addOption(problems).addOption(Option.builder((String)"c").longOpt("config").hasArg(true).desc("tika config file with specs for pipes parser, pipes iterator, fetchers and emitters").required(true).build()).addOption(Option.builder((String)"p").longOpt("perFile").desc("number of iterations to run per seed file").hasArg(true).required(false).build()).addOption(Option.builder((String)"t").longOpt("maxTransformers").desc("maximum number of transformers to run per iteration").hasArg(true).required(false).build()).addOption(Option.builder((String)"r").longOpt("retries").desc("number of times to retry a seed file if there's a catastrophic failure").hasArg(true).required(false).build());
    }
}

