/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.pdf;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFXRefStream;
import org.apache.pdfbox.pdfparser.xref.FreeXReference;
import org.apache.pdfbox.pdfparser.xref.NormalXReference;
import org.apache.pdfbox.pdfparser.xref.XReferenceEntry;
import org.apache.pdfbox.pdfwriter.COSStandardOutputStream;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.COSFilterInputStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.util.Hex;
import org.apache.tika.exception.TikaException;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.fuzzing.pdf.PDFTransformerConfig;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvilCOSWriter
implements ICOSVisitor,
Closeable {
    public static final byte[] DICT_OPEN = "<<".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] DICT_CLOSE = ">>".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] COMMENT = new byte[]{37};
    public static final byte[] VERSION = "PDF-1.4".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] GARBAGE = new byte[]{-10, -28, -4, -33};
    public static final byte[] EOF = "%%EOF".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] REFERENCE = "R".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF = "xref".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF_FREE = "f".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] XREF_USED = "n".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] TRAILER = "trailer".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] STARTXREF = "startxref".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] OBJ = "obj".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ENDOBJ = "endobj".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ARRAY_OPEN = "[".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ARRAY_CLOSE = "]".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] STREAM = "stream".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] ENDSTREAM = "endstream".getBytes(StandardCharsets.US_ASCII);
    private static final Logger LOG = LoggerFactory.getLogger(EvilCOSWriter.class);
    private final NumberFormat formatXrefOffset = new DecimalFormat("0000000000", DecimalFormatSymbols.getInstance(Locale.US));
    private final NumberFormat formatXrefGeneration = new DecimalFormat("00000", DecimalFormatSymbols.getInstance(Locale.US));
    private final Map<COSBase, COSObjectKey> objectKeys = new Hashtable<COSBase, COSObjectKey>();
    private final Map<COSObjectKey, COSBase> keyObject = new HashMap<COSObjectKey, COSBase>();
    private final List<XReferenceEntry> xRefEntries = new ArrayList<XReferenceEntry>();
    private final Set<COSBase> objectsToWriteSet = new HashSet<COSBase>();
    private final Deque<COSBase> objectsToWrite = new LinkedList<COSBase>();
    private final Set<COSBase> writtenObjects = new HashSet<COSBase>();
    private final Set<COSBase> actualsAdded = new HashSet<COSBase>();
    private final PDFTransformerConfig config;
    private final Random random = new Random();
    private OutputStream output;
    private COSStandardOutputStream standardOutput;
    private long startxref = 0L;
    private long number = 0L;
    private int roughNumberOfObjects = 0;
    private COSObjectKey currentObjectKey = null;
    private PDDocument pdDocument = null;
    private FDFDocument fdfDocument = null;
    private boolean willEncrypt = false;
    private final boolean incrementalUpdate = false;
    private boolean reachedSignature = false;
    private long signatureOffset;
    private long signatureLength;
    private long byteRangeOffset;
    private long byteRangeLength;
    private RandomAccessRead incrementalInput;
    private OutputStream incrementalOutput;
    private SignatureInterface signatureInterface;
    private byte[] incrementPart;
    private COSArray byteRangeArray;
    private final FilterFactory filterFactory = FilterFactory.INSTANCE;

    public EvilCOSWriter(OutputStream outputStream, PDFTransformerConfig config) {
        this.setOutput(outputStream);
        this.setStandardOutput(new COSStandardOutputStream(this.output));
        this.config = config;
    }

    public static void writeString(COSString string, OutputStream output) throws IOException {
        EvilCOSWriter.writeString(string.getBytes(), string.getForceHexForm(), output);
    }

    public static void writeString(byte[] bytes, OutputStream output) throws IOException {
        EvilCOSWriter.writeString(bytes, false, output);
    }

    private static void writeString(byte[] bytes, boolean forceHex, OutputStream output) throws IOException {
        boolean isASCII = true;
        if (!forceHex) {
            for (byte b : bytes) {
                if (b < 0) {
                    isASCII = false;
                    break;
                }
                if (b != 13 && b != 10) continue;
                isASCII = false;
                break;
            }
        }
        if (isASCII && !forceHex) {
            output.write(40);
            block4: for (byte b : bytes) {
                switch (b) {
                    case 40: 
                    case 41: 
                    case 92: {
                        output.write(92);
                        output.write(b);
                        continue block4;
                    }
                    default: {
                        output.write(b);
                    }
                }
            }
            output.write(41);
        } else {
            output.write(60);
            Hex.writeHexBytes((byte[])bytes, (OutputStream)output);
            output.write(62);
        }
    }

    private void prepareIncrement(PDDocument doc) throws IOException {
        if (doc != null) {
            COSDocument cosDoc = doc.getDocument();
            Map xrefTable = cosDoc.getXrefTable();
            Set keySet = xrefTable.keySet();
            long highestNumber = doc.getDocument().getHighestXRefObjectNumber();
            for (COSObjectKey cosObjectKey : keySet) {
                long num;
                COSBase object = cosDoc.getObjectFromPool(cosObjectKey).getObject();
                if (object != null && cosObjectKey != null && !(object instanceof COSNumber)) {
                    this.objectKeys.put(object, cosObjectKey);
                    this.keyObject.put(cosObjectKey, object);
                }
                if (cosObjectKey == null || (num = cosObjectKey.getNumber()) <= highestNumber) continue;
                highestNumber = num;
            }
            this.setNumber(highestNumber);
        }
    }

    protected void addXRefEntry(XReferenceEntry entry) {
        this.getXRefEntries().add(entry);
    }

    @Override
    public void close() throws IOException {
        if (this.getStandardOutput() != null) {
            this.getStandardOutput().close();
        }
        if (this.incrementalOutput != null) {
            this.incrementalOutput.close();
        }
    }

    protected long getNumber() {
        return this.number;
    }

    protected void setNumber(long newNumber) {
        this.number = newNumber;
    }

    public Map<COSBase, COSObjectKey> getObjectKeys() {
        return this.objectKeys;
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    private void setOutput(OutputStream newOutput) {
        this.output = newOutput;
    }

    protected COSStandardOutputStream getStandardOutput() {
        return this.standardOutput;
    }

    private void setStandardOutput(COSStandardOutputStream newStandardOutput) {
        this.standardOutput = newStandardOutput;
    }

    protected long getStartxref() {
        return this.startxref;
    }

    protected void setStartxref(long newStartxref) {
        this.startxref = newStartxref;
    }

    protected List<XReferenceEntry> getXRefEntries() {
        return this.xRefEntries;
    }

    protected void doWriteBody(COSDocument doc) throws IOException {
        COSDictionary trailer = doc.getTrailer();
        COSDictionary root = trailer.getCOSDictionary(COSName.ROOT);
        COSDictionary info = trailer.getCOSDictionary(COSName.INFO);
        COSDictionary encrypt = trailer.getCOSDictionary(COSName.ENCRYPT);
        this.roughNumberOfObjects = doc.getXrefTable().size();
        if (root != null) {
            this.addObjectToWrite((COSBase)root);
        }
        if (info != null) {
            this.addObjectToWrite((COSBase)info);
        }
        this.doWriteObjects();
        this.willEncrypt = false;
        if (encrypt != null) {
            this.addObjectToWrite((COSBase)encrypt);
        }
        this.doWriteObjects();
    }

    private void doWriteObjects() throws IOException {
        while (this.objectsToWrite.size() > 0) {
            COSBase nextObject = this.objectsToWrite.removeFirst();
            this.objectsToWriteSet.remove(nextObject);
            this.doWriteObject(nextObject);
        }
    }

    private void addObjectToWrite(COSBase object) {
        COSBase actual = object;
        if (actual instanceof COSObject) {
            actual = ((COSObject)actual).getObject();
        }
        if (!(this.writtenObjects.contains(object) || this.objectsToWriteSet.contains(object) || this.actualsAdded.contains(actual))) {
            COSBase cosBase = null;
            COSObjectKey cosObjectKey = null;
            if (actual != null) {
                cosObjectKey = this.objectKeys.get(actual);
            }
            if (cosObjectKey != null) {
                cosBase = this.keyObject.get(cosObjectKey);
            }
            if (actual != null && this.objectKeys.containsKey(actual) && object instanceof COSUpdateInfo && !((COSUpdateInfo)object).isNeedToBeUpdated() && cosBase instanceof COSUpdateInfo && !((COSUpdateInfo)cosBase).isNeedToBeUpdated()) {
                return;
            }
            this.objectsToWrite.add(object);
            this.objectsToWriteSet.add(object);
            if (actual != null) {
                this.actualsAdded.add(actual);
            }
        }
    }

    public void doWriteObject(COSBase obj) throws IOException {
        this.writtenObjects.add(obj);
        this.currentObjectKey = this.getObjectKey(obj);
        this.doWriteObject(this.currentObjectKey, obj);
    }

    public void doWriteObject(COSObjectKey key, COSBase obj) throws IOException {
        if (obj == null || obj instanceof COSObject && ((COSObject)obj).getObject() == null) {
            return;
        }
        this.writtenObjects.add(obj);
        this.currentObjectKey = this.getObjectKey(obj);
        this.addXRefEntry((XReferenceEntry)new NormalXReference(this.getStandardOutput().getPos(), key, obj));
        long objectNumber = this.currentObjectKey.getNumber();
        if (this.config.getRandomizeObjectNumbers() > 0.0f && this.random.nextFloat() < this.config.getRandomizeObjectNumbers()) {
            objectNumber = this.random.nextInt((int)objectNumber * 2);
        }
        this.getStandardOutput().write(Long.toString(objectNumber).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(OBJ);
        this.getStandardOutput().writeEOL();
        this.mutate(obj);
        if (obj != null) {
            this.writeObjContents(obj);
        }
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(ENDOBJ);
        this.getStandardOutput().writeEOL();
    }

    private void writeObjContents(COSBase obj) throws IOException {
        if (!(obj instanceof COSObject)) {
            obj.accept((ICOSVisitor)this);
            return;
        }
        COSObject cosObject = (COSObject)obj;
        COSBase underlyingObject = cosObject.getObject();
        if (underlyingObject instanceof COSStream && this.config.getUnfilteredStreamTransformer() != null) {
            COSStream cosStream = (COSStream)underlyingObject;
            Transformer unfilteredStreamTransformer = this.config.getUnfilteredStreamTransformer();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (InputStream is = cosStream.createRawInputStream();){
                IOUtils.copy((InputStream)is, (OutputStream)bos);
            }
            ByteArrayOutputStream transformed = new ByteArrayOutputStream();
            try {
                unfilteredStreamTransformer.transform(new ByteArrayInputStream(bos.toByteArray()), transformed);
            }
            catch (TikaException e) {
                throw new IOException(e);
            }
            try (OutputStream os = cosStream.createRawOutputStream();){
                IOUtils.copy((InputStream)new ByteArrayInputStream(transformed.toByteArray()), (OutputStream)os);
            }
            obj.accept((ICOSVisitor)this);
        } else {
            obj.accept((ICOSVisitor)this);
        }
    }

    private void mutate(COSBase obj) throws IOException {
        if (obj instanceof COSStream) {
            COSBase filters;
            COSStream stream = (COSStream)obj;
            byte[] bytes = new PDStream(stream).toByteArray();
            if (this.config.getStreamTransformer() != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    this.config.getStreamTransformer().transform(new ByteArrayInputStream(bytes), bos);
                }
                catch (TikaException e) {
                    throw new IOException(e);
                }
                bytes = bos.toByteArray();
            }
            if ((filters = this.getFilters(stream.getFilters())) instanceof COSNull) {
                stream.removeItem(COSName.FILTER);
            } else {
                ArrayList<COSName> usedFilters = new ArrayList<COSName>();
                long length = -1L;
                try (TikaInputStream rawBytes = TikaInputStream.get((byte[])bytes);
                     TikaInputStream filtered = this.runFilters(filters, rawBytes, usedFilters);){
                    try (OutputStream streamOut = stream.createRawOutputStream();){
                        IOUtils.copy((InputStream)filtered, (OutputStream)streamOut);
                    }
                    length = filtered.getLength();
                }
                Collections.reverse(usedFilters);
                COSArray actualFilters = new COSArray();
                for (COSName f : usedFilters) {
                    actualFilters.add((COSBase)f);
                }
                stream.setLong(COSName.LENGTH, length);
                stream.setItem(COSName.FILTER, (COSBase)actualFilters);
            }
        } else if (obj instanceof COSObject) {
            COSBase underlyingObject = ((COSObject)obj).getObject();
            this.mutate(underlyingObject);
        }
    }

    private TikaInputStream runFilters(COSBase filters, TikaInputStream is, List<COSName> usedFilters) throws IOException {
        if (!(filters instanceof COSNull)) {
            if (filters instanceof COSName) {
                is = this.runFilter((COSName)filters, is, new COSDictionary(), 0);
                usedFilters.add((COSName)filters);
                LOG.debug("filter:" + filters + " 0 : " + is.getLength());
            } else {
                if (filters instanceof COSArray) {
                    COSArray filterArray = (COSArray)filters;
                    boolean transformed = false;
                    for (int i = filterArray.size() - 1; i >= 0; --i) {
                        COSName filter = (COSName)filterArray.get(i);
                        is = this.runFilter(filter, is, new COSDictionary(), 0);
                        if ((double)this.random.nextFloat() > 0.1 && !transformed) {
                            is = this.transformRawStream(is);
                            transformed = true;
                        }
                        usedFilters.add(filter);
                        LOG.debug("filter:" + filter.toString() + " " + i + " : " + is.getLength());
                        if (is.getLength() <= this.config.getMaxFilteredStreamLength()) continue;
                        LOG.debug("stopping early");
                        return is;
                    }
                    return is;
                }
                throw new IllegalArgumentException("Can't handle this class here: " + filters.getClass());
            }
        }
        return this.transformRawStream(is);
    }

    private TikaInputStream transformRawStream(TikaInputStream is) throws IOException {
        if (this.config.getUnfilteredStreamTransformer() != null) {
            if (is.getLength() < 10000000L) {
                TikaInputStream tikaInputStream;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    this.config.getUnfilteredStreamTransformer().transform((InputStream)is, bos);
                    bos.flush();
                    bos.close();
                    tikaInputStream = TikaInputStream.get((byte[])bos.toByteArray());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (TikaException e) {
                        throw new IOException(e);
                    }
                }
                bos.close();
                return tikaInputStream;
            }
            TemporaryResources tmp = new TemporaryResources();
            Path p = tmp.createTempFile();
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
                this.config.getUnfilteredStreamTransformer().transform((InputStream)is, os);
                ((OutputStream)os).flush();
            }
            catch (TikaException e) {
                throw new IOException(e);
            }
            return TikaInputStream.get((Path)p, (Metadata)new Metadata(), (TemporaryResources)tmp);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TikaInputStream runFilter(COSName filterCOSName, TikaInputStream tis, COSDictionary filterParameters, int filterIndex) throws IOException {
        Filter filter = this.filterFactory.getFilter(filterCOSName);
        if (tis.getLength() < 100000000L) {
            try {
                TikaInputStream tikaInputStream;
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    filter.encode((InputStream)tis, (OutputStream)bos, filterParameters, filterIndex);
                    bos.flush();
                    bos.close();
                    tikaInputStream = TikaInputStream.get((byte[])bos.toByteArray());
                }
                return tikaInputStream;
            }
            finally {
                tis.close();
            }
        }
        TemporaryResources tmp = new TemporaryResources();
        Path p = tmp.createTempFile();
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            filter.encode((InputStream)tis, (OutputStream)os, filterParameters, filterIndex);
        }
        finally {
            tis.close();
        }
        return TikaInputStream.get((Path)p, (Metadata)new Metadata(), (TemporaryResources)tmp);
    }

    private COSBase getFilters(COSBase existingFilters) {
        List<COSName> filters = this.config.getFilters(existingFilters);
        if (filters.size() == 0) {
            return COSNull.NULL;
        }
        if (filters.size() == 1) {
            return (COSBase)filters.get(0);
        }
        COSArray arr = new COSArray();
        for (COSName n : filters) {
            arr.add((COSBase)n);
        }
        return arr;
    }

    protected void doWriteHeader(COSDocument doc) throws IOException {
        String headerString = this.fdfDocument != null ? "%FDF-" + doc.getVersion() : "%PDF-" + doc.getVersion();
        this.getStandardOutput().write(headerString.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(COMMENT);
        this.getStandardOutput().write(GARBAGE);
        this.getStandardOutput().writeEOL();
    }

    protected void doWriteTrailer(COSDocument doc) throws IOException {
        this.getStandardOutput().write(TRAILER);
        this.getStandardOutput().writeEOL();
        COSDictionary trailer = doc.getTrailer();
        Collections.sort(this.getXRefEntries());
        XReferenceEntry lastEntry = this.getXRefEntries().get(this.getXRefEntries().size() - 1);
        trailer.setLong(COSName.SIZE, lastEntry.getReferencedKey().getNumber() + 1L);
        trailer.removeItem(COSName.PREV);
        if (!doc.isXRefStream()) {
            trailer.removeItem(COSName.XREF_STM);
        }
        trailer.removeItem(COSName.DOC_CHECKSUM);
        COSArray idArray = trailer.getCOSArray(COSName.ID);
        if (idArray != null) {
            idArray.setDirect(true);
        }
        trailer.accept((ICOSVisitor)this);
    }

    private void doWriteXRefInc(COSDocument doc, long hybridPrev) throws IOException {
        if (doc.isXRefStream() || hybridPrev != -1L) {
            PDFXRefStream pdfxRefStream = new PDFXRefStream(doc);
            List<XReferenceEntry> xRefEntries2 = this.getXRefEntries();
            for (XReferenceEntry cosWriterXRefEntry : xRefEntries2) {
                pdfxRefStream.addEntry(cosWriterXRefEntry);
            }
            COSDictionary trailer = doc.getTrailer();
            trailer.removeItem(COSName.PREV);
            pdfxRefStream.addTrailerInfo(trailer);
            pdfxRefStream.setSize(this.getNumber() + 2L);
            this.setStartxref(this.getStandardOutput().getPos());
            COSStream stream2 = pdfxRefStream.getStream();
            this.doWriteObject((COSBase)stream2);
        }
        if (!doc.isXRefStream() || hybridPrev != -1L) {
            COSDictionary trailer = doc.getTrailer();
            trailer.setLong(COSName.PREV, doc.getStartXref());
            if (hybridPrev != -1L) {
                COSName xrefStm = COSName.XREF_STM;
                trailer.removeItem(xrefStm);
                trailer.setLong(xrefStm, this.getStartxref());
            }
            this.doWriteXRefTable();
            this.doWriteTrailer(doc);
        }
    }

    private void doWriteXRefTable() throws IOException {
        this.addXRefEntry((XReferenceEntry)FreeXReference.NULL_ENTRY);
        Collections.sort(this.getXRefEntries());
        this.setStartxref(this.getStandardOutput().getPos());
        this.getStandardOutput().write(XREF);
        this.getStandardOutput().writeEOL();
        Long[] xRefRanges = this.getXRefRanges(this.getXRefEntries());
        int xRefLength = xRefRanges.length;
        int j = 0;
        for (int x = 0; x < xRefLength && xRefLength % 2 == 0; x += 2) {
            this.writeXrefRange(xRefRanges[x], xRefRanges[x + 1]);
            int i = 0;
            while ((long)i < xRefRanges[x + 1]) {
                this.writeXrefEntry(this.xRefEntries.get(j++));
                ++i;
            }
        }
    }

    private void doWriteIncrement() throws IOException {
        IOUtils.copy((InputStream)new RandomAccessInputStream(this.incrementalInput), (OutputStream)this.incrementalOutput);
        this.incrementalOutput.write(this.getBytes(this.output));
    }

    private void doWriteSignature() throws IOException {
        long inLength = this.incrementalInput.length();
        long beforeLength = this.signatureOffset;
        long afterOffset = this.signatureOffset + this.signatureLength;
        long afterLength = this.getStandardOutput().getPos() - (inLength + this.signatureLength) - (this.signatureOffset - inLength);
        String byteRange = "0 " + beforeLength + " " + afterOffset + " " + afterLength + "]";
        this.byteRangeArray.set(0, (COSBase)COSInteger.ZERO);
        this.byteRangeArray.set(1, (COSBase)COSInteger.get((long)beforeLength));
        this.byteRangeArray.set(2, (COSBase)COSInteger.get((long)afterOffset));
        this.byteRangeArray.set(3, (COSBase)COSInteger.get((long)afterLength));
        if ((long)byteRange.length() > this.byteRangeLength) {
            throw new IOException("Can't write new byteRange '" + byteRange + "' not enough space: byteRange.length(): " + byteRange.length() + ", byteRangeLength: " + this.byteRangeLength);
        }
        this.output.flush();
        this.incrementPart = this.getBytes(this.output);
        byte[] byteRangeBytes = byteRange.getBytes(StandardCharsets.ISO_8859_1);
        int i = 0;
        while ((long)i < this.byteRangeLength) {
            this.incrementPart[(int)(this.byteRangeOffset + (long)i - inLength)] = i >= byteRangeBytes.length ? 32 : byteRangeBytes[i];
            ++i;
        }
        if (this.signatureInterface != null) {
            try (InputStream dataToSign = this.getDataToSign();){
                byte[] signatureBytes = this.signatureInterface.sign(dataToSign);
                this.writeExternalSignature(signatureBytes);
            }
        }
    }

    public InputStream getDataToSign() throws IOException {
        if (this.incrementPart == null || this.incrementalInput == null) {
            throw new IllegalStateException("PDF not prepared for signing");
        }
        int incPartSigOffset = (int)(this.signatureOffset - this.incrementalInput.length());
        int afterSigOffset = incPartSigOffset + (int)this.signatureLength;
        int[] range = new int[]{0, incPartSigOffset, afterSigOffset, this.incrementPart.length - afterSigOffset};
        return new SequenceInputStream((InputStream)new RandomAccessInputStream(this.incrementalInput), (InputStream)new COSFilterInputStream(this.incrementPart, range));
    }

    public void writeExternalSignature(byte[] cmsSignature) throws IOException {
        if (this.incrementPart == null || this.incrementalInput == null) {
            throw new IllegalStateException("PDF not prepared for setting signature");
        }
        byte[] signatureBytes = Hex.getBytes((byte[])cmsSignature);
        if ((long)signatureBytes.length > this.signatureLength - 2L) {
            throw new IOException("Can't write signature, not enough space");
        }
        int incPartSigOffset = (int)(this.signatureOffset - this.incrementalInput.length());
        System.arraycopy(signatureBytes, 0, this.incrementPart, incPartSigOffset + 1, signatureBytes.length);
        IOUtils.copy((InputStream)new RandomAccessInputStream(this.incrementalInput), (OutputStream)this.incrementalOutput);
        this.incrementalOutput.write(this.incrementPart);
        this.incrementPart = null;
    }

    private void writeXrefRange(long x, long y) throws IOException {
        this.getStandardOutput().write(String.valueOf(x).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(y).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
    }

    private void writeXrefEntry(XReferenceEntry entry) throws IOException {
        String offset = this.formatXrefOffset.format(entry.getSecondColumnValue());
        String generation = this.formatXrefGeneration.format(entry.getThirdColumnValue());
        this.getStandardOutput().write(offset.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(generation.getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(entry instanceof FreeXReference ? XREF_FREE : XREF_USED);
        this.getStandardOutput().writeCRLF();
    }

    protected Long[] getXRefRanges(List<XReferenceEntry> xRefEntriesList) {
        long last = -2L;
        long count = 1L;
        ArrayList<Long> list = new ArrayList<Long>();
        for (XReferenceEntry object : xRefEntriesList) {
            long nr = (int)object.getReferencedKey().getNumber();
            if (nr == last + 1L) {
                ++count;
                last = nr;
                continue;
            }
            if (last == -2L) {
                last = nr;
                continue;
            }
            list.add(last - count + 1L);
            list.add(count);
            last = nr;
            count = 1L;
        }
        if (xRefEntriesList.size() > 0) {
            list.add(last - count + 1L);
            list.add(count);
        }
        return list.toArray(new Long[0]);
    }

    private COSObjectKey getObjectKey(COSBase obj) {
        COSObjectKey key;
        COSBase actual = obj;
        if (actual instanceof COSObject) {
            actual = ((COSObject)obj).getObject();
        }
        if ((key = this.objectKeys.get(obj)) == null && actual != null) {
            key = this.objectKeys.get(actual);
        }
        if (key == null) {
            this.setNumber(this.getNumber() + 1L);
            key = new COSObjectKey(this.getNumber(), 0);
            this.objectKeys.put(obj, key);
            if (actual != null) {
                this.objectKeys.put(actual, key);
            }
        }
        return key;
    }

    public void visitFromArray(COSArray obj) throws IOException {
        int count = 0;
        this.getStandardOutput().write(ARRAY_OPEN);
        Iterator i = obj.iterator();
        while (i.hasNext()) {
            COSBase current = (COSBase)i.next();
            if (current instanceof COSDictionary) {
                if (current.isDirect()) {
                    this.visitFromDictionary((COSDictionary)current);
                } else {
                    this.addObjectToWrite(current);
                    this.writeReference(current);
                }
            } else if (current instanceof COSObject) {
                COSBase subValue = ((COSObject)current).getObject();
                if (this.willEncrypt || subValue instanceof COSDictionary || subValue == null) {
                    this.addObjectToWrite(current);
                    this.writeReference(current);
                } else {
                    subValue.accept((ICOSVisitor)this);
                }
            } else if (current == null) {
                COSNull.NULL.accept((ICOSVisitor)this);
            } else {
                current.accept((ICOSVisitor)this);
            }
            ++count;
            if (!i.hasNext()) continue;
            if (count % 10 == 0) {
                this.getStandardOutput().writeEOL();
                continue;
            }
            this.getStandardOutput().write(SPACE);
        }
        this.getStandardOutput().write(ARRAY_CLOSE);
        this.getStandardOutput().writeEOL();
    }

    public void visitFromBoolean(COSBoolean obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void visitFromDictionary(COSDictionary obj) throws IOException {
        COSBase itemType;
        if (!this.reachedSignature && (COSName.SIG.equals((Object)(itemType = obj.getItem(COSName.TYPE))) || COSName.DOC_TIME_STAMP.equals((Object)itemType))) {
            this.reachedSignature = true;
        }
        this.getStandardOutput().write(DICT_OPEN);
        this.getStandardOutput().writeEOL();
        for (Map.Entry entry : obj.entrySet()) {
            COSBase value = (COSBase)entry.getValue();
            if (value == null) continue;
            ((COSName)entry.getKey()).accept((ICOSVisitor)this);
            this.getStandardOutput().write(SPACE);
            if (value instanceof COSDictionary) {
                COSDictionary dict = (COSDictionary)value;
                COSBase item = dict.getItem(COSName.XOBJECT);
                if (item != null && !COSName.XOBJECT.equals(entry.getKey())) {
                    item.setDirect(true);
                }
                if ((item = dict.getItem(COSName.RESOURCES)) != null && !COSName.RESOURCES.equals(entry.getKey())) {
                    item.setDirect(true);
                }
                if (dict.isDirect()) {
                    this.visitFromDictionary(dict);
                } else {
                    this.addObjectToWrite((COSBase)dict);
                    this.writeReference((COSBase)dict);
                }
            } else if (value instanceof COSObject) {
                COSBase subValue = ((COSObject)value).getObject();
                if (this.willEncrypt || subValue instanceof COSDictionary || subValue == null) {
                    this.addObjectToWrite(value);
                    this.writeReference(value);
                } else {
                    subValue.accept((ICOSVisitor)this);
                }
            } else if (this.reachedSignature && COSName.CONTENTS.equals(entry.getKey())) {
                this.signatureOffset = this.getStandardOutput().getPos();
                value.accept((ICOSVisitor)this);
                this.signatureLength = this.getStandardOutput().getPos() - this.signatureOffset;
            } else if (this.reachedSignature && COSName.BYTERANGE.equals(entry.getKey())) {
                this.byteRangeArray = (COSArray)entry.getValue();
                this.byteRangeOffset = this.getStandardOutput().getPos() + 1L;
                value.accept((ICOSVisitor)this);
                this.byteRangeLength = this.getStandardOutput().getPos() - 1L - this.byteRangeOffset;
                this.reachedSignature = false;
            } else {
                value.accept((ICOSVisitor)this);
            }
            this.getStandardOutput().writeEOL();
        }
        this.getStandardOutput().write(DICT_CLOSE);
        this.getStandardOutput().writeEOL();
    }

    public void visitFromDocument(COSDocument doc) throws IOException {
        this.doWriteHeader(doc);
        this.doWriteBody(doc);
        COSDictionary trailer = doc.getTrailer();
        long hybridPrev = -1L;
        if (trailer != null) {
            hybridPrev = trailer.getLong(COSName.XREF_STM);
        }
        if (doc.isXRefStream()) {
            this.doWriteXRefInc(doc, hybridPrev);
        } else {
            this.doWriteXRefTable();
            this.doWriteTrailer(doc);
        }
        this.getStandardOutput().write(STARTXREF);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(String.valueOf(this.getStartxref()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(EOF);
        this.getStandardOutput().writeEOL();
    }

    public void visitFromFloat(COSFloat obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void visitFromInt(COSInteger obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void visitFromName(COSName obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void visitFromNull(COSNull obj) throws IOException {
        obj.writePDF((OutputStream)this.getStandardOutput());
    }

    public void writeReference(COSBase obj) throws IOException {
        COSObjectKey key = this.getObjectKey(obj);
        float randomThreshold = this.config.getRandomizeRefNumbers();
        float r = this.random.nextFloat();
        if (randomThreshold > 0.0f && r < randomThreshold) {
            long num = this.random.nextInt(this.roughNumberOfObjects);
            LOG.debug("corrupting ref number: " + key.getNumber() + " -> " + num);
            this.getStandardOutput().write(String.valueOf(num).getBytes(StandardCharsets.ISO_8859_1));
        } else {
            this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes(StandardCharsets.ISO_8859_1));
        }
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes(StandardCharsets.ISO_8859_1));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(REFERENCE);
    }

    public void visitFromStream(COSStream obj) throws IOException {
        if (this.willEncrypt) {
            this.pdDocument.getEncryption().getSecurityHandler().encryptStream(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
        }
        try (InputStream input = null;){
            this.visitFromDictionary((COSDictionary)obj);
            this.getStandardOutput().write(STREAM);
            this.getStandardOutput().writeCRLF();
            input = obj.createRawInputStream();
            IOUtils.copy((InputStream)input, (OutputStream)this.getStandardOutput());
            this.getStandardOutput().writeCRLF();
            this.getStandardOutput().write(ENDSTREAM);
            this.getStandardOutput().writeEOL();
        }
    }

    public void visitFromString(COSString obj) throws IOException {
        if (this.willEncrypt) {
            this.pdDocument.getEncryption().getSecurityHandler().encryptString(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
        }
        COSWriter.writeString((COSString)obj, (OutputStream)this.getStandardOutput());
    }

    public void write(COSDocument doc) throws IOException {
        PDDocument pdDoc = new PDDocument(doc);
        this.write(pdDoc);
    }

    public void write(PDDocument doc) throws IOException {
        this.write(doc, null);
    }

    public void write(PDDocument doc, SignatureInterface signInterface) throws IOException {
        COSArray idArray;
        COSDictionary trailer;
        COSDocument cosDoc;
        long idTime = doc.getDocumentId() == null ? System.currentTimeMillis() : doc.getDocumentId();
        this.pdDocument = doc;
        this.signatureInterface = signInterface;
        if (doc.isAllSecurityToBeRemoved()) {
            this.willEncrypt = false;
            cosDoc = doc.getDocument();
            trailer = cosDoc.getTrailer();
            trailer.removeItem(COSName.ENCRYPT);
        } else if (this.pdDocument.getEncryption() != null) {
            SecurityHandler securityHandler = this.pdDocument.getEncryption().getSecurityHandler();
            if (!securityHandler.hasProtectionPolicy()) {
                throw new IllegalStateException("PDF contains an encryption dictionary, please remove it with setAllSecurityToBeRemoved() or set a protection policy with protect()");
            }
            securityHandler.prepareDocumentForEncryption(this.pdDocument);
            this.willEncrypt = true;
        } else {
            this.willEncrypt = false;
        }
        cosDoc = this.pdDocument.getDocument();
        trailer = cosDoc.getTrailer();
        boolean missingID = true;
        COSBase base = trailer.getDictionaryObject(COSName.ID);
        if (base instanceof COSArray) {
            idArray = (COSArray)base;
            if (idArray.size() == 2) {
                missingID = false;
            }
        } else {
            idArray = new COSArray();
        }
        if (missingID) {
            MessageDigest md5;
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            md5.update(Long.toString(idTime).getBytes(StandardCharsets.ISO_8859_1));
            COSDictionary info = trailer.getCOSDictionary(COSName.INFO);
            if (info != null) {
                for (COSBase cosBase : info.getValues()) {
                    md5.update(cosBase.toString().getBytes(StandardCharsets.ISO_8859_1));
                }
            }
            COSString firstID = missingID ? new COSString(md5.digest()) : (COSString)idArray.get(0);
            COSString secondID = missingID ? firstID : new COSString(md5.digest());
            idArray = new COSArray();
            idArray.add((COSBase)firstID);
            idArray.add((COSBase)secondID);
            trailer.setItem(COSName.ID, (COSBase)idArray);
        }
        cosDoc.accept((ICOSVisitor)this);
    }

    public void write(FDFDocument doc) throws IOException {
        this.fdfDocument = doc;
        this.willEncrypt = false;
        COSDocument cosDoc = this.fdfDocument.getDocument();
        cosDoc.accept((ICOSVisitor)this);
    }

    private byte[] getBytes(OutputStream stream) throws IOException {
        if (stream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)stream).toByteArray();
        }
        if (stream instanceof UnsynchronizedByteArrayOutputStream) {
            return ((UnsynchronizedByteArrayOutputStream)stream).toByteArray();
        }
        throw new IOException("OutputStream " + stream.getClass().getName() + " is not supported");
    }
}

