/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.fuzzing.general.GeneralTransformer;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;

public class AutoDetectTransformer
implements Transformer {
    private static final ServiceLoader DEFAULT_LOADER = new ServiceLoader(AutoDetectTransformer.class.getClassLoader());
    TikaConfig config = TikaConfig.getDefaultConfig();
    MediaTypeRegistry registry = this.config.getMediaTypeRegistry();
    Detector detector = TikaConfig.getDefaultConfig().getDetector();
    Transformer fallback = new GeneralTransformer();
    Map<MediaType, Transformer> transformerMap = new HashMap<MediaType, Transformer>();

    public AutoDetectTransformer() {
        this(DEFAULT_LOADER.loadServiceProviders(Transformer.class));
    }

    public AutoDetectTransformer(List<Transformer> transformers) {
        for (Transformer t : transformers) {
            for (MediaType mediaType : t.getSupportedTypes()) {
                this.transformerMap.put(mediaType, t);
            }
        }
    }

    @Override
    public Set<MediaType> getSupportedTypes() {
        return this.transformerMap.keySet();
    }

    @Override
    public void transform(InputStream is, OutputStream os) throws IOException, TikaException {
        try (TikaInputStream tis = TikaInputStream.get((InputStream)is);){
            Metadata metadata = new Metadata();
            MediaType type = this.detector.detect((InputStream)tis, metadata);
            Transformer transformer = this.getTransformer(type);
            transformer.transform((InputStream)tis, os);
        }
    }

    private Transformer getTransformer(MediaType type) {
        if (type == null) {
            return this.fallback;
        }
        type = this.registry.normalize(type);
        while (type != null) {
            Transformer transformer = this.transformerMap.get(type);
            if (transformer != null) {
                return transformer;
            }
            type = this.registry.getSupertype(type);
        }
        return this.fallback;
    }
}

