/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.general;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.mime.MediaType;

public class SpanSwapper
implements Transformer {
    static Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.OCTET_STREAM);
    Random random = new Random();
    int maxSpanLength = 10000;
    private final float swapProbability = 0.01f;

    @Override
    public Set<MediaType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public void transform(InputStream is, OutputStream os) throws IOException {
        byte[] input = IOUtils.toByteArray((InputStream)is);
        int numSwaps = (int)Math.floor(0.01f * (float)input.length);
        numSwaps = numSwaps == 0 ? 1 : numSwaps;
        byte[] ret = new byte[input.length];
        System.arraycopy(input, 0, ret, 0, input.length);
        for (int i = 0; i < numSwaps; ++i) {
            ret = this.swap(ret);
        }
        os.write(ret);
    }

    private byte[] swap(byte[] ret) {
        int maxStart;
        if (ret.length == 0) {
            return new byte[0];
        }
        int srcStart = this.random.nextInt(ret.length);
        int targStart = this.random.nextInt(ret.length);
        int len = this.random.nextInt(this.maxSpanLength);
        len = len + (maxStart = Math.max(srcStart, targStart)) < ret.length ? len : ret.length - maxStart;
        byte[] landingBytes = new byte[len];
        System.arraycopy(ret, targStart, landingBytes, 0, len);
        System.arraycopy(ret, srcStart, ret, targStart, len);
        System.arraycopy(landingBytes, 0, ret, srcStart, len);
        return ret;
    }
}

