/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.general;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.mime.MediaType;

public class ByteFlipper
implements Transformer {
    static Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.OCTET_STREAM);
    private final Random random = new Random();
    private float percentCorrupt = 0.01f;

    @Override
    public Set<MediaType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public void transform(InputStream is, OutputStream os) throws IOException {
        byte[] input = IOUtils.toByteArray((InputStream)is);
        if (input.length == 0) {
            return;
        }
        byte[] singleByte = new byte[1];
        int atLeastOneIndex = this.random.nextInt(input.length);
        for (int i = 0; i < input.length; ++i) {
            if (this.random.nextFloat() <= this.percentCorrupt || i == atLeastOneIndex) {
                this.random.nextBytes(singleByte);
                os.write(singleByte[0]);
                continue;
            }
            os.write(input[i]);
        }
    }

    public void setPercentCorrupt(float percentCorrupt) {
        this.percentCorrupt = percentCorrupt;
    }
}

