/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.general;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.mime.MediaType;

public class ByteDeleter
implements Transformer {
    static Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.OCTET_STREAM);
    Random random = new Random();
    float percentDeleted = 0.01f;

    @Override
    public Set<MediaType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public void transform(InputStream is, OutputStream os) throws IOException {
        int c = is.read();
        while (c != -1) {
            if (this.random.nextFloat() >= this.percentDeleted) {
                os.write(c);
            }
            c = is.read();
        }
    }
}

