/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.fuzzing.AutoDetectTransformer;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.fuzzing.exceptions.CantFuzzException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FuzzOne {
    private static final Logger LOG = LoggerFactory.getLogger(FuzzOne.class);
    static Options OPTIONS;
    Parser parser = new AutoDetectParser();

    public static void main(String[] args) throws Exception {
        FuzzOneConfig config = FuzzOneConfig.parse(args);
        FuzzOne fuzzOne = new FuzzOne();
        fuzzOne.execute(config);
    }

    private void execute(FuzzOneConfig config) {
        Path src = config.inputFile;
        Path targetDir = config.outputFileBase;
        AutoDetectTransformer transformer = new AutoDetectTransformer();
        for (int i = 0; i < config.perFileIterations; ++i) {
            try {
                String ext = "-" + config.threadNum + "-" + config.retryNum + "-" + i;
                this.fuzz(ext, src, targetDir, transformer, config.timeoutMs);
                continue;
            }
            catch (IOException e) {
                LOG.warn("problem transforming file", (Throwable)e);
                continue;
            }
            catch (CantFuzzException e) {
                LOG.warn("can't fuzz this file " + src, (Throwable)((Object)e));
                return;
            }
            catch (TikaException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fuzz(String ext, Path src, Path targetFileBase, Transformer transformer, long timeoutMs) throws IOException, TikaException {
        Path target = targetFileBase.getParent().resolve(targetFileBase.getFileName().toString() + ext);
        try {
            this.transformFile(transformer, src, target);
        }
        catch (Throwable t) {
            LOG.warn("failed to transform: " + src.toString());
            Files.delete(target);
            throw t;
        }
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<Integer> future = executor.submit(new ParseTask(target));
        try {
            int result = future.get(timeoutMs, TimeUnit.MILLISECONDS);
            if (result == 1 && Files.exists(target, new LinkOption[0])) {
                LOG.warn("failed to delete target: " + target);
            }
        }
        catch (TimeoutException e) {
            LOG.warn("timeout exception:" + target);
            future.cancel(true);
            this.writeErrFile(target, ".timeout");
            System.exit(1);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("problem parsing " + target, (Throwable)e);
            System.exit(1);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void writeErrFile(Path target, String ext) {
        try {
            Path err = target.getParent().resolve(target.getFileName().toString() + ext);
            Files.write(err, new byte[0], new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.warn("things aren't going right today.", (Throwable)e);
        }
    }

    private void handleThrowable(Path target, Throwable t) {
        try {
            Path errMsg = target.getParent().resolve(target.getFileName().toString() + ".stacktrace");
            Files.write(errMsg, ExceptionUtils.getStackTrace((Throwable)t).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.warn("things aren't going right today.", t);
        }
    }

    private void transformFile(Transformer transformer, Path src, Path target) throws IOException, TikaException {
        try (InputStream is = Files.newInputStream(src, new OpenOption[0]);
             OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
            transformer.transform(is, os);
        }
    }

    static {
        Option extracts = new Option("extracts", true, "directory for extract files");
        extracts.setRequired(true);
        OPTIONS = new Options().addOption(Option.builder((String)"i").longOpt("inputFile").desc("input directory for seed files").hasArg(true).required(true).build()).addOption(Option.builder((String)"o").longOpt("outputFile").desc("output file base").hasArg(true).required(true).build()).addOption(Option.builder((String)"m").longOpt("timeoutMs").desc("timeout in ms -- max time allowed to parse a file").hasArg(true).required(true).build()).addOption(Option.builder((String)"n").desc("thread id (thread number)").hasArg(true).required(true).build()).addOption(Option.builder((String)"p").longOpt("perFile").desc("number of iterations to run per seed file").hasArg(true).required(true).build()).addOption(Option.builder((String)"t").longOpt("maxTransformers").desc("maximum number of transformers to run per iteration").hasArg(true).required(true).build()).addOption(Option.builder((String)"r").longOpt("retryId").desc("which retry is this").hasArg(true).required(true).build());
    }

    private static class FuzzOneConfig {
        int perFileIterations;
        int maxTransformers;
        int threadNum;
        int retryNum;
        long timeoutMs;
        private Path inputFile;
        private Path outputFileBase;

        private FuzzOneConfig() {
        }

        static FuzzOneConfig parse(String[] args) throws ParseException {
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(OPTIONS, args);
            FuzzOneConfig config = new FuzzOneConfig();
            config.inputFile = Paths.get(commandLine.getOptionValue("i"), new String[0]);
            config.outputFileBase = Paths.get(commandLine.getOptionValue("o"), new String[0]);
            config.perFileIterations = Integer.parseInt(commandLine.getOptionValue("p"));
            config.maxTransformers = Integer.parseInt(commandLine.getOptionValue("t"));
            config.threadNum = Integer.parseInt(commandLine.getOptionValue("n"));
            config.retryNum = Integer.parseInt(commandLine.getOptionValue("r"));
            config.timeoutMs = Integer.parseInt(commandLine.getOptionValue("m"));
            return config;
        }
    }

    private class ParseTask
    implements Callable<Integer> {
        private final Path target;

        public ParseTask(Path target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws Exception {
            boolean success = false;
            try (InputStream is = Files.newInputStream(this.target, new OpenOption[0]);){
                LOG.debug("parsing " + this.target);
                FuzzOne.this.parser.parse(is, (ContentHandler)new DefaultHandler(), new Metadata(), new ParseContext());
                success = true;
            }
            catch (TikaException e) {
                success = e.getCause() != null && e.getCause() instanceof RuntimeException ? true : true;
            }
            catch (IOException | SAXException e) {
                success = true;
            }
            catch (Throwable t) {
                FuzzOne.this.handleThrowable(this.target, t);
            }
            finally {
                if (success) {
                    try {
                        Files.delete(this.target);
                    }
                    catch (IOException e) {
                        LOG.warn("couldn't delete: " + this.target.toAbsolutePath());
                    }
                } else {
                    LOG.info("FOUND PROBLEM: " + this.target);
                }
            }
            return success ? 1 : 0;
        }
    }
}

