/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.general;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.mime.MediaType;

public class Truncator
implements Transformer {
    static Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.OCTET_STREAM);
    Random random = new Random();

    @Override
    public Set<MediaType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public void transform(InputStream is, OutputStream os) throws IOException {
        byte[] input = IOUtils.toByteArray((InputStream)is);
        if (input.length == 0) {
            return;
        }
        int len = 1 + this.random.nextInt(input.length);
        if (len >= input.length && (len = input.length - 2) < 0) {
            len = 0;
        }
        byte[] ret = new byte[len];
        System.arraycopy(input, 0, ret, 0, len);
        os.write(ret);
    }
}

