/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.langdetect.optimaize.OptimaizeLangDetector;
import org.apache.tika.language.detect.LanguageDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public class MyFirstTika {
    public static void main(String[] args) throws Exception {
        String filename = args[0];
        TikaConfig tikaConfig = TikaConfig.getDefaultConfig();
        Metadata metadata = new Metadata();
        String text = MyFirstTika.parseUsingComponents(filename, tikaConfig, metadata);
        System.out.println("Parsed Metadata: ");
        System.out.println(metadata);
        System.out.println("Parsed Text: ");
        System.out.println(text);
        System.out.println("-------------------------");
        metadata = new Metadata();
        text = MyFirstTika.parseUsingAutoDetect(filename, tikaConfig, metadata);
        System.out.println("Parsed Metadata: ");
        System.out.println(metadata);
        System.out.println("Parsed Text: ");
        System.out.println(text);
    }

    public static String parseUsingAutoDetect(String filename, TikaConfig tikaConfig, Metadata metadata) throws Exception {
        System.out.println("Handling using AutoDetectParser: [" + filename + "]");
        AutoDetectParser parser = new AutoDetectParser(tikaConfig);
        BodyContentHandler handler = new BodyContentHandler();
        TikaInputStream stream = TikaInputStream.get((Path)Paths.get(filename, new String[0]), (Metadata)metadata);
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, new ParseContext());
        return handler.toString();
    }

    public static String parseUsingComponents(String filename, TikaConfig tikaConfig, Metadata metadata) throws Exception {
        MimeTypes mimeRegistry = tikaConfig.getMimeRepository();
        System.out.println("Examining: [" + filename + "]");
        metadata.set("resourceName", filename);
        System.out.println("The MIME type (based on filename) is: [" + String.valueOf(mimeRegistry.detect(null, metadata)) + "]");
        TikaInputStream stream = TikaInputStream.get((Path)Paths.get(filename, new String[0]));
        System.out.println("The MIME type (based on MAGIC) is: [" + String.valueOf(mimeRegistry.detect((InputStream)stream, metadata)) + "]");
        stream = TikaInputStream.get((Path)Paths.get(filename, new String[0]));
        Detector detector = tikaConfig.getDetector();
        System.out.println("The MIME type (based on the Detector interface) is: [" + String.valueOf(detector.detect((InputStream)stream, metadata)) + "]");
        LanguageDetector langDetector = new OptimaizeLangDetector().loadModels();
        LanguageResult lang = langDetector.detect((CharSequence)FileUtils.readFileToString((File)new File(filename), (Charset)StandardCharsets.UTF_8));
        System.out.println("The language of this content is: [" + lang.getLanguage() + "]");
        Parser parser = tikaConfig.getParser();
        MediaType type = detector.detect((InputStream)stream, metadata);
        metadata.set("Content-Type", type.toString());
        BodyContentHandler handler = new BodyContentHandler();
        parser.parse((InputStream)stream, (ContentHandler)handler, metadata, new ParseContext());
        return handler.toString();
    }
}

