/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Collections;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.tika.example.Pharmacy;
import org.apache.tika.example.PrescriptionParser;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EncryptedPrescriptionParser
implements Parser {
    private static final long serialVersionUID = -7816987249611278541L;

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try {
            Key key = Pharmacy.getKey();
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, key);
            CipherInputStream decrypted = new CipherInputStream(stream, cipher);
            new PrescriptionParser().parse(decrypted, handler, metadata, context);
        }
        catch (GeneralSecurityException e) {
            throw new TikaException("Unable to decrypt a digital prescription", (Throwable)e);
        }
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.singleton(MediaType.application((String)"x-prescription"));
    }
}

