/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.tika.Tika;
import org.apache.tika.example.LuceneIndexer;

public class LuceneIndexerExtended {
    private final Tika tika;
    private final IndexWriter writer;

    public LuceneIndexerExtended(IndexWriter writer, Tika tika) {
        this.writer = writer;
        this.tika = tika;
    }

    public static void main(String[] args) throws Exception {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new StandardAnalyzer());
        try (IndexWriter writer = new IndexWriter((Directory)FSDirectory.open((Path)Paths.get(args[0], new String[0])), indexWriterConfig);){
            LuceneIndexer indexer = new LuceneIndexer(new Tika(), writer);
            for (int i = 1; i < args.length; ++i) {
                indexer.indexDocument(new File(args[i]));
            }
        }
    }

    public void indexDocument(File file) throws Exception {
        try (Reader fulltext = this.tika.parse(file);){
            Document document = new Document();
            document.add((IndexableField)new TextField("filename", file.getName(), Field.Store.YES));
            document.add((IndexableField)new TextField("fulltext", fulltext));
            this.writer.addDocument((Iterable)document);
        }
    }
}

