/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DirListParser
implements Parser {
    private static final long serialVersionUID = 2717930544410610735L;
    private static Set<MediaType> SUPPORTED_TYPES = new HashSet<MediaType>(Collections.singletonList(MediaType.TEXT_PLAIN));

    public static void main(String[] args) throws IOException, SAXException, TikaException {
        DirListParser parser = new DirListParser();
        Metadata met = new Metadata();
        parser.parse(System.in, (ContentHandler)new BodyContentHandler(), met);
        System.out.println("Num files: " + met.getValues("Filename").length);
        System.out.println("Num executables: " + met.get("NumExecutables"));
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream is, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(is, handler, metadata, new ParseContext());
    }

    public void parse(InputStream is, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        List lines = FileUtils.readLines((File)TikaInputStream.get((InputStream)is).getFile(), (Charset)StandardCharsets.UTF_8);
        for (String line : lines) {
            String[] fileToks = line.split("\\s+");
            if (fileToks.length < 8) continue;
            String filePermissions = fileToks[0];
            String numHardLinks = fileToks[1];
            String fileOwner = fileToks[2];
            String fileOwnerGroup = fileToks[3];
            String fileSize = fileToks[4];
            StringBuilder lastModDate = new StringBuilder();
            lastModDate.append(fileToks[5]);
            lastModDate.append(" ");
            lastModDate.append(fileToks[6]);
            lastModDate.append(" ");
            lastModDate.append(fileToks[7]);
            StringBuilder fileName = new StringBuilder();
            for (int i = 8; i < fileToks.length; ++i) {
                fileName.append(fileToks[i]);
                fileName.append(" ");
            }
            fileName.deleteCharAt(fileName.length() - 1);
            this.addMetadata(metadata, filePermissions, numHardLinks, fileOwner, fileOwnerGroup, fileSize, lastModDate.toString(), fileName.toString());
        }
    }

    private void addMetadata(Metadata metadata, String filePerms, String numHardLinks, String fileOwner, String fileOwnerGroup, String fileSize, String lastModDate, String fileName) {
        metadata.add("FilePermissions", filePerms);
        metadata.add("NumHardLinks", numHardLinks);
        metadata.add("FileOwner", fileOwner);
        metadata.add("FileOwnerGroup", fileOwnerGroup);
        metadata.add("FileSize", fileSize);
        metadata.add("LastModifiedDate", lastModDate);
        metadata.add("Filename", fileName);
        if (filePerms.contains("x") && !filePerms.contains("d")) {
            if (metadata.get("NumExecutables") != null) {
                int numExecs = Integer.parseInt(metadata.get("NumExecutables"));
                metadata.set("NumExecutables", String.valueOf(++numExecs));
            } else {
                metadata.set("NumExecutables", "1");
            }
        }
    }
}

