/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.TikaCoreProperties;

public class RecentFiles {
    private IndexReader reader;
    private SimpleDateFormat rssDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.getDefault());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateRSS(Path indexFile) throws CorruptIndexException, IOException {
        StringBuilder output = new StringBuilder();
        output.append(this.getRSSHeaders());
        IndexSearcher searcher = null;
        try {
            ScoreDoc[] hits;
            this.reader = DirectoryReader.open((Directory)FSDirectory.open((Path)indexFile));
            searcher = new IndexSearcher(this.reader);
            GregorianCalendar gc = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            gc.setTime(new Date());
            String nowDateTime = ISO8601.format((Calendar)gc);
            gc.add(12, -5);
            String fiveMinsAgo = ISO8601.format((Calendar)gc);
            TermRangeQuery query = new TermRangeQuery(TikaCoreProperties.CREATED.getName(), new BytesRef((CharSequence)fiveMinsAgo), new BytesRef((CharSequence)nowDateTime), true, true);
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)20, (int)10000);
            searcher.search((Query)query, (Collector)collector);
            for (ScoreDoc hit : hits = collector.topDocs().scoreDocs) {
                Document doc = searcher.doc(hit.doc);
                output.append(this.getRSSItem(doc));
            }
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        output.append(this.getRSSFooters());
        return output.toString();
    }

    public String getRSSItem(Document doc) {
        StringBuilder output = new StringBuilder();
        output.append("<item>");
        output.append(this.emitTag("guid", doc.get(DublinCore.SOURCE.getName()), "isPermalink", "true"));
        output.append(this.emitTag("title", doc.get(TikaCoreProperties.TITLE.getName()), null, null));
        output.append(this.emitTag("link", doc.get(DublinCore.SOURCE.getName()), null, null));
        output.append(this.emitTag("author", doc.get(TikaCoreProperties.CREATOR.getName()), null, null));
        for (String topic : doc.getValues(TikaCoreProperties.SUBJECT.getName())) {
            output.append(this.emitTag("category", topic, null, null));
        }
        output.append(this.emitTag("pubDate", this.rssDateFormat.format(ISO8601.parse((String)doc.get(TikaCoreProperties.CREATED.getName()))), null, null));
        output.append(this.emitTag("description", doc.get(TikaCoreProperties.TITLE.getName()), null, null));
        output.append("</item>");
        return output.toString();
    }

    public String getRSSHeaders() {
        StringBuilder output = new StringBuilder();
        output.append("<?xml version=\"1.0\" encoding=\"utf-8\">");
        output.append("<rss version=\"2.0\">");
        output.append("  <channel>");
        output.append("     <title>Tika in Action: Recent Files Feed.</title>");
        output.append("     <description>Chapter 6 Examples demonstrating use of Tika Metadata for RSS.</description>");
        output.append("     <link>tikainaction.rss</link>");
        output.append("     <lastBuildDate>");
        output.append(this.rssDateFormat.format(new Date()));
        output.append("</lastBuildDate>");
        output.append("     <generator>Manning Publications: Tika in Action</generator>");
        output.append("     <copyright>All Rights Reserved</copyright>");
        return output.toString();
    }

    public String getRSSFooters() {
        return "   </channel>";
    }

    private String emitTag(String tagName, String value, String attributeName, String attributeValue) {
        StringBuilder output = new StringBuilder();
        output.append("<");
        output.append(tagName);
        if (attributeName != null) {
            output.append(" ");
            output.append(attributeName);
            output.append("=\"");
            output.append(attributeValue);
            output.append("\"");
        }
        output.append(">");
        output.append(value);
        output.append("</");
        output.append(tagName);
        output.append(">");
        return output.toString();
    }
}

