/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.Tika;
import org.apache.tika.example.ExtractEmbeddedFiles;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.sax.RecursiveParserWrapperHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ParsingExample {
    public String parseToStringExample() throws IOException, SAXException, TikaException {
        Tika tika = new Tika();
        try (InputStream stream = ParsingExample.class.getResourceAsStream("test.doc");){
            String string = tika.parseToString(stream);
            return string;
        }
    }

    public String parseExample() throws IOException, SAXException, TikaException {
        AutoDetectParser parser = new AutoDetectParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = ParsingExample.class.getResourceAsStream("test.doc");){
            parser.parse(stream, (ContentHandler)handler, metadata);
            String string = handler.toString();
            return string;
        }
    }

    public String parseNoEmbeddedExample() throws IOException, SAXException, TikaException {
        AutoDetectParser parser = new AutoDetectParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        ParseContext parseContext = new ParseContext();
        parseContext.set(Parser.class, (Object)new EmptyParser());
        try (InputStream stream = ParsingExample.class.getResourceAsStream("test_recursive_embedded.docx");){
            parser.parse(stream, (ContentHandler)handler, metadata, parseContext);
            String string = handler.toString();
            return string;
        }
    }

    public String parseEmbeddedExample() throws IOException, SAXException, TikaException {
        AutoDetectParser parser = new AutoDetectParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)parser);
        try (InputStream stream = ParsingExample.class.getResourceAsStream("test_recursive_embedded.docx");){
            parser.parse(stream, (ContentHandler)handler, metadata, context);
            String string = handler.toString();
            return string;
        }
    }

    public List<Metadata> recursiveParserWrapperExample() throws IOException, SAXException, TikaException {
        AutoDetectParser p = new AutoDetectParser();
        BasicContentHandlerFactory factory = new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.HTML, -1);
        RecursiveParserWrapper wrapper = new RecursiveParserWrapper((Parser)p);
        Metadata metadata = new Metadata();
        metadata.set("resourceName", "test_recursive_embedded.docx");
        ParseContext context = new ParseContext();
        RecursiveParserWrapperHandler handler = new RecursiveParserWrapperHandler((ContentHandlerFactory)factory, -1);
        try (InputStream stream = ParsingExample.class.getResourceAsStream("test_recursive_embedded.docx");){
            wrapper.parse(stream, (ContentHandler)handler, metadata, context);
        }
        return handler.getMetadataList();
    }

    public String serializedRecursiveParserWrapperExample() throws IOException, SAXException, TikaException {
        List<Metadata> metadataList = this.recursiveParserWrapperExample();
        StringWriter writer = new StringWriter();
        JsonMetadataList.toJson(metadataList, (Writer)writer);
        return writer.toString();
    }

    public List<Path> extractEmbeddedDocumentsExample(Path outputPath) throws IOException, SAXException, TikaException {
        ExtractEmbeddedFiles ex = new ExtractEmbeddedFiles();
        ArrayList<Path> ret = new ArrayList<Path>();
        try (TikaInputStream stream = TikaInputStream.get((InputStream)ParsingExample.class.getResourceAsStream("test_recursive_embedded.docx"));){
            ex.extract((InputStream)stream, outputPath);
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(outputPath);){
                for (Path entry : dirStream) {
                    ret.add(entry);
                }
            }
        }
        return ret;
    }
}

