/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.db;

import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.eval.app.db.JDBCUtil;

public class H2Util
extends JDBCUtil {
    private static final String DRIVER_CLASS = "org.h2.Driver";
    private final Path db;

    public H2Util(Path db) {
        super(H2Util.getConnectionString(db, true), DRIVER_CLASS);
        this.db = db;
    }

    public static boolean databaseExists(Path db) {
        String connString = H2Util.getConnectionString(db, false);
        try {
            Connection conn = DriverManager.getConnection(connString);
            Throwable throwable = null;
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private static String getConnectionString(Path db, boolean createDBIfItDoesntExist) {
        String s = "jdbc:h2:" + FilenameUtils.separatorsToUnix(db.toAbsolutePath().toString());
        if (!createDBIfItDoesntExist) {
            s = s + ";IFEXISTS=TRUE";
        }
        return s;
    }

    @Override
    public String getJDBCDriverClass() {
        return DRIVER_CLASS;
    }

    @Override
    public boolean dropTableIfExists(Connection conn, String tableName) throws SQLException {
        Statement st = conn.createStatement();
        String sql = "drop table if exists " + tableName;
        boolean success = st.execute(sql);
        st.close();
        return success;
    }

    @Override
    public String getConnectionString() {
        return H2Util.getConnectionString(this.db, true);
    }

    @Override
    public Set<String> getTables(Connection connection) throws SQLException {
        String sql = "SHOW TABLES";
        Statement st = connection.createStatement();
        ResultSet rs = st.executeQuery(sql);
        HashSet<String> tables = new HashSet<String>();
        while (rs.next()) {
            String table = rs.getString(1);
            tables.add(table);
        }
        return tables;
    }
}

