/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.tika.batch.ConsumersManager;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.batch.FileResourceCrawler;
import org.apache.tika.batch.FileStarted;
import org.apache.tika.batch.IFileProcessorFutureResult;
import org.apache.tika.batch.StatusReporterFutureResult;
import org.apache.tika.util.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusReporter
implements Callable<IFileProcessorFutureResult> {
    private static final Logger LOG = LoggerFactory.getLogger(StatusReporter.class);
    private final ConsumersManager consumersManager;
    private final FileResourceCrawler crawler;
    private final long start;
    private long sleepMillis = 1000L;
    private long staleThresholdMillis = 100000L;
    private volatile boolean isShuttingDown = false;

    public StatusReporter(FileResourceCrawler crawler, ConsumersManager consumersManager) {
        this.consumersManager = consumersManager;
        this.crawler = crawler;
        this.start = System.currentTimeMillis();
    }

    protected void report(String s) {
        LOG.info(s);
    }

    @Override
    public IFileProcessorFutureResult call() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        try {
            while (true) {
                Thread.sleep(this.sleepMillis);
                int cnt = this.getRoughCountConsumed();
                int exceptions = this.getRoughCountExceptions();
                long elapsed = System.currentTimeMillis() - this.start;
                double elapsedSecs = (double)elapsed / 1000.0;
                int avg = elapsedSecs > 5.0 || cnt > 100 ? (int)((double)cnt / elapsedSecs) : -1;
                String elapsedString = DurationFormatUtils.formatMillis(System.currentTimeMillis() - this.start);
                String docsPerSec = avg > -1 ? String.format(Locale.ROOT, " (%s docs per sec)", numberFormat.format(avg)) : "";
                Object msg = String.format(Locale.ROOT, "Processed %s documents in %s%s.", numberFormat.format(cnt), elapsedString, docsPerSec);
                this.report((String)msg);
                msg = exceptions == 1 ? "There has been one handled exception." : String.format(Locale.ROOT, "There have been %s handled exceptions.", numberFormat.format(exceptions));
                this.report((String)msg);
                this.reportStale();
                int stillAlive = this.getStillAlive();
                msg = stillAlive == 1 ? "There is one file processor still active." : "There are " + numberFormat.format(stillAlive) + " file processors still active.";
                this.report((String)msg);
                int crawled = this.crawler.getConsidered();
                int added = this.crawler.getAdded();
                msg = crawled == 1 ? "The directory crawler has considered 1 file," : "The directory crawler has considered " + numberFormat.format(crawled) + " files, ";
                msg = added == 1 ? (String)msg + "and it has added 1 file." : (String)msg + "and it has added " + numberFormat.format(this.crawler.getAdded()) + " files.";
                msg = (String)msg + "\n";
                this.report((String)msg);
                if (!this.crawler.isActive()) {
                    msg = "The directory crawler has completed its crawl.\n";
                    this.report((String)msg);
                }
                if (!this.isShuttingDown) continue;
                msg = "Process is shutting down now.";
                this.report((String)msg);
            }
        }
        catch (InterruptedException interruptedException) {
            return new StatusReporterFutureResult();
        }
    }

    public void setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
    }

    public void setStaleThresholdMillis(long staleThresholdMillis) {
        this.staleThresholdMillis = staleThresholdMillis;
    }

    private void reportStale() {
        for (FileResourceConsumer consumer : this.consumersManager.getConsumers()) {
            long elapsed;
            FileStarted fs = consumer.getCurrentFile();
            if (fs == null || (elapsed = fs.getElapsedMillis()) <= this.staleThresholdMillis) continue;
            String elapsedString = Double.toString((double)elapsed / 1000.0);
            this.report("A thread has been working on " + fs.getResourceId() + " for " + elapsedString + " seconds.");
        }
    }

    private int getRoughCountConsumed() {
        int ret = 0;
        for (FileResourceConsumer consumer : this.consumersManager.getConsumers()) {
            ret += consumer.getNumResourcesConsumed();
        }
        return ret;
    }

    private int getStillAlive() {
        int ret = 0;
        for (FileResourceConsumer consumer : this.consumersManager.getConsumers()) {
            if (!consumer.isStillActive()) continue;
            ++ret;
        }
        return ret;
    }

    public int getRoughCountExceptions() {
        int ret = 0;
        for (FileResourceConsumer consumer : this.consumersManager.getConsumers()) {
            ret += consumer.getNumHandledExceptions();
        }
        return ret;
    }

    public void setIsShuttingDown(boolean isShuttingDown) {
        this.isShuttingDown = isShuttingDown;
    }
}

