/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.util;

public class ClassLoaderUtil {
    public static <T> T buildClass(Class<T> iface, String className) {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> clazz = loader.loadClass(className);
            if (iface.isAssignableFrom(clazz)) {
                return (T)clazz.newInstance();
            }
            throw new IllegalArgumentException(iface + " is not assignable from " + className);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

