/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.builders;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import javax.xml.parsers.DocumentBuilder;
import org.apache.tika.batch.BatchProcess;
import org.apache.tika.batch.ConsumersManager;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceCrawler;
import org.apache.tika.batch.Interrupter;
import org.apache.tika.batch.StatusReporter;
import org.apache.tika.batch.builders.AbstractConsumersBuilder;
import org.apache.tika.batch.builders.ICrawlerBuilder;
import org.apache.tika.batch.builders.InterrupterBuilder;
import org.apache.tika.batch.builders.StatusReporterBuilder;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.util.ClassLoaderUtil;
import org.apache.tika.util.XMLDOMUtil;
import org.apache.tika.utils.XMLReaderUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BatchProcessBuilder {
    public static final int DEFAULT_MAX_QUEUE_SIZE = 1000;
    public static final String MAX_QUEUE_SIZE_KEY = "maxQueueSize";
    public static final String NUM_CONSUMERS_KEY = "numConsumers";

    public BatchProcess build(InputStream is, Map<String, String> runtimeAttributes) throws IOException {
        Document doc = null;
        try {
            DocumentBuilder docBuilder = XMLReaderUtils.getDocumentBuilder();
            doc = docBuilder.parse(is);
        }
        catch (TikaException | SAXException e) {
            throw new IOExceptionWithCause(e);
        }
        Element docElement = doc.getDocumentElement();
        return this.build(docElement, runtimeAttributes);
    }

    public BatchProcess build(Node docElement, Map<String, String> incomingRuntimeAttributes) {
        long timeoutThresholdMillis = XMLDOMUtil.getLong("timeoutThresholdMillis", incomingRuntimeAttributes, docElement);
        long timeoutCheckPulseMillis = XMLDOMUtil.getLong("timeoutCheckPulseMillis", incomingRuntimeAttributes, docElement);
        long pauseOnEarlyTerminationMillis = XMLDOMUtil.getLong("pauseOnEarlyTerminationMillis", incomingRuntimeAttributes, docElement);
        int maxAliveTimeSeconds = XMLDOMUtil.getInt("maxAliveTimeSeconds", incomingRuntimeAttributes, docElement);
        FileResourceCrawler crawler = null;
        ConsumersManager consumersManager = null;
        StatusReporter reporter = null;
        Interrupter interrupter = null;
        Map<String, String> runtimeAttributes = this.setNumConsumersInRuntimeAttributes(docElement, incomingRuntimeAttributes);
        ArrayBlockingQueue<FileResource> queue = this.buildQueue(docElement, runtimeAttributes);
        NodeList children = docElement.getChildNodes();
        HashMap<String, Node> keyNodes = new HashMap<String, Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            keyNodes.put(nodeName, child);
        }
        consumersManager = this.buildConsumersManager((Node)keyNodes.get("consumers"), runtimeAttributes, queue);
        crawler = this.buildCrawler(queue, (Node)keyNodes.get("crawler"), runtimeAttributes);
        if (keyNodes.containsKey(reporter)) {
            reporter = this.buildReporter(crawler, consumersManager, (Node)keyNodes.get("reporter"), runtimeAttributes);
        }
        if (keyNodes.containsKey("interrupter")) {
            interrupter = this.buildInterrupter((Node)keyNodes.get("interrupter"), pauseOnEarlyTerminationMillis, runtimeAttributes);
        }
        BatchProcess proc = new BatchProcess(crawler, consumersManager, reporter, interrupter);
        if (timeoutThresholdMillis > -1L) {
            proc.setTimeoutThresholdMillis(timeoutThresholdMillis);
        }
        if (pauseOnEarlyTerminationMillis > -1L) {
            proc.setPauseOnEarlyTerminationMillis(pauseOnEarlyTerminationMillis);
        }
        if (timeoutCheckPulseMillis > -1L) {
            proc.setTimeoutCheckPulseMillis(timeoutCheckPulseMillis);
        }
        proc.setMaxAliveTimeSeconds(maxAliveTimeSeconds);
        return proc;
    }

    private Interrupter buildInterrupter(Node node, long pauseOnEarlyTermination, Map<String, String> runtimeAttributes) {
        Map<String, String> attrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        String className = attrs.get("builderClass");
        if (className == null) {
            throw new RuntimeException("Need to specify class name in interrupter element");
        }
        InterrupterBuilder builder = ClassLoaderUtil.buildClass(InterrupterBuilder.class, className);
        return builder.build(node, pauseOnEarlyTermination, runtimeAttributes);
    }

    private StatusReporter buildReporter(FileResourceCrawler crawler, ConsumersManager consumersManager, Node node, Map<String, String> runtimeAttributes) {
        Map<String, String> attrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        String className = attrs.get("builderClass");
        if (className == null) {
            throw new RuntimeException("Need to specify class name in reporter element");
        }
        StatusReporterBuilder builder = ClassLoaderUtil.buildClass(StatusReporterBuilder.class, className);
        return builder.build(crawler, consumersManager, node, runtimeAttributes);
    }

    public static int getNumConsumers(Map<String, String> attrs) {
        String nString = attrs.get(NUM_CONSUMERS_KEY);
        if (nString == null || nString.equals("default")) {
            return AbstractConsumersBuilder.getDefaultNumConsumers();
        }
        int n = -1;
        try {
            n = Integer.parseInt(nString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 1) {
            n = AbstractConsumersBuilder.getDefaultNumConsumers();
        }
        return n;
    }

    private Map<String, String> setNumConsumersInRuntimeAttributes(Node docElement, Map<String, String> incomingRuntimeAttributes) {
        HashMap<String, String> runtimeAttributes = new HashMap<String, String>();
        for (Map.Entry<String, String> e : incomingRuntimeAttributes.entrySet()) {
            runtimeAttributes.put(e.getKey(), e.getValue());
        }
        if (runtimeAttributes.containsKey(NUM_CONSUMERS_KEY)) {
            return Collections.unmodifiableMap(runtimeAttributes);
        }
        Node ncNode = docElement.getAttributes().getNamedItem(NUM_CONSUMERS_KEY);
        int numConsumers = -1;
        String numConsumersString = ncNode.getNodeValue();
        try {
            numConsumers = Integer.parseInt(numConsumersString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (numConsumers < 1) {
            numConsumers = AbstractConsumersBuilder.getDefaultNumConsumers();
        }
        runtimeAttributes.put(NUM_CONSUMERS_KEY, Integer.toString(numConsumers));
        return Collections.unmodifiableMap(runtimeAttributes);
    }

    private ArrayBlockingQueue<FileResource> buildQueue(Node docElement, Map<String, String> runtimeAttributes) {
        Node szNode;
        int maxQueueSize = 1000;
        String szString = runtimeAttributes.get(MAX_QUEUE_SIZE_KEY);
        if (szString == null && (szNode = docElement.getAttributes().getNamedItem(MAX_QUEUE_SIZE_KEY)) != null) {
            szString = szNode.getNodeValue();
        }
        if (szString != null) {
            try {
                maxQueueSize = Integer.parseInt(szString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (maxQueueSize < 0) {
            maxQueueSize = 1000;
        }
        return new ArrayBlockingQueue<FileResource>(maxQueueSize);
    }

    private ConsumersManager buildConsumersManager(Node node, Map<String, String> runtimeAttributes, ArrayBlockingQueue<FileResource> queue) {
        Map<String, String> attrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        String className = attrs.get("builderClass");
        if (className == null) {
            throw new RuntimeException("Need to specify class name in consumers element");
        }
        AbstractConsumersBuilder builder = ClassLoaderUtil.buildClass(AbstractConsumersBuilder.class, className);
        return builder.build(node, runtimeAttributes, queue);
    }

    private FileResourceCrawler buildCrawler(ArrayBlockingQueue<FileResource> queue, Node node, Map<String, String> runtimeAttributes) {
        Map<String, String> attrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        String className = attrs.get("builderClass");
        if (className == null) {
            throw new RuntimeException("Need to specify class name in crawler element");
        }
        ICrawlerBuilder builder = ClassLoaderUtil.buildClass(ICrawlerBuilder.class, className);
        return builder.build(node, (Map)runtimeAttributes, (ArrayBlockingQueue)queue);
    }
}

