/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.ParserFactory;
import org.apache.tika.batch.fs.AbstractFSConsumer;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.utils.ExceptionUtils;
import org.xml.sax.helpers.DefaultHandler;

public class RecursiveParserWrapperFSConsumer
extends AbstractFSConsumer {
    private final ParserFactory parserFactory;
    private final ContentHandlerFactory contentHandlerFactory;
    private final OutputStreamFactory fsOSFactory;
    private final TikaConfig tikaConfig;
    private String outputEncoding = "UTF-8";

    public RecursiveParserWrapperFSConsumer(ArrayBlockingQueue<FileResource> queue, ParserFactory parserFactory, ContentHandlerFactory contentHandlerFactory, OutputStreamFactory fsOSFactory, TikaConfig tikaConfig) {
        super(queue);
        this.parserFactory = parserFactory;
        this.contentHandlerFactory = contentHandlerFactory;
        this.fsOSFactory = fsOSFactory;
        this.tikaConfig = tikaConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processFileResource(FileResource fileResource) {
        Parser wrapped = this.parserFactory.getParser(this.tikaConfig);
        RecursiveParserWrapper parser = new RecursiveParserWrapper(wrapped, this.contentHandlerFactory);
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)parser);
        OutputStream os = this.getOutputStream(this.fsOSFactory, fileResource);
        if (os == null) {
            LOG.debug("Skipping: {}", (Object)fileResource.getMetadata().get(FSProperties.FS_REL_PATH));
            return false;
        }
        InputStream is = this.getInputStream(fileResource);
        if (is == null) {
            IOUtils.closeQuietly((OutputStream)os);
            return false;
        }
        Throwable thrown = null;
        LinkedList<Metadata> metadataList = null;
        Metadata containerMetadata = fileResource.getMetadata();
        try {
            this.parse(fileResource.getResourceId(), (Parser)parser, is, new DefaultHandler(), containerMetadata, context);
            metadataList = parser.getMetadata();
        }
        catch (Throwable t) {
            thrown = t;
            metadataList = parser.getMetadata();
            if (metadataList == null) {
                metadataList = new LinkedList<Metadata>();
            }
            Metadata m = null;
            m = metadataList.size() == 0 ? containerMetadata : (Metadata)metadataList.remove(0);
            String stackTrace = ExceptionUtils.getFilteredStackTrace((Throwable)t);
            m.add("X-TIKA:EXCEPTION:runtime", stackTrace);
            metadataList.add(0, m);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(os, this.getOutputEncoding());
            JsonMetadataList.toJson(metadataList, (Writer)writer);
        }
        catch (Exception e) {
            try {
                LOG.error("{}", (Object)this.getXMLifiedLogMsg(IO_OS + "json", fileResource.getResourceId(), e, new String[0]));
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.flushAndClose(writer);
                throw throwable;
            }
        }
        this.flushAndClose(writer);
        if (thrown != null) {
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            return false;
        }
        return true;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }
}

