/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.gui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.gui.ParsingTransferHandler;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.parser.html.BoilerpipeContentHandler;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.TeeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TikaGUI
extends JFrame
implements ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = 5883906936187059495L;
    private final int MAX_MARK = 0x1400000;
    private final ParseContext context;
    private final Parser parser;
    private final ImageSavingParser imageParser;
    private final CardLayout layout = new CardLayout();
    private final JPanel cards;
    private final JEditorPane html;
    private final JEditorPane text;
    private final JEditorPane textMain;
    private final JEditorPane xml;
    private final JEditorPane json;
    private final JEditorPane metadata;
    private final JFileChooser chooser = new JFileChooser();

    public static void main(String[] args) throws Exception {
        TikaConfig config = TikaConfig.getDefaultConfig();
        if (args.length > 0) {
            File configFile = new File(args[0]);
            config = new TikaConfig(configFile);
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        final TikaConfig finalConfig = config;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TikaGUI(new AutoDetectParser(finalConfig)).setVisible(true);
            }
        });
    }

    public TikaGUI(Parser parser) {
        super("Apache Tika");
        this.setDefaultCloseOperation(3);
        this.addMenuBar();
        this.cards = new JPanel(this.layout);
        this.addWelcomeCard(this.cards, "welcome");
        this.metadata = this.addCard(this.cards, "text/plain", "metadata");
        this.html = this.addCard(this.cards, "text/html", "html");
        this.text = this.addCard(this.cards, "text/plain", "text");
        this.textMain = this.addCard(this.cards, "text/plain", "main");
        this.xml = this.addCard(this.cards, "text/plain", "xhtml");
        this.json = this.addCard(this.cards, "text/plain", "json");
        this.add(this.cards);
        this.layout.show(this.cards, "welcome");
        this.setPreferredSize(new Dimension(640, 480));
        this.pack();
        this.context = new ParseContext();
        this.parser = parser;
        this.imageParser = new ImageSavingParser(parser);
        this.context.set(DocumentSelector.class, new ImageDocumentSelector());
        this.context.set(Parser.class, this.imageParser);
    }

    private void addMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        this.addMenuItem(file, "Open...", "openfile", 79);
        this.addMenuItem(file, "Open URL...", "openurl", 85);
        file.addSeparator();
        this.addMenuItem(file, "Exit", "exit", 88);
        bar.add(file);
        JMenu view = new JMenu("View");
        view.setMnemonic(86);
        this.addMenuItem(view, "Metadata", "metadata", 77);
        this.addMenuItem(view, "Formatted text", "html", 70);
        this.addMenuItem(view, "Plain text", "text", 80);
        this.addMenuItem(view, "Main content", "main", 67);
        this.addMenuItem(view, "Structured text", "xhtml", 83);
        this.addMenuItem(view, "Recursive JSON", "json", 74);
        bar.add(view);
        bar.add(Box.createHorizontalGlue());
        JMenu help = new JMenu("Help");
        help.setMnemonic(72);
        this.addMenuItem(help, "About Tika", "about", 65);
        bar.add(help);
        this.setJMenuBar(bar);
    }

    private void addMenuItem(JMenu menu, String title, String command, int key) {
        JMenuItem item = new JMenuItem(title, key);
        item.setActionCommand(command);
        item.addActionListener(this);
        menu.add(item);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("openfile".equals(command)) {
            int rv = this.chooser.showOpenDialog(this);
            if (rv == 0) {
                this.openFile(this.chooser.getSelectedFile());
            }
        } else if ("openurl".equals(command)) {
            Object rv = JOptionPane.showInputDialog(this, "Enter the URL of the resource to be parsed:", "Open URL", -1, null, null, "");
            if (rv != null && rv.toString().length() > 0) {
                try {
                    this.openURL(new URL(rv.toString().trim()));
                }
                catch (MalformedURLException exception) {
                    JOptionPane.showMessageDialog(this, "The given string is not a valid URL", "Invalid URL", 0);
                }
            }
        } else if ("html".equals(command)) {
            this.layout.show(this.cards, command);
        } else if ("text".equals(command)) {
            this.layout.show(this.cards, command);
        } else if ("main".equals(command)) {
            this.layout.show(this.cards, command);
        } else if ("xhtml".equals(command)) {
            this.layout.show(this.cards, command);
        } else if ("metadata".equals(command)) {
            this.layout.show(this.cards, command);
        } else if ("json".equals(command)) {
            this.layout.show(this.cards, command);
        } else if ("about".equals(command)) {
            this.textDialog("About Apache Tika", TikaGUI.class.getResource("about.html"));
        } else if ("exit".equals(command)) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(File file) {
        try {
            Metadata metadata = new Metadata();
            TikaInputStream stream = TikaInputStream.get(file, metadata);
            try {
                this.handleStream(stream, metadata);
            }
            finally {
                stream.close();
            }
        }
        catch (Throwable t) {
            this.handleError(file.getPath(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openURL(URL url) {
        try {
            Metadata metadata = new Metadata();
            TikaInputStream stream = TikaInputStream.get(url, metadata);
            try {
                this.handleStream(stream, metadata);
            }
            finally {
                stream.close();
            }
        }
        catch (Throwable t) {
            this.handleError(url.toString(), t);
        }
    }

    private void handleStream(InputStream input, Metadata md) throws Exception {
        StringWriter htmlBuffer = new StringWriter();
        StringWriter textBuffer = new StringWriter();
        StringWriter textMainBuffer = new StringWriter();
        StringWriter xmlBuffer = new StringWriter();
        StringBuilder metadataBuffer = new StringBuilder();
        TeeContentHandler handler = new TeeContentHandler(this.getHtmlHandler(htmlBuffer), this.getTextContentHandler(textBuffer), this.getTextMainContentHandler(textMainBuffer), this.getXmlContentHandler(xmlBuffer));
        this.context.set(DocumentSelector.class, new ImageDocumentSelector());
        if (input.markSupported()) {
            input.mark(0x1400000);
        }
        input = new ProgressMonitorInputStream(this, "Parsing stream", input);
        this.parser.parse(input, handler, md, this.context);
        Object[] names = md.names();
        Arrays.sort(names);
        for (Object name : names) {
            metadataBuffer.append((String)name);
            metadataBuffer.append(": ");
            metadataBuffer.append(md.get((String)name));
            metadataBuffer.append("\n");
        }
        String name = md.get("resourceName");
        if (name != null && name.length() > 0) {
            this.setTitle("Apache Tika: " + name);
        } else {
            this.setTitle("Apache Tika: unnamed document");
        }
        this.setText(this.metadata, metadataBuffer.toString());
        this.setText(this.xml, xmlBuffer.toString());
        this.setText(this.text, textBuffer.toString());
        this.setText(this.textMain, textMainBuffer.toString());
        this.setText(this.html, htmlBuffer.toString());
        if (!input.markSupported()) {
            this.setText(this.json, "InputStream does not support mark/reset for Recursive Parsing");
            this.layout.show(this.cards, "metadata");
            return;
        }
        boolean isReset = false;
        try {
            input.reset();
            isReset = true;
        }
        catch (IOException e) {
            this.setText(this.json, "Error during stream reset.\nThere's a limit of 20971520 bytes for this type of processing in the GUI.\nTry the app with command line argument of -J.");
        }
        if (isReset) {
            RecursiveParserWrapper wrapper = new RecursiveParserWrapper(this.parser, new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.BODY, -1));
            wrapper.parse(input, null, new Metadata(), new ParseContext());
            StringWriter jsonBuffer = new StringWriter();
            JsonMetadataList.setPrettyPrinting(true);
            JsonMetadataList.toJson(wrapper.getMetadata(), jsonBuffer);
            this.setText(this.json, jsonBuffer.toString());
        }
        this.layout.show(this.cards, "metadata");
    }

    private void handleError(String name, Throwable t) {
        StringWriter writer = new StringWriter();
        writer.append("Apache Tika was unable to parse the document\n");
        writer.append("at " + name + ".\n\n");
        writer.append("The full exception stack trace is included below:\n\n");
        t.printStackTrace(new PrintWriter(writer));
        JEditorPane editor = new JEditorPane("text/plain", writer.toString());
        editor.setEditable(false);
        editor.setBackground(Color.WHITE);
        editor.setCaretPosition(0);
        editor.setPreferredSize(new Dimension(600, 400));
        JDialog dialog = new JDialog((Frame)this, "Apache Tika error");
        dialog.add(new JScrollPane(editor));
        dialog.pack();
        dialog.setVisible(true);
    }

    private void addWelcomeCard(JPanel panel, String name) {
        try {
            JEditorPane editor = new JEditorPane(TikaGUI.class.getResource("welcome.html"));
            editor.setContentType("text/html");
            editor.setEditable(false);
            editor.setBackground(Color.WHITE);
            editor.setTransferHandler(new ParsingTransferHandler(editor.getTransferHandler(), this));
            panel.add((Component)new JScrollPane(editor), name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JEditorPane addCard(JPanel panel, String type, String name) {
        JTextPane editor = new JTextPane();
        editor.setBackground(Color.WHITE);
        editor.setContentType(type);
        editor.setTransferHandler(new ParsingTransferHandler(editor.getTransferHandler(), this));
        panel.add((Component)new JScrollPane(editor), name);
        return editor;
    }

    private void textDialog(String title, URL resource) {
        try {
            JDialog dialog = new JDialog((Frame)this, title);
            JEditorPane editor = new JEditorPane(resource);
            editor.setContentType("text/html");
            editor.setEditable(false);
            editor.setBackground(Color.WHITE);
            editor.setPreferredSize(new Dimension(400, 250));
            editor.addHyperlinkListener(this);
            dialog.add(editor);
            dialog.pack();
            dialog.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                URL url = e.getURL();
                InputStream stream = url.openStream();
                try {
                    StringWriter writer = new StringWriter();
                    IOUtils.copy(stream, writer, "UTF-8");
                    JEditorPane editor = new JEditorPane("text/plain", writer.toString());
                    editor.setEditable(false);
                    editor.setBackground(Color.WHITE);
                    editor.setCaretPosition(0);
                    editor.setPreferredSize(new Dimension(600, 400));
                    String name = url.toString();
                    name = name.substring(name.lastIndexOf(47) + 1);
                    JDialog dialog = new JDialog((Frame)this, "Apache Tika: " + name);
                    dialog.add(new JScrollPane(editor));
                    dialog.pack();
                    dialog.setVisible(true);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void setText(JEditorPane editor, String text) {
        editor.setText(text);
        editor.setCaretPosition(0);
    }

    private ContentHandler getHtmlHandler(Writer writer) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "html");
        handler.setResult(new StreamResult(writer));
        return new ContentHandlerDecorator(handler){

            @Override
            public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
                if ("http://www.w3.org/1999/xhtml".equals(uri)) {
                    uri = null;
                }
                if (!"head".equals(localName)) {
                    if ("img".equals(localName)) {
                        AttributesImpl newAttrs = atts instanceof AttributesImpl ? (AttributesImpl)atts : new AttributesImpl(atts);
                        for (int i = 0; i < newAttrs.getLength(); ++i) {
                            String src;
                            if (!"src".equals(newAttrs.getLocalName(i)) || !(src = newAttrs.getValue(i)).startsWith("embedded:")) continue;
                            String filename = src.substring(src.indexOf(58) + 1);
                            try {
                                File img = TikaGUI.this.imageParser.requestSave(filename);
                                String newSrc = img.toURI().toString();
                                newAttrs.setValue(i, newSrc);
                                continue;
                            }
                            catch (IOException e) {
                                System.err.println("Error creating temp image file " + filename);
                            }
                        }
                        super.startElement(uri, localName, name, newAttrs);
                    } else {
                        super.startElement(uri, localName, name, atts);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String name) throws SAXException {
                if ("http://www.w3.org/1999/xhtml".equals(uri)) {
                    uri = null;
                }
                if (!"head".equals(localName)) {
                    super.endElement(uri, localName, name);
                }
            }

            @Override
            public void startPrefixMapping(String prefix, String uri) {
            }

            @Override
            public void endPrefixMapping(String prefix) {
            }
        };
    }

    private ContentHandler getTextContentHandler(Writer writer) {
        return new BodyContentHandler(writer);
    }

    private ContentHandler getTextMainContentHandler(Writer writer) {
        return new BoilerpipeContentHandler(writer);
    }

    private ContentHandler getXmlContentHandler(Writer writer) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.setResult(new StreamResult(writer));
        return handler;
    }

    private static class ImageSavingParser
    extends AbstractParser {
        private Map<String, File> wanted = new HashMap<String, File>();
        private Parser downstreamParser;
        private File tmpDir;

        private ImageSavingParser(Parser downstreamParser) {
            this.downstreamParser = downstreamParser;
            try {
                File t = File.createTempFile("tika", ".test");
                this.tmpDir = t.getParentFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public File requestSave(String embeddedName) throws IOException {
            String suffix = ".tika";
            int splitAt = embeddedName.lastIndexOf(46);
            if (splitAt > 0) {
                embeddedName.substring(splitAt);
            }
            File tmp = File.createTempFile("tika-embedded-", suffix);
            this.wanted.put(embeddedName, tmp);
            return tmp;
        }

        @Override
        public Set<MediaType> getSupportedTypes(ParseContext context) {
            return null;
        }

        @Override
        public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            String name = metadata.get("resourceName");
            if (name != null && this.wanted.containsKey(name)) {
                FileOutputStream out = new FileOutputStream(this.wanted.get(name));
                IOUtils.copy(stream, (OutputStream)out);
                out.close();
            } else if (this.downstreamParser != null) {
                this.downstreamParser.parse(stream, handler, metadata, context);
            }
        }
    }

    private static class ImageDocumentSelector
    implements DocumentSelector {
        private ImageDocumentSelector() {
        }

        @Override
        public boolean select(Metadata metadata) {
            String type = metadata.get("Content-Type");
            return type != null && type.startsWith("image/");
        }
    }
}

