/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.PartAlreadyExistsException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.SheetNameFormatter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.SSCellRange;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.usermodel.XSSFAutoFilter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFEvenFooter;
import org.apache.poi.xssf.usermodel.XSSFEvenHeader;
import org.apache.poi.xssf.usermodel.XSSFFactory;
import org.apache.poi.xssf.usermodel.XSSFFirstFooter;
import org.apache.poi.xssf.usermodel.XSSFFirstHeader;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFOddFooter;
import org.apache.poi.xssf.usermodel.XSSFOddHeader;
import org.apache.poi.xssf.usermodel.XSSFPivotCache;
import org.apache.poi.xssf.usermodel.XSSFPivotCacheDefinition;
import org.apache.poi.xssf.usermodel.XSSFPivotCacheRecords;
import org.apache.poi.xssf.usermodel.XSSFPivotTable;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheetConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFVMLDrawing;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.helpers.ColumnHelper;
import org.apache.poi.xssf.usermodel.helpers.XSSFPaswordHelper;
import org.apache.poi.xssf.usermodel.helpers.XSSFRowShifter;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidations;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHeaderFooter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTLegacyDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCells;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOutlinePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageMargins;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetUpPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPrintOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSelection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTablePart;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableParts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCalcMode;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPaneState;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorksheetDocument;

public class XSSFSheet
extends POIXMLDocumentPart
implements Sheet {
    private static final POILogger logger = POILogFactory.getLogger(XSSFSheet.class);
    protected CTSheet sheet;
    protected CTWorksheet worksheet;
    private TreeMap<Integer, XSSFRow> _rows;
    private List<XSSFHyperlink> hyperlinks;
    private ColumnHelper columnHelper;
    private CommentsTable sheetComments;
    private Map<Integer, CTCellFormula> sharedFormulas;
    private TreeMap<String, XSSFTable> tables;
    private List<CellRangeAddress> arrayFormulas;
    private XSSFDataValidationHelper dataValidationHelper = new XSSFDataValidationHelper(this);

    protected XSSFSheet() {
        this.onDocumentCreate();
    }

    protected XSSFSheet(PackagePart part, PackageRelationship rel) {
        super(part, rel);
    }

    @Override
    public XSSFWorkbook getWorkbook() {
        return (XSSFWorkbook)this.getParent();
    }

    @Override
    protected void onDocumentRead() {
        try {
            this.read(this.getPackagePart().getInputStream());
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    protected void read(InputStream is) throws IOException {
        try {
            this.worksheet = WorksheetDocument.Factory.parse(is).getWorksheet();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        for (POIXMLDocumentPart p : this.getRelations()) {
            if (p instanceof CommentsTable) {
                this.sheetComments = (CommentsTable)p;
            }
            if (p instanceof XSSFTable) {
                this.tables.put(p.getPackageRelationship().getId(), (XSSFTable)p);
            }
            if (!(p instanceof XSSFPivotTable)) continue;
            this.getWorkbook().getPivotTables().add((XSSFPivotTable)p);
        }
        this.initHyperlinks();
    }

    @Override
    protected void onDocumentCreate() {
        this.worksheet = XSSFSheet.newSheet();
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
    }

    private void initRows(CTWorksheet worksheetParam) {
        this._rows = new TreeMap();
        this.tables = new TreeMap();
        this.sharedFormulas = new HashMap<Integer, CTCellFormula>();
        this.arrayFormulas = new ArrayList<CellRangeAddress>();
        for (CTRow row : worksheetParam.getSheetData().getRowArray()) {
            XSSFRow r = new XSSFRow(row, this);
            this._rows.put(r.getRowNum(), r);
        }
    }

    private void initHyperlinks() {
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
        if (!this.worksheet.isSetHyperlinks()) {
            return;
        }
        try {
            PackageRelationshipCollection hyperRels = this.getPackagePart().getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
            for (CTHyperlink hyperlink : this.worksheet.getHyperlinks().getHyperlinkArray()) {
                PackageRelationship hyperRel = null;
                if (hyperlink.getId() != null) {
                    hyperRel = hyperRels.getRelationshipByID(hyperlink.getId());
                }
                this.hyperlinks.add(new XSSFHyperlink(hyperlink, hyperRel));
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private static CTWorksheet newSheet() {
        CTWorksheet worksheet = CTWorksheet.Factory.newInstance();
        CTSheetFormatPr ctFormat = worksheet.addNewSheetFormatPr();
        ctFormat.setDefaultRowHeight(15.0);
        CTSheetView ctView = worksheet.addNewSheetViews().addNewSheetView();
        ctView.setWorkbookViewId(0L);
        worksheet.addNewDimension().setRef("A1");
        worksheet.addNewSheetData();
        CTPageMargins ctMargins = worksheet.addNewPageMargins();
        ctMargins.setBottom(0.75);
        ctMargins.setFooter(0.3);
        ctMargins.setHeader(0.3);
        ctMargins.setLeft(0.7);
        ctMargins.setRight(0.7);
        ctMargins.setTop(0.75);
        return worksheet;
    }

    @Internal
    public CTWorksheet getCTWorksheet() {
        return this.worksheet;
    }

    public ColumnHelper getColumnHelper() {
        return this.columnHelper;
    }

    @Override
    public String getSheetName() {
        return this.sheet.getName();
    }

    @Override
    public int addMergedRegion(CellRangeAddress region) {
        region.validate(SpreadsheetVersion.EXCEL2007);
        this.validateArrayFormulas(region);
        CTMergeCells ctMergeCells = this.worksheet.isSetMergeCells() ? this.worksheet.getMergeCells() : this.worksheet.addNewMergeCells();
        CTMergeCell ctMergeCell = ctMergeCells.addNewMergeCell();
        ctMergeCell.setRef(region.formatAsString());
        return ctMergeCells.sizeOfMergeCellArray();
    }

    private void validateArrayFormulas(CellRangeAddress region) {
        int firstRow = region.getFirstRow();
        int firstColumn = region.getFirstColumn();
        int lastRow = region.getLastRow();
        int lastColumn = region.getLastColumn();
        for (int rowIn = firstRow; rowIn <= lastRow; ++rowIn) {
            for (int colIn = firstColumn; colIn <= lastColumn; ++colIn) {
                CellRangeAddress arrayRange;
                XSSFCell cell;
                XSSFRow row = this.getRow(rowIn);
                if (row == null || (cell = row.getCell(colIn)) == null || !cell.isPartOfArrayFormulaGroup() || (arrayRange = cell.getArrayFormulaRange()).getNumberOfCells() <= 1 || !arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn()) && !arrayRange.isInRange(region.getFirstRow(), region.getFirstColumn())) continue;
                String msg = "The range " + region.formatAsString() + " intersects with a multi-cell array formula. " + "You cannot merge cells of an array.";
                throw new IllegalStateException(msg);
            }
        }
    }

    @Override
    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    @Override
    public void autoSizeColumn(int column, boolean useMergedCells) {
        double width = SheetUtil.getColumnWidth(this, column, useMergedCells);
        if (width != -1.0) {
            int maxColumnWidth = 65280;
            if ((width *= 256.0) > (double)maxColumnWidth) {
                width = maxColumnWidth;
            }
            this.setColumnWidth(column, (int)width);
            this.columnHelper.setColBestFit(column, true);
        }
    }

    @Override
    public XSSFDrawing createDrawingPatriarch() {
        XSSFDrawing drawing = null;
        CTDrawing ctDrawing = this.getCTDrawing();
        if (ctDrawing == null) {
            int drawingNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.DRAWINGS.getContentType()).size() + 1;
            drawing = (XSSFDrawing)this.createRelationship(XSSFRelation.DRAWINGS, XSSFFactory.getInstance(), drawingNumber);
            String relId = drawing.getPackageRelationship().getId();
            ctDrawing = this.worksheet.addNewDrawing();
            ctDrawing.setId(relId);
        } else {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSSFDrawing)) continue;
                XSSFDrawing dr = (XSSFDrawing)p;
                String drId = dr.getPackageRelationship().getId();
                if (!drId.equals(ctDrawing.getId())) break;
                drawing = dr;
                break;
            }
            if (drawing == null) {
                logger.log(7, "Can't find drawing with id=" + ctDrawing.getId() + " in the list of the sheet's relationships");
            }
        }
        return drawing;
    }

    protected XSSFVMLDrawing getVMLDrawing(boolean autoCreate) {
        XSSFVMLDrawing drawing = null;
        CTLegacyDrawing ctDrawing = this.getCTLegacyDrawing();
        if (ctDrawing == null) {
            if (autoCreate) {
                int drawingNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.VML_DRAWINGS.getContentType()).size() + 1;
                drawing = (XSSFVMLDrawing)this.createRelationship(XSSFRelation.VML_DRAWINGS, XSSFFactory.getInstance(), drawingNumber);
                String relId = drawing.getPackageRelationship().getId();
                ctDrawing = this.worksheet.addNewLegacyDrawing();
                ctDrawing.setId(relId);
            }
        } else {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSSFVMLDrawing)) continue;
                XSSFVMLDrawing dr = (XSSFVMLDrawing)p;
                String drId = dr.getPackageRelationship().getId();
                if (!drId.equals(ctDrawing.getId())) break;
                drawing = dr;
                break;
            }
            if (drawing == null) {
                logger.log(7, "Can't find VML drawing with id=" + ctDrawing.getId() + " in the list of the sheet's relationships");
            }
        }
        return drawing;
    }

    protected CTDrawing getCTDrawing() {
        return this.worksheet.getDrawing();
    }

    protected CTLegacyDrawing getCTLegacyDrawing() {
        return this.worksheet.getLegacyDrawing();
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        CTSheetView ctView = this.getDefaultSheetView();
        if (colSplit == 0 && rowSplit == 0) {
            if (ctView.isSetPane()) {
                ctView.unsetPane();
            }
            ctView.setSelectionArray(null);
            return;
        }
        if (!ctView.isSetPane()) {
            ctView.addNewPane();
        }
        CTPane pane = ctView.getPane();
        if (colSplit > 0) {
            pane.setXSplit(colSplit);
        } else if (pane.isSetXSplit()) {
            pane.unsetXSplit();
        }
        if (rowSplit > 0) {
            pane.setYSplit(rowSplit);
        } else if (pane.isSetYSplit()) {
            pane.unsetYSplit();
        }
        pane.setState(STPaneState.FROZEN);
        if (rowSplit == 0) {
            pane.setTopLeftCell(new CellReference(0, leftmostColumn).formatAsString());
            pane.setActivePane(STPane.TOP_RIGHT);
        } else if (colSplit == 0) {
            pane.setTopLeftCell(new CellReference(topRow, 0).formatAsString());
            pane.setActivePane(STPane.BOTTOM_LEFT);
        } else {
            pane.setTopLeftCell(new CellReference(topRow, leftmostColumn).formatAsString());
            pane.setActivePane(STPane.BOTTOM_RIGHT);
        }
        ctView.setSelectionArray(null);
        CTSelection sel = ctView.addNewSelection();
        sel.setPane(pane.getActivePane());
    }

    @Deprecated
    public XSSFComment createComment() {
        return this.createDrawingPatriarch().createCellComment(new XSSFClientAnchor());
    }

    @Override
    public XSSFRow createRow(int rownum) {
        CTRow ctRow;
        XSSFRow prev = this._rows.get(rownum);
        if (prev != null) {
            ctRow = prev.getCTRow();
            ctRow.set(CTRow.Factory.newInstance());
        } else if (this._rows.isEmpty() || rownum > this._rows.lastKey()) {
            ctRow = this.worksheet.getSheetData().addNewRow();
        } else {
            int idx = this._rows.headMap(rownum).size();
            ctRow = this.worksheet.getSheetData().insertNewRow(idx);
        }
        XSSFRow r = new XSSFRow(ctRow, this);
        r.setRowNum(rownum);
        this._rows.put(rownum, r);
        return r;
    }

    @Override
    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.createFreezePane(xSplitPos, ySplitPos, leftmostColumn, topRow);
        this.getPane().setState(STPaneState.SPLIT);
        this.getPane().setActivePane(STPane.Enum.forInt(activePane));
    }

    @Override
    public XSSFComment getCellComment(int row, int column) {
        if (this.sheetComments == null) {
            return null;
        }
        String ref = new CellReference(row, column).formatAsString();
        CTComment ctComment = this.sheetComments.getCTComment(ref);
        if (ctComment == null) {
            return null;
        }
        XSSFVMLDrawing vml = this.getVMLDrawing(false);
        return new XSSFComment(this.sheetComments, ctComment, vml == null ? null : vml.findCommentShape(row, column));
    }

    public XSSFHyperlink getHyperlink(int row, int column) {
        String ref = new CellReference(row, column).formatAsString();
        for (XSSFHyperlink hyperlink : this.hyperlinks) {
            if (!hyperlink.getCellRef().equals(ref)) continue;
            return hyperlink;
        }
        return null;
    }

    private int[] getBreaks(CTPageBreak ctPageBreak) {
        CTBreak[] brkArray = ctPageBreak.getBrkArray();
        int[] breaks = new int[brkArray.length];
        for (int i = 0; i < brkArray.length; ++i) {
            breaks[i] = (int)brkArray[i].getId() - 1;
        }
        return breaks;
    }

    private void removeBreak(int index, CTPageBreak ctPageBreak) {
        int index1 = index + 1;
        CTBreak[] brkArray = ctPageBreak.getBrkArray();
        for (int i = 0; i < brkArray.length; ++i) {
            if (brkArray[i].getId() != (long)index1) continue;
            ctPageBreak.removeBrk(i);
        }
    }

    @Override
    public int[] getColumnBreaks() {
        return this.worksheet.isSetColBreaks() ? this.getBreaks(this.worksheet.getColBreaks()) : new int[]{};
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        double width = col == null || !col.isSetWidth() ? (double)this.getDefaultColumnWidth() : col.getWidth();
        return (int)(width * 256.0);
    }

    @Override
    public float getColumnWidthInPixels(int columnIndex) {
        float widthIn256 = this.getColumnWidth(columnIndex);
        return (float)((double)widthIn256 / 256.0 * (double)7.0017f);
    }

    @Override
    public int getDefaultColumnWidth() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return pr == null ? 8 : (int)pr.getBaseColWidth();
    }

    @Override
    public short getDefaultRowHeight() {
        return (short)(this.getDefaultRowHeightInPoints() * 20.0f);
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return (float)(pr == null ? 0.0 : pr.getDefaultRowHeight());
    }

    private CTSheetFormatPr getSheetTypeSheetFormatPr() {
        return this.worksheet.isSetSheetFormatPr() ? this.worksheet.getSheetFormatPr() : this.worksheet.addNewSheetFormatPr();
    }

    @Override
    public CellStyle getColumnStyle(int column) {
        int idx = this.columnHelper.getColDefaultStyle(column);
        return this.getWorkbook().getCellStyleAt((short)(idx == -1 ? 0 : idx));
    }

    @Override
    public void setRightToLeft(boolean value) {
        CTSheetView view = this.getDefaultSheetView();
        view.setRightToLeft(value);
    }

    @Override
    public boolean isRightToLeft() {
        CTSheetView view = this.getDefaultSheetView();
        return view != null && view.getRightToLeft();
    }

    @Override
    public boolean getDisplayGuts() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? CTOutlinePr.Factory.newInstance() : sheetPr.getOutlinePr();
        return outlinePr.getShowOutlineSymbols();
    }

    @Override
    public void setDisplayGuts(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? sheetPr.addNewOutlinePr() : sheetPr.getOutlinePr();
        outlinePr.setShowOutlineSymbols(value);
    }

    @Override
    public boolean isDisplayZeros() {
        CTSheetView view = this.getDefaultSheetView();
        return view == null || view.getShowZeros();
    }

    @Override
    public void setDisplayZeros(boolean value) {
        CTSheetView view = this.getSheetTypeSheetView();
        view.setShowZeros(value);
    }

    @Override
    public int getFirstRowNum() {
        return this._rows.isEmpty() ? 0 : this._rows.firstKey();
    }

    @Override
    public boolean getFitToPage() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getFitToPage();
    }

    private CTSheetPr getSheetTypeSheetPr() {
        if (this.worksheet.getSheetPr() == null) {
            this.worksheet.setSheetPr(CTSheetPr.Factory.newInstance());
        }
        return this.worksheet.getSheetPr();
    }

    private CTHeaderFooter getSheetTypeHeaderFooter() {
        if (this.worksheet.getHeaderFooter() == null) {
            this.worksheet.setHeaderFooter(CTHeaderFooter.Factory.newInstance());
        }
        return this.worksheet.getHeaderFooter();
    }

    @Override
    public Footer getFooter() {
        return this.getOddFooter();
    }

    @Override
    public Header getHeader() {
        return this.getOddHeader();
    }

    public Footer getOddFooter() {
        return new XSSFOddFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getEvenFooter() {
        return new XSSFEvenFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getFirstFooter() {
        return new XSSFFirstFooter(this.getSheetTypeHeaderFooter());
    }

    public Header getOddHeader() {
        return new XSSFOddHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getEvenHeader() {
        return new XSSFEvenHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getFirstHeader() {
        return new XSSFFirstHeader(this.getSheetTypeHeaderFooter());
    }

    @Override
    public boolean getHorizontallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getHorizontalCentered();
    }

    @Override
    public int getLastRowNum() {
        return this._rows.isEmpty() ? 0 : this._rows.lastKey();
    }

    @Override
    public short getLeftCol() {
        String cellRef = this.worksheet.getSheetViews().getSheetViewArray(0).getTopLeftCell();
        if (cellRef == null) {
            return 0;
        }
        CellReference cellReference = new CellReference(cellRef);
        return cellReference.getCol();
    }

    @Override
    public double getMargin(short margin) {
        if (!this.worksheet.isSetPageMargins()) {
            return 0.0;
        }
        CTPageMargins pageMargins = this.worksheet.getPageMargins();
        switch (margin) {
            case 0: {
                return pageMargins.getLeft();
            }
            case 1: {
                return pageMargins.getRight();
            }
            case 2: {
                return pageMargins.getTop();
            }
            case 3: {
                return pageMargins.getBottom();
            }
            case 4: {
                return pageMargins.getHeader();
            }
            case 5: {
                return pageMargins.getFooter();
            }
        }
        throw new IllegalArgumentException("Unknown margin constant:  " + margin);
    }

    @Override
    public void setMargin(short margin, double size) {
        CTPageMargins pageMargins = this.worksheet.isSetPageMargins() ? this.worksheet.getPageMargins() : this.worksheet.addNewPageMargins();
        switch (margin) {
            case 0: {
                pageMargins.setLeft(size);
                break;
            }
            case 1: {
                pageMargins.setRight(size);
                break;
            }
            case 2: {
                pageMargins.setTop(size);
                break;
            }
            case 3: {
                pageMargins.setBottom(size);
                break;
            }
            case 4: {
                pageMargins.setHeader(size);
                break;
            }
            case 5: {
                pageMargins.setFooter(size);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown margin constant:  " + margin);
            }
        }
    }

    @Override
    public CellRangeAddress getMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        if (ctMergeCells == null) {
            throw new IllegalStateException("This worksheet does not contain merged regions");
        }
        CTMergeCell ctMergeCell = ctMergeCells.getMergeCellArray(index);
        String ref = ctMergeCell.getRef();
        return CellRangeAddress.valueOf(ref);
    }

    @Override
    public int getNumMergedRegions() {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        return ctMergeCells == null ? 0 : ctMergeCells.sizeOfMergeCellArray();
    }

    public int getNumHyperlinks() {
        return this.hyperlinks.size();
    }

    @Override
    public PaneInformation getPaneInformation() {
        CTPane pane = this.getDefaultSheetView().getPane();
        if (pane == null) {
            return null;
        }
        CellReference cellRef = pane.isSetTopLeftCell() ? new CellReference(pane.getTopLeftCell()) : null;
        return new PaneInformation((short)pane.getXSplit(), (short)pane.getYSplit(), (short)(cellRef == null ? 0 : cellRef.getRow()), cellRef == null ? (short)0 : cellRef.getCol(), (byte)(pane.getActivePane().intValue() - 1), pane.getState() == STPaneState.FROZEN);
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this._rows.size();
    }

    @Override
    public XSSFPrintSetup getPrintSetup() {
        return new XSSFPrintSetup(this.worksheet);
    }

    @Override
    public boolean getProtect() {
        return this.isSheetLocked();
    }

    @Override
    public void protectSheet(String password) {
        if (password != null) {
            CTSheetProtection sheetProtection = this.safeGetProtectionField();
            this.setSheetPassword(password, null);
            sheetProtection.setSheet(true);
            sheetProtection.setScenarios(true);
            sheetProtection.setObjects(true);
        } else {
            this.worksheet.unsetSheetProtection();
        }
    }

    public void setSheetPassword(String password, HashAlgorithm hashAlgo) {
        if (password == null && !this.isSheetProtectionEnabled()) {
            return;
        }
        XSSFPaswordHelper.setPassword(this.safeGetProtectionField(), password, hashAlgo, null);
    }

    public boolean validateSheetPassword(String password) {
        if (!this.isSheetProtectionEnabled()) {
            return password == null;
        }
        return XSSFPaswordHelper.validatePassword(this.safeGetProtectionField(), password, null);
    }

    @Override
    public XSSFRow getRow(int rownum) {
        return this._rows.get(rownum);
    }

    @Override
    public int[] getRowBreaks() {
        return this.worksheet.isSetRowBreaks() ? this.getBreaks(this.worksheet.getRowBreaks()) : new int[]{};
    }

    @Override
    public boolean getRowSumsBelow() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : null;
        return outlinePr == null || outlinePr.getSummaryBelow();
    }

    @Override
    public void setRowSumsBelow(boolean value) {
        this.ensureOutlinePr().setSummaryBelow(value);
    }

    @Override
    public boolean getRowSumsRight() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : CTOutlinePr.Factory.newInstance();
        return outlinePr.getSummaryRight();
    }

    @Override
    public void setRowSumsRight(boolean value) {
        this.ensureOutlinePr().setSummaryRight(value);
    }

    private CTOutlinePr ensureOutlinePr() {
        CTSheetPr sheetPr = this.worksheet.isSetSheetPr() ? this.worksheet.getSheetPr() : this.worksheet.addNewSheetPr();
        return sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : sheetPr.addNewOutlinePr();
    }

    @Override
    public boolean getScenarioProtect() {
        return this.worksheet.isSetSheetProtection() && this.worksheet.getSheetProtection().getScenarios();
    }

    @Override
    public short getTopRow() {
        String cellRef = this.getSheetTypeSheetView().getTopLeftCell();
        if (cellRef == null) {
            return 0;
        }
        CellReference cellReference = new CellReference(cellRef);
        return (short)cellReference.getRow();
    }

    @Override
    public boolean getVerticallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getVerticalCentered();
    }

    @Override
    public void groupColumn(int fromColumn, int toColumn) {
        this.groupColumn1Based(fromColumn + 1, toColumn + 1);
    }

    private void groupColumn1Based(int fromColumn, int toColumn) {
        CTCols ctCols = this.worksheet.getColsArray(0);
        CTCol ctCol = CTCol.Factory.newInstance();
        CTCol fixCol_before = this.columnHelper.getColumn1Based(toColumn, false);
        if (fixCol_before != null) {
            fixCol_before = (CTCol)fixCol_before.copy();
        }
        ctCol.setMin(fromColumn);
        ctCol.setMax(toColumn);
        this.columnHelper.addCleanColIntoCols(ctCols, ctCol);
        CTCol fixCol_after = this.columnHelper.getColumn1Based(toColumn, false);
        if (fixCol_before != null && fixCol_after != null) {
            this.columnHelper.setColumnAttributes(fixCol_before, fixCol_after);
        }
        for (int index = fromColumn; index <= toColumn; ++index) {
            CTCol col = this.columnHelper.getColumn1Based(index, false);
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel + 1));
            index = (int)col.getMax();
        }
        this.worksheet.setColsArray(0, ctCols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    private void setColWidthAttribute(CTCols ctCols) {
        for (CTCol col : ctCols.getColArray()) {
            if (col.isSetWidth()) continue;
            col.setWidth(this.getDefaultColumnWidth());
            col.setCustomWidth(false);
        }
    }

    @Override
    public void groupRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            XSSFRow xrow = this.getRow(i);
            if (xrow == null) {
                xrow = this.createRow(i);
            }
            CTRow ctrow = xrow.getCTRow();
            short outlineLevel = ctrow.getOutlineLevel();
            ctrow.setOutlineLevel((short)(outlineLevel + 1));
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private short getMaxOutlineLevelRows() {
        int outlineLevel = 0;
        for (XSSFRow xrow : this._rows.values()) {
            outlineLevel = Math.max(outlineLevel, xrow.getCTRow().getOutlineLevel());
        }
        return (short)outlineLevel;
    }

    private short getMaxOutlineLevelCols() {
        CTCols ctCols = this.worksheet.getColsArray(0);
        int outlineLevel = 0;
        for (CTCol col : ctCols.getColArray()) {
            outlineLevel = Math.max(outlineLevel, col.getOutlineLevel());
        }
        return (short)outlineLevel;
    }

    @Override
    public boolean isColumnBroken(int column) {
        for (int colBreak : this.getColumnBreaks()) {
            if (colBreak != column) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnHidden(int columnIndex) {
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        return col != null && col.getHidden();
    }

    @Override
    public boolean isDisplayFormulas() {
        return this.getSheetTypeSheetView().getShowFormulas();
    }

    @Override
    public boolean isDisplayGridlines() {
        return this.getSheetTypeSheetView().getShowGridLines();
    }

    @Override
    public void setDisplayGridlines(boolean show) {
        this.getSheetTypeSheetView().setShowGridLines(show);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this.getSheetTypeSheetView().getShowRowColHeaders();
    }

    @Override
    public void setDisplayRowColHeadings(boolean show) {
        this.getSheetTypeSheetView().setShowRowColHeaders(show);
    }

    @Override
    public boolean isPrintGridlines() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getGridLines();
    }

    @Override
    public void setPrintGridlines(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setGridLines(value);
    }

    @Override
    public boolean isRowBroken(int row) {
        for (int rowBreak : this.getRowBreaks()) {
            if (rowBreak != row) continue;
            return true;
        }
        return false;
    }

    private void setBreak(int id, CTPageBreak ctPgBreak, int lastIndex) {
        CTBreak brk = ctPgBreak.addNewBrk();
        brk.setId(id + 1);
        brk.setMan(true);
        brk.setMax(lastIndex);
        int nPageBreaks = ctPgBreak.sizeOfBrkArray();
        ctPgBreak.setCount(nPageBreaks);
        ctPgBreak.setManualBreakCount(nPageBreaks);
    }

    @Override
    public void setRowBreak(int row) {
        if (!this.isRowBroken(row)) {
            CTPageBreak pgBreak = this.worksheet.isSetRowBreaks() ? this.worksheet.getRowBreaks() : this.worksheet.addNewRowBreaks();
            this.setBreak(row, pgBreak, SpreadsheetVersion.EXCEL2007.getLastColumnIndex());
        }
    }

    @Override
    public void removeColumnBreak(int column) {
        if (this.worksheet.isSetColBreaks()) {
            this.removeBreak(column, this.worksheet.getColBreaks());
        }
    }

    @Override
    public void removeMergedRegion(int index) {
        if (!this.worksheet.isSetMergeCells()) {
            return;
        }
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        int size = ctMergeCells.sizeOfMergeCellArray();
        assert (0 <= index && index < size);
        if (size > 1) {
            ctMergeCells.removeMergeCell(index);
        } else {
            this.worksheet.unsetMergeCells();
        }
    }

    public void removeMergedRegions(Set<Integer> indices) {
        if (!this.worksheet.isSetMergeCells()) {
            return;
        }
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        ArrayList<CTMergeCell> newMergeCells = new ArrayList<CTMergeCell>(ctMergeCells.sizeOfMergeCellArray());
        int idx = 0;
        for (CTMergeCell mc : ctMergeCells.getMergeCellArray()) {
            if (indices.contains(idx++)) continue;
            newMergeCells.add(mc);
        }
        if (newMergeCells.isEmpty()) {
            this.worksheet.unsetMergeCells();
        } else {
            CTMergeCell[] newMergeCellsArray = new CTMergeCell[newMergeCells.size()];
            ctMergeCells.setMergeCellArray(newMergeCells.toArray(newMergeCellsArray));
        }
    }

    @Override
    public void removeRow(Row row) {
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        ArrayList<XSSFCell> cellsToDelete = new ArrayList<XSSFCell>();
        for (Cell cell : row) {
            cellsToDelete.add((XSSFCell)cell);
        }
        for (XSSFCell xSSFCell : cellsToDelete) {
            row.removeCell(xSSFCell);
        }
        int idx = this._rows.headMap(row.getRowNum()).size();
        this._rows.remove(row.getRowNum());
        this.worksheet.getSheetData().removeRow(idx);
    }

    @Override
    public void removeRowBreak(int row) {
        if (this.worksheet.isSetRowBreaks()) {
            this.removeBreak(row, this.worksheet.getRowBreaks());
        }
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        CTCalcPr calcPr = this.getWorkbook().getCTWorkbook().getCalcPr();
        if (this.worksheet.isSetSheetCalcPr()) {
            CTSheetCalcPr calc = this.worksheet.getSheetCalcPr();
            calc.setFullCalcOnLoad(value);
        } else if (value) {
            CTSheetCalcPr calc = this.worksheet.addNewSheetCalcPr();
            calc.setFullCalcOnLoad(value);
        }
        if (value && calcPr != null && calcPr.getCalcMode() == STCalcMode.MANUAL) {
            calcPr.setCalcMode(STCalcMode.AUTO);
        }
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        if (this.worksheet.isSetSheetCalcPr()) {
            CTSheetCalcPr calc = this.worksheet.getSheetCalcPr();
            return calc.getFullCalcOnLoad();
        }
        return false;
    }

    @Override
    public Iterator<Row> rowIterator() {
        return this._rows.values().iterator();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    @Override
    public boolean getAutobreaks() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getAutoPageBreaks();
    }

    @Override
    public void setAutobreaks(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
        psSetup.setAutoPageBreaks(value);
    }

    @Override
    public void setColumnBreak(int column) {
        if (!this.isColumnBroken(column)) {
            CTPageBreak pgBreak = this.worksheet.isSetColBreaks() ? this.worksheet.getColBreaks() : this.worksheet.addNewColBreaks();
            this.setBreak(column, pgBreak, SpreadsheetVersion.EXCEL2007.getLastRowIndex());
        }
    }

    @Override
    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        if (collapsed) {
            this.collapseColumn(columnNumber);
        } else {
            this.expandColumn(columnNumber);
        }
    }

    private void collapseColumn(int columnNumber) {
        CTCol col;
        CTCols cols = this.worksheet.getColsArray(0);
        int colInfoIx = this.columnHelper.getIndexOfColumn(cols, col = this.columnHelper.getColumn(columnNumber, false));
        if (colInfoIx == -1) {
            return;
        }
        int groupStartColInfoIx = this.findStartOfColumnOutlineGroup(colInfoIx);
        CTCol columnInfo = cols.getColArray(groupStartColInfoIx);
        int lastColMax = this.setGroupHidden(groupStartColInfoIx, columnInfo.getOutlineLevel(), true);
        this.setColumn(lastColMax + 1, 0, null, null, Boolean.TRUE);
    }

    private void setColumn(int targetColumnIx, Integer style, Integer level, Boolean hidden, Boolean collapsed) {
        boolean columnChanged;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol ci = null;
        for (CTCol tci : cols.getColArray()) {
            long tciMin = tci.getMin();
            long tciMax = tci.getMax();
            if (tciMin >= (long)targetColumnIx && tciMax <= (long)targetColumnIx) {
                ci = tci;
                break;
            }
            if (tciMin > (long)targetColumnIx) break;
        }
        if (ci == null) {
            CTCol nci = CTCol.Factory.newInstance();
            nci.setMin(targetColumnIx);
            nci.setMax(targetColumnIx);
            this.unsetCollapsed(collapsed, nci);
            this.columnHelper.addCleanColIntoCols(cols, nci);
            return;
        }
        boolean styleChanged = style != null && ci.getStyle() != (long)style.intValue();
        boolean levelChanged = level != null && ci.getOutlineLevel() != level.intValue();
        boolean hiddenChanged = hidden != null && ci.getHidden() != hidden.booleanValue();
        boolean collapsedChanged = collapsed != null && ci.getCollapsed() != collapsed.booleanValue();
        boolean bl = columnChanged = levelChanged || hiddenChanged || collapsedChanged || styleChanged;
        if (!columnChanged) {
            return;
        }
        long ciMin = ci.getMin();
        long ciMax = ci.getMax();
        if (ciMin == (long)targetColumnIx && ciMax == (long)targetColumnIx) {
            this.unsetCollapsed(collapsed, ci);
            return;
        }
        if (ciMin == (long)targetColumnIx || ciMax == (long)targetColumnIx) {
            if (ciMin == (long)targetColumnIx) {
                ci.setMin(targetColumnIx + 1);
            } else {
                ci.setMax(targetColumnIx - 1);
            }
            CTCol nci = this.columnHelper.cloneCol(cols, ci);
            nci.setMin(targetColumnIx);
            this.unsetCollapsed(collapsed, nci);
            this.columnHelper.addCleanColIntoCols(cols, nci);
        } else {
            CTCol ciMid = this.columnHelper.cloneCol(cols, ci);
            CTCol ciEnd = this.columnHelper.cloneCol(cols, ci);
            int lastcolumn = (int)ciMax;
            ci.setMax(targetColumnIx - 1);
            ciMid.setMin(targetColumnIx);
            ciMid.setMax(targetColumnIx);
            this.unsetCollapsed(collapsed, ciMid);
            this.columnHelper.addCleanColIntoCols(cols, ciMid);
            ciEnd.setMin(targetColumnIx + 1);
            ciEnd.setMax(lastcolumn);
            this.columnHelper.addCleanColIntoCols(cols, ciEnd);
        }
    }

    private void unsetCollapsed(boolean collapsed, CTCol ci) {
        if (collapsed) {
            ci.setCollapsed(collapsed);
        } else {
            ci.unsetCollapsed();
        }
    }

    private int setGroupHidden(int pIdx, int level, boolean hidden) {
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol[] colArray = cols.getColArray();
        CTCol columnInfo = colArray[idx];
        for (idx = pIdx; idx < colArray.length; ++idx) {
            columnInfo.setHidden(hidden);
            if (idx + 1 >= colArray.length) continue;
            CTCol nextColumnInfo = colArray[idx + 1];
            if (!this.isAdjacentBefore(columnInfo, nextColumnInfo) || nextColumnInfo.getOutlineLevel() < level) break;
            columnInfo = nextColumnInfo;
        }
        return (int)columnInfo.getMax();
    }

    private boolean isAdjacentBefore(CTCol col, CTCol other_col) {
        return col.getMax() == other_col.getMin() - 1L;
    }

    private int findStartOfColumnOutlineGroup(int pIdx) {
        CTCol prevColumnInfo;
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol[] colArray = cols.getColArray();
        CTCol columnInfo = colArray[pIdx];
        short level = columnInfo.getOutlineLevel();
        for (idx = pIdx; idx != 0 && this.isAdjacentBefore(prevColumnInfo = colArray[idx - 1], columnInfo) && prevColumnInfo.getOutlineLevel() >= level; --idx) {
            columnInfo = prevColumnInfo;
        }
        return idx;
    }

    private int findEndOfColumnOutlineGroup(int colInfoIndex) {
        CTCol nextColumnInfo;
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol[] colArray = cols.getColArray();
        CTCol columnInfo = colArray[colInfoIndex];
        short level = columnInfo.getOutlineLevel();
        int lastIdx = colArray.length - 1;
        for (idx = colInfoIndex; idx < lastIdx && this.isAdjacentBefore(columnInfo, nextColumnInfo = colArray[idx + 1]) && nextColumnInfo.getOutlineLevel() >= level; ++idx) {
            columnInfo = nextColumnInfo;
        }
        return idx;
    }

    private void expandColumn(int columnIndex) {
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        int colInfoIx = this.columnHelper.getIndexOfColumn(cols, col);
        int idx = this.findColInfoIdx((int)col.getMax(), colInfoIx);
        if (idx == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfColumnOutlineGroup(idx);
        int endIdx = this.findEndOfColumnOutlineGroup(idx);
        CTCol[] colArray = cols.getColArray();
        CTCol columnInfo = colArray[endIdx];
        if (!this.isColumnGroupHiddenByParent(idx)) {
            short outlineLevel = columnInfo.getOutlineLevel();
            boolean nestedGroup = false;
            for (int i = startIdx; i <= endIdx; ++i) {
                CTCol ci = colArray[i];
                if (outlineLevel == ci.getOutlineLevel()) {
                    ci.unsetHidden();
                    if (!nestedGroup) continue;
                    nestedGroup = false;
                    ci.setCollapsed(true);
                    continue;
                }
                nestedGroup = true;
            }
        }
        this.setColumn((int)columnInfo.getMax() + 1, null, null, Boolean.FALSE, Boolean.FALSE);
    }

    private boolean isColumnGroupHiddenByParent(int idx) {
        CTCol prevInfo;
        CTCol nextInfo;
        CTCol[] colArray;
        CTCols cols = this.worksheet.getColsArray(0);
        short endLevel = 0;
        boolean endHidden = false;
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        if (endOfOutlineGroupIdx < (colArray = cols.getColArray()).length && this.isAdjacentBefore(colArray[endOfOutlineGroupIdx], nextInfo = colArray[endOfOutlineGroupIdx + 1])) {
            endLevel = nextInfo.getOutlineLevel();
            endHidden = nextInfo.getHidden();
        }
        short startLevel = 0;
        boolean startHidden = false;
        int startOfOutlineGroupIdx = this.findStartOfColumnOutlineGroup(idx);
        if (startOfOutlineGroupIdx > 0 && this.isAdjacentBefore(prevInfo = colArray[startOfOutlineGroupIdx - 1], colArray[startOfOutlineGroupIdx])) {
            startLevel = prevInfo.getOutlineLevel();
            startHidden = prevInfo.getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private int findColInfoIdx(int columnValue, int fromColInfoIdx) {
        CTCols cols = this.worksheet.getColsArray(0);
        if (columnValue < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + columnValue);
        }
        if (fromColInfoIdx < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + fromColInfoIdx);
        }
        CTCol[] colArray = cols.getColArray();
        for (int k = fromColInfoIdx; k < colArray.length; ++k) {
            CTCol ci = colArray[k];
            if (this.containsColumn(ci, columnValue)) {
                return k;
            }
            if (ci.getMin() > (long)fromColInfoIdx) break;
        }
        return -1;
    }

    private boolean containsColumn(CTCol col, int columnIndex) {
        return col.getMin() <= (long)columnIndex && (long)columnIndex <= col.getMax();
    }

    private boolean isColumnGroupCollapsed(int idx) {
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol[] colArray = cols.getColArray();
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        int nextColInfoIx = endOfOutlineGroupIdx + 1;
        if (nextColInfoIx >= colArray.length) {
            return false;
        }
        CTCol col = colArray[endOfOutlineGroupIdx];
        CTCol nextColInfo = colArray[nextColInfoIx];
        if (!this.isAdjacentBefore(col, nextColInfo)) {
            return false;
        }
        return nextColInfo.getCollapsed();
    }

    @Override
    public void setColumnHidden(int columnIndex, boolean hidden) {
        this.columnHelper.setColHidden(columnIndex, hidden);
    }

    @Override
    public void setColumnWidth(int columnIndex, int width) {
        if (width > 65280) {
            throw new IllegalArgumentException("The maximum column width for an individual cell is 255 characters.");
        }
        this.columnHelper.setColWidth(columnIndex, (double)width / 256.0);
        this.columnHelper.setCustomWidth(columnIndex, true);
    }

    @Override
    public void setDefaultColumnStyle(int column, CellStyle style) {
        this.columnHelper.setColDefaultStyle((long)column, style);
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this.getSheetTypeSheetFormatPr().setBaseColWidth(width);
    }

    @Override
    public void setDefaultRowHeight(short height) {
        this.setDefaultRowHeightInPoints((float)height / 20.0f);
    }

    @Override
    public void setDefaultRowHeightInPoints(float height) {
        CTSheetFormatPr pr = this.getSheetTypeSheetFormatPr();
        pr.setDefaultRowHeight(height);
        pr.setCustomHeight(true);
    }

    @Override
    public void setDisplayFormulas(boolean show) {
        this.getSheetTypeSheetView().setShowFormulas(show);
    }

    private CTSheetView getSheetTypeSheetView() {
        if (this.getDefaultSheetView() == null) {
            this.getSheetTypeSheetViews().setSheetViewArray(0, CTSheetView.Factory.newInstance());
        }
        return this.getDefaultSheetView();
    }

    @Override
    public void setFitToPage(boolean b) {
        this.getSheetTypePageSetUpPr().setFitToPage(b);
    }

    @Override
    public void setHorizontallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setHorizontalCentered(value);
    }

    @Override
    public void setVerticallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setVerticalCentered(value);
    }

    @Override
    public void setRowGroupCollapsed(int rowIndex, boolean collapse) {
        if (collapse) {
            this.collapseRow(rowIndex);
        } else {
            this.expandRow(rowIndex);
        }
    }

    private void collapseRow(int rowIndex) {
        XSSFRow row = this.getRow(rowIndex);
        if (row != null) {
            int startRow = this.findStartOfRowOutlineGroup(rowIndex);
            int lastRow = this.writeHidden(row, startRow, true);
            if (this.getRow(lastRow) != null) {
                this.getRow(lastRow).getCTRow().setCollapsed(true);
            } else {
                XSSFRow newRow = this.createRow(lastRow);
                newRow.getCTRow().setCollapsed(true);
            }
        }
    }

    private int findStartOfRowOutlineGroup(int rowIndex) {
        short level = this.getRow(rowIndex).getCTRow().getOutlineLevel();
        int currentRow = rowIndex;
        while (this.getRow(currentRow) != null) {
            if (this.getRow(currentRow).getCTRow().getOutlineLevel() < level) {
                return currentRow + 1;
            }
            --currentRow;
        }
        return currentRow;
    }

    private int writeHidden(XSSFRow xRow, int rowIndex, boolean hidden) {
        short level = xRow.getCTRow().getOutlineLevel();
        Iterator<Row> it = this.rowIterator();
        while (it.hasNext()) {
            xRow = (XSSFRow)it.next();
            if (xRow.getRowNum() < rowIndex || xRow.getCTRow().getOutlineLevel() < level) continue;
            xRow.getCTRow().setHidden(hidden);
            ++rowIndex;
        }
        return rowIndex;
    }

    private void expandRow(int rowNumber) {
        CTRow ctRow;
        if (rowNumber == -1) {
            return;
        }
        XSSFRow row = this.getRow(rowNumber);
        if (!row.getCTRow().isSetHidden()) {
            return;
        }
        int startIdx = this.findStartOfRowOutlineGroup(rowNumber);
        int endIdx = this.findEndOfRowOutlineGroup(rowNumber);
        short level = row.getCTRow().getOutlineLevel();
        if (!this.isRowGroupHiddenByParent(rowNumber)) {
            for (int i = startIdx; i < endIdx; ++i) {
                if (level == this.getRow(i).getCTRow().getOutlineLevel()) {
                    this.getRow(i).getCTRow().unsetHidden();
                    continue;
                }
                if (this.isRowGroupCollapsed(i)) continue;
                this.getRow(i).getCTRow().unsetHidden();
            }
        }
        if ((ctRow = this.getRow(endIdx).getCTRow()).getCollapsed()) {
            ctRow.unsetCollapsed();
        }
    }

    public int findEndOfRowOutlineGroup(int row) {
        int currentRow;
        short level = this.getRow(row).getCTRow().getOutlineLevel();
        for (currentRow = row; currentRow < this.getLastRowNum() && this.getRow(currentRow) != null && this.getRow(currentRow).getCTRow().getOutlineLevel() >= level; ++currentRow) {
        }
        return currentRow;
    }

    private boolean isRowGroupHiddenByParent(int row) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfRowOutlineGroup(row);
        if (this.getRow(endOfOutlineGroupIdx) == null) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = this.getRow(endOfOutlineGroupIdx).getCTRow().getOutlineLevel();
            endHidden = this.getRow(endOfOutlineGroupIdx).getCTRow().getHidden();
        }
        int startOfOutlineGroupIdx = this.findStartOfRowOutlineGroup(row);
        if (startOfOutlineGroupIdx < 0 || this.getRow(startOfOutlineGroupIdx) == null) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = this.getRow(startOfOutlineGroupIdx).getCTRow().getOutlineLevel();
            startHidden = this.getRow(startOfOutlineGroupIdx).getCTRow().getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private boolean isRowGroupCollapsed(int row) {
        int collapseRow = this.findEndOfRowOutlineGroup(row) + 1;
        if (this.getRow(collapseRow) == null) {
            return false;
        }
        return this.getRow(collapseRow).getCTRow().getCollapsed();
    }

    @Override
    public void setZoom(int numerator, int denominator) {
        int zoom = 100 * numerator / denominator;
        this.setZoom(zoom);
    }

    public void setZoom(int scale) {
        if (scale < 10 || scale > 400) {
            throw new IllegalArgumentException("Valid scale values range from 10 to 400");
        }
        this.getSheetTypeSheetView().setZoomScale(scale);
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        int rownum;
        XSSFRow row;
        Iterator<Row> it = this.rowIterator();
        while (it.hasNext()) {
            row = (XSSFRow)it.next();
            rownum = row.getRowNum();
            if (!this.removeRow(startRow, endRow, n, rownum)) continue;
            int idx = this._rows.headMap(row.getRowNum()).size();
            this.worksheet.getSheetData().removeRow(idx);
            it.remove();
        }
        it = this.rowIterator();
        while (it.hasNext()) {
            row = (XSSFRow)it.next();
            rownum = row.getRowNum();
            if (this.sheetComments != null) {
                CTCommentList lst = this.sheetComments.getCTComments().getCommentList();
                for (CTComment comment : lst.getCommentArray()) {
                    String oldRef = comment.getRef();
                    CellReference ref = new CellReference(oldRef);
                    if (ref.getRow() != rownum) continue;
                    ref = new CellReference(rownum + n, ref.getCol());
                    comment.setRef(ref.formatAsString());
                    this.sheetComments.referenceUpdated(oldRef, comment);
                }
            }
            if (rownum < startRow || rownum > endRow) continue;
            if (!copyRowHeight) {
                row.setHeight((short)-1);
            }
            row.shift(n);
        }
        XSSFRowShifter rowShifter = new XSSFRowShifter(this);
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        String sheetName = this.getWorkbook().getSheetName(sheetIndex);
        FormulaShifter shifter = FormulaShifter.createForRowShift(sheetIndex, sheetName, startRow, endRow, n);
        rowShifter.updateNamedRanges(shifter);
        rowShifter.updateFormulas(shifter);
        rowShifter.shiftMerged(startRow, endRow, n);
        rowShifter.updateConditionalFormatting(shifter);
        TreeMap<Integer, XSSFRow> map = new TreeMap<Integer, XSSFRow>();
        for (XSSFRow r : this._rows.values()) {
            map.put(r.getRowNum(), r);
        }
        this._rows = map;
    }

    @Override
    public void showInPane(int toprow, int leftcol) {
        CellReference cellReference = new CellReference(toprow, leftcol);
        String cellRef = cellReference.formatAsString();
        this.getPane().setTopLeftCell(cellRef);
    }

    @Override
    @Deprecated
    public void showInPane(short toprow, short leftcol) {
        this.showInPane((int)toprow, (int)leftcol);
    }

    @Override
    public void ungroupColumn(int fromColumn, int toColumn) {
        CTCols cols = this.worksheet.getColsArray(0);
        for (int index = fromColumn; index <= toColumn; ++index) {
            CTCol col = this.columnHelper.getColumn(index, false);
            if (col == null) continue;
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel - 1));
            index = (int)col.getMax();
            if (col.getOutlineLevel() > 0) continue;
            int colIndex = this.columnHelper.getIndexOfColumn(cols, col);
            this.worksheet.getColsArray(0).removeCol(colIndex);
        }
        this.worksheet.setColsArray(0, cols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    @Override
    public void ungroupRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            XSSFRow xrow = this.getRow(i);
            if (xrow == null) continue;
            CTRow ctRow = xrow.getCTRow();
            short outlineLevel = ctRow.getOutlineLevel();
            ctRow.setOutlineLevel((short)(outlineLevel - 1));
            if (outlineLevel != 1 || xrow.getFirstCellNum() != -1) continue;
            this.removeRow(xrow);
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private void setSheetFormatPrOutlineLevelRow() {
        short maxLevelRow = this.getMaxOutlineLevelRows();
        this.getSheetTypeSheetFormatPr().setOutlineLevelRow(maxLevelRow);
    }

    private void setSheetFormatPrOutlineLevelCol() {
        short maxLevelCol = this.getMaxOutlineLevelCols();
        this.getSheetTypeSheetFormatPr().setOutlineLevelCol(maxLevelCol);
    }

    private CTSheetViews getSheetTypeSheetViews() {
        if (this.worksheet.getSheetViews() == null) {
            this.worksheet.setSheetViews(CTSheetViews.Factory.newInstance());
            this.worksheet.getSheetViews().addNewSheetView();
        }
        return this.worksheet.getSheetViews();
    }

    @Override
    public boolean isSelected() {
        CTSheetView view = this.getDefaultSheetView();
        return view != null && view.getTabSelected();
    }

    @Override
    public void setSelected(boolean value) {
        CTSheetViews views = this.getSheetTypeSheetViews();
        for (CTSheetView view : views.getSheetViewArray()) {
            view.setTabSelected(value);
        }
    }

    @Deprecated
    public static void setCellComment(String cellRef, XSSFComment comment) {
        CellReference cellReference = new CellReference(cellRef);
        comment.setRow(cellReference.getRow());
        comment.setColumn(cellReference.getCol());
    }

    @Internal
    public void addHyperlink(XSSFHyperlink hyperlink) {
        this.hyperlinks.add(hyperlink);
    }

    @Internal
    public void removeHyperlink(int row, int column) {
        String ref = new CellReference(row, column).formatAsString();
        Iterator<XSSFHyperlink> it = this.hyperlinks.iterator();
        while (it.hasNext()) {
            XSSFHyperlink hyperlink = it.next();
            if (!hyperlink.getCellRef().equals(ref)) continue;
            it.remove();
            return;
        }
    }

    public String getActiveCell() {
        return this.getSheetTypeSelection().getActiveCell();
    }

    public void setActiveCell(String cellRef) {
        CTSelection ctsel = this.getSheetTypeSelection();
        ctsel.setActiveCell(cellRef);
        ctsel.setSqref(Arrays.asList(cellRef));
    }

    public boolean hasComments() {
        return this.sheetComments != null && this.sheetComments.getNumberOfComments() > 0;
    }

    protected int getNumberOfComments() {
        return this.sheetComments == null ? 0 : this.sheetComments.getNumberOfComments();
    }

    private CTSelection getSheetTypeSelection() {
        if (this.getSheetTypeSheetView().sizeOfSelectionArray() == 0) {
            this.getSheetTypeSheetView().insertNewSelection(0);
        }
        return this.getSheetTypeSheetView().getSelectionArray(0);
    }

    private CTSheetView getDefaultSheetView() {
        int sz;
        CTSheetViews views = this.getSheetTypeSheetViews();
        int n = sz = views == null ? 0 : views.sizeOfSheetViewArray();
        if (sz == 0) {
            return null;
        }
        return views.getSheetViewArray(sz - 1);
    }

    protected CommentsTable getCommentsTable(boolean create) {
        if (this.sheetComments == null && create) {
            try {
                this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), (int)this.sheet.getSheetId());
            }
            catch (PartAlreadyExistsException e) {
                this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), -1);
            }
        }
        return this.sheetComments;
    }

    private CTPageSetUpPr getSheetTypePageSetUpPr() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        return sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
    }

    private boolean removeRow(int startRow, int endRow, int n, int rownum) {
        if (rownum >= startRow + n && rownum <= endRow + n) {
            if (n > 0 && rownum > endRow) {
                return true;
            }
            if (n < 0 && rownum < startRow) {
                return true;
            }
        }
        return false;
    }

    private CTPane getPane() {
        if (this.getDefaultSheetView().getPane() == null) {
            this.getDefaultSheetView().addNewPane();
        }
        return this.getDefaultSheetView().getPane();
    }

    @Internal
    public CTCellFormula getSharedFormula(int sid) {
        return this.sharedFormulas.get(sid);
    }

    void onReadCell(XSSFCell cell) {
        CTCell ct = cell.getCTCell();
        CTCellFormula f = ct.getF();
        if (f != null && f.getT() == STCellFormulaType.SHARED && f.isSetRef() && f.getStringValue() != null) {
            CTCellFormula sf = (CTCellFormula)f.copy();
            CellRangeAddress sfRef = CellRangeAddress.valueOf(sf.getRef());
            CellReference cellRef = new CellReference(cell);
            if (cellRef.getCol() > sfRef.getFirstColumn() || cellRef.getRow() > sfRef.getFirstRow()) {
                String effectiveRef = new CellRangeAddress(Math.max(cellRef.getRow(), sfRef.getFirstRow()), sfRef.getLastRow(), Math.max(cellRef.getCol(), sfRef.getFirstColumn()), sfRef.getLastColumn()).formatAsString();
                sf.setRef(effectiveRef);
            }
            this.sharedFormulas.put((int)f.getSi(), sf);
        }
        if (f != null && f.getT() == STCellFormulaType.ARRAY && f.getRef() != null) {
            this.arrayFormulas.add(CellRangeAddress.valueOf(f.getRef()));
        }
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.write(out);
        out.close();
    }

    protected void write(OutputStream out) throws IOException {
        boolean setToNull = false;
        if (this.worksheet.sizeOfColsArray() == 1) {
            CTCols col = this.worksheet.getColsArray(0);
            if (col.sizeOfColArray() == 0) {
                setToNull = true;
                this.worksheet.setColsArray(null);
            } else {
                this.setColWidthAttribute(col);
            }
        }
        if (this.hyperlinks.size() > 0) {
            if (this.worksheet.getHyperlinks() == null) {
                this.worksheet.addNewHyperlinks();
            }
            CTHyperlink[] ctHls = new CTHyperlink[this.hyperlinks.size()];
            for (int i = 0; i < ctHls.length; ++i) {
                XSSFHyperlink hyperlink = this.hyperlinks.get(i);
                hyperlink.generateRelationIfNeeded(this.getPackagePart());
                ctHls[i] = hyperlink.getCTHyperlink();
            }
            this.worksheet.getHyperlinks().setHyperlinkArray(ctHls);
        }
        for (XSSFRow row : this._rows.values()) {
            row.onDocumentWrite();
        }
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTWorksheet.type.getName().getNamespaceURI(), "worksheet"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        this.worksheet.save(out, xmlOptions);
        if (setToNull) {
            this.worksheet.addNewCols();
        }
    }

    public boolean isAutoFilterLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getAutoFilter();
    }

    public boolean isDeleteColumnsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getDeleteColumns();
    }

    public boolean isDeleteRowsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getDeleteRows();
    }

    public boolean isFormatCellsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getFormatCells();
    }

    public boolean isFormatColumnsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getFormatColumns();
    }

    public boolean isFormatRowsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getFormatRows();
    }

    public boolean isInsertColumnsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getInsertColumns();
    }

    public boolean isInsertHyperlinksLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getInsertHyperlinks();
    }

    public boolean isInsertRowsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getInsertRows();
    }

    public boolean isPivotTablesLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getPivotTables();
    }

    public boolean isSortLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getSort();
    }

    public boolean isObjectsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getObjects();
    }

    public boolean isScenariosLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getScenarios();
    }

    public boolean isSelectLockedCellsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getSelectLockedCells();
    }

    public boolean isSelectUnlockedCellsLocked() {
        return this.isSheetLocked() && this.safeGetProtectionField().getSelectUnlockedCells();
    }

    public boolean isSheetLocked() {
        return this.worksheet.isSetSheetProtection() && this.safeGetProtectionField().getSheet();
    }

    public void enableLocking() {
        this.safeGetProtectionField().setSheet(true);
    }

    public void disableLocking() {
        this.safeGetProtectionField().setSheet(false);
    }

    public void lockAutoFilter() {
        this.lockAutoFilter(true);
    }

    public void lockAutoFilter(boolean enabled) {
        this.safeGetProtectionField().setAutoFilter(enabled);
    }

    public void lockDeleteColumns() {
        this.lockDeleteColumns(true);
    }

    public void lockDeleteColumns(boolean enabled) {
        this.safeGetProtectionField().setDeleteColumns(enabled);
    }

    public void lockDeleteRows() {
        this.lockDeleteRows(true);
    }

    public void lockDeleteRows(boolean enabled) {
        this.safeGetProtectionField().setDeleteRows(enabled);
    }

    public void lockFormatCells() {
        this.lockFormatCells(true);
    }

    public void lockFormatCells(boolean enabled) {
        this.safeGetProtectionField().setFormatCells(enabled);
    }

    public void lockFormatColumns() {
        this.lockFormatColumns(true);
    }

    public void lockFormatColumns(boolean enabled) {
        this.safeGetProtectionField().setFormatColumns(enabled);
    }

    public void lockFormatRows() {
        this.lockFormatRows(true);
    }

    public void lockFormatRows(boolean enabled) {
        this.safeGetProtectionField().setFormatRows(enabled);
    }

    public void lockInsertColumns() {
        this.lockInsertColumns(true);
    }

    public void lockInsertColumns(boolean enabled) {
        this.safeGetProtectionField().setInsertColumns(enabled);
    }

    public void lockInsertHyperlinks() {
        this.lockInsertHyperlinks(true);
    }

    public void lockInsertHyperlinks(boolean enabled) {
        this.safeGetProtectionField().setInsertHyperlinks(enabled);
    }

    public void lockInsertRows() {
        this.lockInsertRows(true);
    }

    public void lockInsertRows(boolean enabled) {
        this.safeGetProtectionField().setInsertRows(enabled);
    }

    public void lockPivotTables() {
        this.lockPivotTables(true);
    }

    public void lockPivotTables(boolean enabled) {
        this.safeGetProtectionField().setPivotTables(enabled);
    }

    public void lockSort() {
        this.lockSort(true);
    }

    public void lockSort(boolean enabled) {
        this.safeGetProtectionField().setSort(enabled);
    }

    public void lockObjects() {
        this.lockObjects(true);
    }

    public void lockObjects(boolean enabled) {
        this.safeGetProtectionField().setObjects(enabled);
    }

    public void lockScenarios() {
        this.lockScenarios(true);
    }

    public void lockScenarios(boolean enabled) {
        this.safeGetProtectionField().setScenarios(enabled);
    }

    public void lockSelectLockedCells() {
        this.lockSelectLockedCells(true);
    }

    public void lockSelectLockedCells(boolean enabled) {
        this.safeGetProtectionField().setSelectLockedCells(enabled);
    }

    public void lockSelectUnlockedCells() {
        this.lockSelectUnlockedCells(true);
    }

    public void lockSelectUnlockedCells(boolean enabled) {
        this.safeGetProtectionField().setSelectUnlockedCells(enabled);
    }

    private CTSheetProtection safeGetProtectionField() {
        if (!this.isSheetProtectionEnabled()) {
            return this.worksheet.addNewSheetProtection();
        }
        return this.worksheet.getSheetProtection();
    }

    boolean isSheetProtectionEnabled() {
        return this.worksheet.isSetSheetProtection();
    }

    boolean isCellInArrayFormulaContext(XSSFCell cell) {
        for (CellRangeAddress range : this.arrayFormulas) {
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return true;
        }
        return false;
    }

    XSSFCell getFirstCellInArrayFormula(XSSFCell cell) {
        for (CellRangeAddress range : this.arrayFormulas) {
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return this.getRow(range.getFirstRow()).getCell(range.getFirstColumn());
        }
        return null;
    }

    private CellRange<XSSFCell> getCellRange(CellRangeAddress range) {
        int firstRow = range.getFirstRow();
        int firstColumn = range.getFirstColumn();
        int lastRow = range.getLastRow();
        int lastColumn = range.getLastColumn();
        int height = lastRow - firstRow + 1;
        int width = lastColumn - firstColumn + 1;
        ArrayList<XSSFCell> temp = new ArrayList<XSSFCell>(height * width);
        for (int rowIn = firstRow; rowIn <= lastRow; ++rowIn) {
            for (int colIn = firstColumn; colIn <= lastColumn; ++colIn) {
                XSSFCell cell;
                XSSFRow row = this.getRow(rowIn);
                if (row == null) {
                    row = this.createRow(rowIn);
                }
                if ((cell = row.getCell(colIn)) == null) {
                    cell = row.createCell(colIn);
                }
                temp.add(cell);
            }
        }
        return SSCellRange.create(firstRow, firstColumn, height, width, temp, XSSFCell.class);
    }

    public CellRange<XSSFCell> setArrayFormula(String formula, CellRangeAddress range) {
        CellRange<XSSFCell> cr = this.getCellRange(range);
        XSSFCell mainArrayFormulaCell = cr.getTopLeftCell();
        mainArrayFormulaCell.setCellArrayFormula(formula, range);
        this.arrayFormulas.add(range);
        return cr;
    }

    public CellRange<XSSFCell> removeArrayFormula(Cell cell) {
        if (cell.getSheet() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this sheet.");
        }
        for (CellRangeAddress range : this.arrayFormulas) {
            if (!range.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            this.arrayFormulas.remove(range);
            CellRange<XSSFCell> cr = this.getCellRange(range);
            for (XSSFCell c : cr) {
                c.setCellType(3);
            }
            return cr;
        }
        String ref = ((XSSFCell)cell).getCTCell().getR();
        throw new IllegalArgumentException("Cell " + ref + " is not part of an array formula.");
    }

    @Override
    public DataValidationHelper getDataValidationHelper() {
        return this.dataValidationHelper;
    }

    public List<XSSFDataValidation> getDataValidations() {
        ArrayList<XSSFDataValidation> xssfValidations = new ArrayList<XSSFDataValidation>();
        CTDataValidations dataValidations = this.worksheet.getDataValidations();
        if (dataValidations != null && dataValidations.getCount() > 0L) {
            for (CTDataValidation ctDataValidation : dataValidations.getDataValidationArray()) {
                CellRangeAddressList addressList = new CellRangeAddressList();
                List sqref = ctDataValidation.getSqref();
                for (String stRef : sqref) {
                    String[] regions;
                    for (String region : regions = stRef.split(" ")) {
                        String[] parts = region.split(":");
                        CellReference begin = new CellReference(parts[0]);
                        CellReference end = parts.length > 1 ? new CellReference(parts[1]) : begin;
                        CellRangeAddress cellRangeAddress = new CellRangeAddress(begin.getRow(), end.getRow(), begin.getCol(), end.getCol());
                        addressList.addCellRangeAddress(cellRangeAddress);
                    }
                }
                XSSFDataValidation xssfDataValidation = new XSSFDataValidation(addressList, ctDataValidation);
                xssfValidations.add(xssfDataValidation);
            }
        }
        return xssfValidations;
    }

    @Override
    public void addValidationData(DataValidation dataValidation) {
        XSSFDataValidation xssfDataValidation = (XSSFDataValidation)dataValidation;
        CTDataValidations dataValidations = this.worksheet.getDataValidations();
        if (dataValidations == null) {
            dataValidations = this.worksheet.addNewDataValidations();
        }
        int currentCount = dataValidations.sizeOfDataValidationArray();
        CTDataValidation newval = dataValidations.addNewDataValidation();
        newval.set(xssfDataValidation.getCtDdataValidation());
        dataValidations.setCount(currentCount + 1);
    }

    @Override
    public XSSFAutoFilter setAutoFilter(CellRangeAddress range) {
        CTAutoFilter af = this.worksheet.getAutoFilter();
        if (af == null) {
            af = this.worksheet.addNewAutoFilter();
        }
        CellRangeAddress norm = new CellRangeAddress(range.getFirstRow(), range.getLastRow(), range.getFirstColumn(), range.getLastColumn());
        String ref = norm.formatAsString();
        af.setRef(ref);
        XSSFWorkbook wb = this.getWorkbook();
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        XSSFName name = wb.getBuiltInName("_xlnm._FilterDatabase", sheetIndex);
        if (name == null) {
            name = wb.createBuiltInName("_xlnm._FilterDatabase", sheetIndex);
        }
        name.getCTName().setHidden(true);
        CellReference r1 = new CellReference(this.getSheetName(), range.getFirstRow(), range.getFirstColumn(), true, true);
        CellReference r2 = new CellReference(null, range.getLastRow(), range.getLastColumn(), true, true);
        String fmla = r1.formatAsString() + ":" + r2.formatAsString();
        name.setRefersToFormula(fmla);
        return new XSSFAutoFilter(this);
    }

    public XSSFTable createTable() {
        if (!this.worksheet.isSetTableParts()) {
            this.worksheet.addNewTableParts();
        }
        CTTableParts tblParts = this.worksheet.getTableParts();
        CTTablePart tbl = tblParts.addNewTablePart();
        int tableNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.TABLE.getContentType()).size() + 1;
        XSSFTable table = (XSSFTable)this.createRelationship(XSSFRelation.TABLE, XSSFFactory.getInstance(), tableNumber);
        tbl.setId(table.getPackageRelationship().getId());
        this.tables.put(tbl.getId(), table);
        return table;
    }

    public List<XSSFTable> getTables() {
        return new ArrayList<XSSFTable>(this.tables.values());
    }

    @Override
    public XSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new XSSFSheetConditionalFormatting(this);
    }

    public void setTabColor(int colorIndex) {
        CTSheetPr pr = this.worksheet.getSheetPr();
        if (pr == null) {
            pr = this.worksheet.addNewSheetPr();
        }
        CTColor color = CTColor.Factory.newInstance();
        color.setIndexed(colorIndex);
        pr.setTabColor(color);
    }

    @Override
    public CellRangeAddress getRepeatingRows() {
        return this.getRepeatingRowsOrColums(true);
    }

    @Override
    public CellRangeAddress getRepeatingColumns() {
        return this.getRepeatingRowsOrColums(false);
    }

    @Override
    public void setRepeatingRows(CellRangeAddress rowRangeRef) {
        CellRangeAddress columnRangeRef = this.getRepeatingColumns();
        this.setRepeatingRowsAndColumns(rowRangeRef, columnRangeRef);
    }

    @Override
    public void setRepeatingColumns(CellRangeAddress columnRangeRef) {
        CellRangeAddress rowRangeRef = this.getRepeatingRows();
        this.setRepeatingRowsAndColumns(rowRangeRef, columnRangeRef);
    }

    private void setRepeatingRowsAndColumns(CellRangeAddress rowDef, CellRangeAddress colDef) {
        int col1 = -1;
        int col2 = -1;
        int row1 = -1;
        int row2 = -1;
        if (rowDef != null) {
            row1 = rowDef.getFirstRow();
            row2 = rowDef.getLastRow();
            if (row1 == -1 && row2 != -1 || row1 < -1 || row2 < -1 || row1 > row2) {
                throw new IllegalArgumentException("Invalid row range specification");
            }
        }
        if (colDef != null) {
            col1 = colDef.getFirstColumn();
            col2 = colDef.getLastColumn();
            if (col1 == -1 && col2 != -1 || col1 < -1 || col2 < -1 || col1 > col2) {
                throw new IllegalArgumentException("Invalid column range specification");
            }
        }
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        boolean removeAll = rowDef == null && colDef == null;
        XSSFName name = this.getWorkbook().getBuiltInName("_xlnm.Print_Titles", sheetIndex);
        if (removeAll) {
            if (name != null) {
                this.getWorkbook().removeName(name);
            }
            return;
        }
        if (name == null) {
            name = this.getWorkbook().createBuiltInName("_xlnm.Print_Titles", sheetIndex);
        }
        String reference = XSSFSheet.getReferenceBuiltInRecord(name.getSheetName(), col1, col2, row1, row2);
        name.setRefersToFormula(reference);
        if (!this.worksheet.isSetPageSetup() || !this.worksheet.isSetPageMargins()) {
            this.getPrintSetup().setValidSettings(false);
        }
    }

    private static String getReferenceBuiltInRecord(String sheetName, int startC, int endC, int startR, int endR) {
        CellReference colRef = new CellReference(sheetName, 0, startC, true, true);
        CellReference colRef2 = new CellReference(sheetName, 0, endC, true, true);
        CellReference rowRef = new CellReference(sheetName, startR, 0, true, true);
        CellReference rowRef2 = new CellReference(sheetName, endR, 0, true, true);
        String escapedName = SheetNameFormatter.format(sheetName);
        String c = "";
        String r = "";
        if (startC != -1 || endC != -1) {
            c = escapedName + "!$" + colRef.getCellRefParts()[2] + ":$" + colRef2.getCellRefParts()[2];
        }
        if (!(startR == -1 && endR == -1 || rowRef.getCellRefParts()[1].equals("0") || rowRef2.getCellRefParts()[1].equals("0"))) {
            r = escapedName + "!$" + rowRef.getCellRefParts()[1] + ":$" + rowRef2.getCellRefParts()[1];
        }
        StringBuilder rng = new StringBuilder();
        rng.append(c);
        if (rng.length() > 0 && r.length() > 0) {
            rng.append(',');
        }
        rng.append(r);
        return rng.toString();
    }

    private CellRangeAddress getRepeatingRowsOrColums(boolean rows) {
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        XSSFName name = this.getWorkbook().getBuiltInName("_xlnm.Print_Titles", sheetIndex);
        if (name == null) {
            return null;
        }
        String refStr = name.getRefersToFormula();
        if (refStr == null) {
            return null;
        }
        String[] parts = refStr.split(",");
        int maxRowIndex = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        int maxColIndex = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        for (String part : parts) {
            CellRangeAddress range = CellRangeAddress.valueOf(part);
            if (!(range.getFirstColumn() == 0 && range.getLastColumn() == maxColIndex || range.getFirstColumn() == -1 && range.getLastColumn() == -1 ? rows : (range.getFirstRow() == 0 && range.getLastRow() == maxRowIndex || range.getFirstRow() == -1 && range.getLastRow() == -1) && !rows)) continue;
            return range;
        }
        return null;
    }

    private XSSFPivotTable createPivotTable() {
        XSSFWorkbook wb = this.getWorkbook();
        List<XSSFPivotTable> pivotTables = wb.getPivotTables();
        int tableId = this.getWorkbook().getPivotTables().size() + 1;
        XSSFPivotTable pivotTable = (XSSFPivotTable)this.createRelationship(XSSFRelation.PIVOT_TABLE, XSSFFactory.getInstance(), tableId);
        pivotTable.setParentSheet(this);
        pivotTables.add(pivotTable);
        XSSFWorkbook workbook = this.getWorkbook();
        XSSFPivotCacheDefinition pivotCacheDefinition = (XSSFPivotCacheDefinition)workbook.createRelationship(XSSFRelation.PIVOT_CACHE_DEFINITION, XSSFFactory.getInstance(), tableId);
        String rId = workbook.getRelationId(pivotCacheDefinition);
        PackagePart pivotPackagePart = pivotTable.getPackagePart();
        pivotPackagePart.addRelationship(pivotCacheDefinition.getPackagePart().getPartName(), TargetMode.INTERNAL, XSSFRelation.PIVOT_CACHE_DEFINITION.getRelation());
        pivotTable.setPivotCacheDefinition(pivotCacheDefinition);
        pivotTable.setPivotCache(new XSSFPivotCache(workbook.addPivotCache(rId)));
        XSSFPivotCacheRecords pivotCacheRecords = (XSSFPivotCacheRecords)pivotCacheDefinition.createRelationship(XSSFRelation.PIVOT_CACHE_RECORDS, XSSFFactory.getInstance(), tableId);
        pivotTable.getPivotCacheDefinition().getCTPivotCacheDefinition().setId(pivotCacheDefinition.getRelationId(pivotCacheRecords));
        wb.setPivotTables(pivotTables);
        return pivotTable;
    }

    public XSSFPivotTable createPivotTable(AreaReference source, CellReference position, Sheet sourceSheet) {
        if (source.getFirstCell().getSheetName() != null && !source.getFirstCell().getSheetName().equals(sourceSheet.getSheetName())) {
            throw new IllegalArgumentException("The area is referenced in another sheet than the defined source sheet " + sourceSheet.getSheetName() + ".");
        }
        XSSFPivotTable pivotTable = this.createPivotTable();
        pivotTable.setDefaultPivotTableDefinition();
        pivotTable.createSourceReferences(source, position, sourceSheet);
        pivotTable.getPivotCacheDefinition().createCacheFields(sourceSheet);
        pivotTable.createDefaultDataColumns();
        return pivotTable;
    }

    public XSSFPivotTable createPivotTable(AreaReference source, CellReference position) {
        if (source.getFirstCell().getSheetName() != null && !source.getFirstCell().getSheetName().equals(this.getSheetName())) {
            return this.createPivotTable(source, position, this.getWorkbook().getSheet(source.getFirstCell().getSheetName()));
        }
        return this.createPivotTable(source, position, this);
    }

    public List<XSSFPivotTable> getPivotTables() {
        ArrayList<XSSFPivotTable> tables = new ArrayList<XSSFPivotTable>();
        for (XSSFPivotTable table : this.getWorkbook().getPivotTables()) {
            if (table.getParent() != this) continue;
            tables.add(table);
        }
        return tables;
    }
}

