/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.blip.Bitmap;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.ShapePainter;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.SimpleShape;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.hslf.usermodel.SlideShow;

public class Picture
extends SimpleShape {
    public static final int EMF = 2;
    public static final int WMF = 3;
    public static final int PICT = 4;
    public static final int JPEG = 5;
    public static final int PNG = 6;
    public static final byte DIB = 7;

    public Picture(int idx) {
        this(idx, null);
    }

    public Picture(int idx, Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(idx, parent instanceof ShapeGroup);
    }

    protected Picture(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public int getPictureIndex() {
        EscherOptRecord opt = (EscherOptRecord)Picture.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Picture.getEscherProperty(opt, 260);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    protected EscherContainerRecord createSpContainer(int idx, boolean isChild) {
        this._escherContainer = super.createSpContainer(isChild);
        this._escherContainer.setOptions((short)15);
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        spRecord.setOptions((short)1202);
        EscherOptRecord opt = (EscherOptRecord)Picture.getEscherChild(this._escherContainer, -4085);
        Picture.setEscherProperty(opt, (short)127, 0x800080);
        Picture.setEscherProperty(opt, (short)16644, idx);
        return this._escherContainer;
    }

    public void setDefaultSize() {
        PictureData pict = this.getPictureData();
        if (pict instanceof Bitmap) {
            BufferedImage img = null;
            try {
                img = ImageIO.read(new ByteArrayInputStream(pict.getData()));
            }
            catch (IOException e) {
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                // empty catch block
            }
            if (img != null) {
                this.setAnchor(new Rectangle(0, 0, img.getWidth() * 72 / 96, img.getHeight() * 72 / 96));
            } else {
                this.setAnchor(new Rectangle(0, 0, 200, 200));
            }
        } else {
            this.setAnchor(new Rectangle(50, 50, 200, 200));
        }
    }

    public PictureData getPictureData() {
        SlideShow ppt = this.getSheet().getSlideShow();
        PictureData[] pict = ppt.getPictureData();
        EscherBSERecord bse = this.getEscherBSERecord();
        if (bse == null) {
            this.logger.log(7, "no reference to picture data found ");
        } else {
            for (int i = 0; i < pict.length; ++i) {
                if (pict[i].getOffset() != bse.getOffset()) continue;
                return pict[i];
            }
            this.logger.log(7, "no picture found for our BSE offset " + bse.getOffset());
        }
        return null;
    }

    protected EscherBSERecord getEscherBSERecord() {
        SlideShow ppt = this.getSheet().getSlideShow();
        Document doc = ppt.getDocumentRecord();
        EscherContainerRecord dggContainer = doc.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)Shape.getEscherChild(dggContainer, -4095);
        if (bstore == null) {
            this.logger.log(1, "EscherContainerRecord.BSTORE_CONTAINER was not found ");
            return null;
        }
        List<EscherRecord> lst = bstore.getChildRecords();
        int idx = this.getPictureIndex();
        if (idx == 0) {
            this.logger.log(1, "picture index was not found, returning ");
            return null;
        }
        return (EscherBSERecord)lst.get(idx - 1);
    }

    public String getPictureName() {
        EscherOptRecord opt = (EscherOptRecord)Picture.getEscherChild(this._escherContainer, -4085);
        EscherComplexProperty prop = (EscherComplexProperty)Picture.getEscherProperty(opt, 261);
        String name = null;
        if (prop != null) {
            try {
                name = new String(prop.getComplexData(), "UTF-16LE");
                int idx = name.indexOf(0);
                return idx == -1 ? name : name.substring(0, idx);
            }
            catch (UnsupportedEncodingException e) {
                throw new HSLFException(e);
            }
        }
        return name;
    }

    public void setPictureName(String name) {
        EscherOptRecord opt = (EscherOptRecord)Picture.getEscherChild(this._escherContainer, -4085);
        try {
            byte[] data = (name + '\u0000').getBytes("UTF-16LE");
            EscherComplexProperty prop = new EscherComplexProperty(261, false, data);
            opt.addEscherProperty(prop);
        }
        catch (UnsupportedEncodingException e) {
            throw new HSLFException(e);
        }
    }

    @Override
    protected void afterInsert(Sheet sh) {
        super.afterInsert(sh);
        EscherBSERecord bse = this.getEscherBSERecord();
        bse.setRef(bse.getRef() + 1);
        Rectangle anchor = this.getAnchor();
        if (anchor.equals(new Rectangle())) {
            this.setDefaultSize();
        }
    }

    @Override
    public void draw(Graphics2D graphics) {
        AffineTransform at = graphics.getTransform();
        ShapePainter.paint(this, graphics);
        PictureData data = this.getPictureData();
        if (data != null) {
            data.draw(graphics, this);
        }
        graphics.setTransform(at);
    }
}

