/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.recognition;

import edu.usc.irds.agepredictor.authorage.AgePredicterLocal;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import opennlp.tools.util.InvalidFormatException;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.recognition.AgeRecogniserConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class AgeRecogniser
implements Parser,
Initializable {
    public static final String MD_KEY_ESTIMATED_AGE_RANGE = "Estimated-Author-Age-Range";
    public static final String MD_KEY_ESTIMATED_AGE = "Estimated-Author-Age";
    private static final long serialVersionUID = 1108439049093046832L;
    private static final Logger LOG = LoggerFactory.getLogger(AgeRecogniser.class);
    private static final MediaType MEDIA_TYPE = MediaType.TEXT_PLAIN;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    private static AgePredicterLocal agePredictor;
    private static volatile boolean available;
    public Tika secondaryParser;
    private AgeRecogniserConfig config;

    public AgeRecogniser() {
        try {
            this.secondaryParser = new Tika(new TikaConfig());
            available = true;
        }
        catch (Exception e) {
            available = false;
            LOG.error("Unable to initialize secondary parser", (Throwable)e);
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
    }

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED_TYPES;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.config = new AgeRecogniserConfig(params);
    }

    public AgePredicterLocal getAgePredictorClient() throws InvalidFormatException, IOException {
        if (agePredictor == null) {
            agePredictor = new AgePredicterLocal(this.config.getPathClassifyModel(), this.config.getPathClassifyRegression());
        }
        return agePredictor;
    }

    protected static void setAgePredictorClient(AgePredicterLocal agePredicter) {
        if (agePredictor == null) {
            agePredictor = agePredicter;
        }
    }

    public void parse(InputStream inputStream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException {
        this.config = (AgeRecogniserConfig)context.get(AgeRecogniserConfig.class, (Object)this.config);
        if (!available) {
            LOG.error("Parser Unavailable, check your configuration");
            return;
        }
        Reader reader = MediaType.TEXT_PLAIN.toString().equals(metadata.get("Content-Type")) ? new InputStreamReader(inputStream, StandardCharsets.UTF_8) : this.secondaryParser.parse(inputStream);
        try {
            double predictAuthorAge = this.getAgePredictorClient().predictAge(IOUtils.toString((Reader)reader));
            metadata.add(MD_KEY_ESTIMATED_AGE, Double.toString(predictAuthorAge));
        }
        catch (Exception e) {
            LOG.error("Age Predictor is not available. Please check wiki for detailed instructions", (Throwable)e);
            return;
        }
    }

    static {
        available = false;
    }
}

