/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.maven;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

final class Thrift {
    static final String GENERATED_JAVA = "gen-java";
    private final String executable;
    private final String generator;
    private final ImmutableSet<File> thriftPathElements;
    private final ImmutableSet<File> thriftFiles;
    private final File javaOutputDirectory;
    private final CommandLineUtils.StringStreamConsumer output;
    private final CommandLineUtils.StringStreamConsumer error;

    private Thrift(String executable, String generator, ImmutableSet<File> thriftPath, ImmutableSet<File> thriftFiles, File javaOutputDirectory) {
        this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
        this.generator = (String)Preconditions.checkNotNull((Object)generator, (Object)"generator");
        this.thriftPathElements = (ImmutableSet)Preconditions.checkNotNull(thriftPath, (Object)"thriftPath");
        this.thriftFiles = (ImmutableSet)Preconditions.checkNotNull(thriftFiles, (Object)"thriftFiles");
        this.javaOutputDirectory = (File)Preconditions.checkNotNull((Object)javaOutputDirectory, (Object)"javaOutputDirectory");
        this.error = new CommandLineUtils.StringStreamConsumer();
        this.output = new CommandLineUtils.StringStreamConsumer();
    }

    public int compile() throws CommandLineException {
        for (File thriftFile : this.thriftFiles) {
            Commandline cl = new Commandline();
            cl.setExecutable(this.executable);
            cl.addArguments((String[])this.buildThriftCommand(thriftFile).toArray((Object[])new String[0]));
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)this.output, (StreamConsumer)this.error);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    ImmutableList<String> buildThriftCommand(File thriftFile) {
        LinkedList command = Lists.newLinkedList();
        for (File thriftPathElement : this.thriftPathElements) {
            command.add("-I");
            command.add(thriftPathElement.toString());
        }
        command.add("-out");
        command.add(this.javaOutputDirectory.toString());
        command.add("--gen");
        command.add(this.generator);
        command.add(thriftFile.toString());
        return ImmutableList.copyOf((Iterable)command);
    }

    public String getOutput() {
        return this.output.getOutput();
    }

    public String getError() {
        return this.error.getOutput();
    }

    static final class Builder {
        private final String executable;
        private final File javaOutputDirectory;
        private Set<File> thriftPathElements;
        private Set<File> thriftFiles;
        private String generator;

        public Builder(String executable, File javaOutputDirectory) {
            this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
            this.javaOutputDirectory = (File)Preconditions.checkNotNull((Object)javaOutputDirectory);
            Preconditions.checkArgument((boolean)javaOutputDirectory.isDirectory());
            this.thriftFiles = Sets.newHashSet();
            this.thriftPathElements = Sets.newHashSet();
        }

        public Builder addThriftFile(File thriftFile) {
            Preconditions.checkNotNull((Object)thriftFile);
            Preconditions.checkArgument((boolean)thriftFile.isFile());
            Preconditions.checkArgument((boolean)thriftFile.getName().endsWith(".thrift"));
            this.checkThriftFileIsInThriftPath(thriftFile);
            this.thriftFiles.add(thriftFile);
            return this;
        }

        public Builder setGenerator(String generator) {
            Preconditions.checkNotNull((Object)generator);
            this.generator = generator;
            return this;
        }

        private void checkThriftFileIsInThriftPath(File thriftFile) {
            assert (thriftFile.isFile());
            Preconditions.checkState((boolean)this.checkThriftFileIsInThriftPathHelper(thriftFile.getParentFile()));
        }

        private boolean checkThriftFileIsInThriftPathHelper(File directory) {
            assert (directory.isDirectory());
            if (this.thriftPathElements.contains(directory)) {
                return true;
            }
            File parentDirectory = directory.getParentFile();
            return parentDirectory == null ? false : this.checkThriftFileIsInThriftPathHelper(parentDirectory);
        }

        public Builder addThriftFiles(Iterable<File> thriftFiles) {
            for (File thriftFile : thriftFiles) {
                this.addThriftFile(thriftFile);
            }
            return this;
        }

        public Builder addThriftPathElement(File thriftPathElement) {
            Preconditions.checkNotNull((Object)thriftPathElement);
            Preconditions.checkArgument((boolean)thriftPathElement.isDirectory());
            this.thriftPathElements.add(thriftPathElement);
            return this;
        }

        public Builder addThriftPathElements(Iterable<File> thriftPathElements) {
            for (File thriftPathElement : thriftPathElements) {
                this.addThriftPathElement(thriftPathElement);
            }
            return this;
        }

        public Thrift build() {
            Preconditions.checkState((!this.thriftFiles.isEmpty() ? 1 : 0) != 0);
            return new Thrift(this.executable, this.generator, ImmutableSet.copyOf(this.thriftPathElements), ImmutableSet.copyOf(this.thriftFiles), this.javaOutputDirectory);
        }
    }
}

