/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.examples.TezExampleBase;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.input.ConcatenatedMergedKeyValuesInput;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleCommitsExample
extends TezExampleBase {
    private static final Logger LOG = LoggerFactory.getLogger(MultipleCommitsExample.class);
    private static final String UV12OutputNamePrefix = "uv12Output";
    private static final String V1OutputNamePrefix = "v1Output";
    private static final String V2OutputNamePrefix = "v2Output";
    private static final String V3OutputNamePrefix = "v3Output";
    public static final String CommitOnVertexSuccessOption = "commitOnVertexSuccess";

    protected void printUsage() {
        System.err.println("Usage:  multiplecommitsExample v1OutputPrefix v1OutputNum v2OutputPrefix v2OutputNum uv12OutputPrefix uv12OutputNum v3OutputPrefix v3OutputNum [commitOnVertexSuccess](default false)");
    }

    protected int validateArgs(String[] otherArgs) {
        if (otherArgs.length != 8 && otherArgs.length != 9) {
            return 2;
        }
        if (otherArgs.length == 9 && !otherArgs[8].equals(CommitOnVertexSuccessOption)) {
            return 2;
        }
        return 0;
    }

    protected int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        boolean commitOnVertexSuccess = args.length == 5 && args[4].equals(CommitOnVertexSuccessOption);
        DAG dag = this.createDAG(tezConf, args[0], Integer.parseInt(args[1]), args[2], Integer.parseInt(args[3]), args[4], Integer.parseInt(args[5]), args[6], Integer.parseInt(args[7]), commitOnVertexSuccess);
        LOG.info("Running MultipleCommitsExample");
        return this.runDag(dag, false, LOG);
    }

    private DAG createDAG(TezConfiguration tezConf, String v1OutputPathPrefix, int v1OutputNum, String v2OutputPathPrefix, int v2OutputNum, String uv12OutputPathPrefix, int uv12OutputNum, String v3OutputPathPrefix, int v3OutputNum, boolean commitOnVertexSuccess) throws IOException {
        DataSinkDescriptor sink;
        int i;
        DAG dag = DAG.create((String)"multipleCommitsDAG");
        dag.setConf("tez.am.commit-all-outputs-on-dag-success", !commitOnVertexSuccess + "");
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)MultipleOutputProcessor.class.getName()).setUserPayload(new MultipleOutputProcessor.MultipleOutputProcessorConfig(V1OutputNamePrefix, v1OutputNum, UV12OutputNamePrefix, uv12OutputNum).toUserPayload())), (int)2);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)MultipleOutputProcessor.class.getName()).setUserPayload(new MultipleOutputProcessor.MultipleOutputProcessorConfig(V2OutputNamePrefix, v2OutputNum, UV12OutputNamePrefix, uv12OutputNum).toUserPayload())), (int)2);
        for (i = 0; i < v1OutputNum; ++i) {
            sink = MROutput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextOutputFormat.class, (String)(v1OutputPathPrefix + "_" + i)).build();
            v1.addDataSink("v1Output_" + i, sink);
        }
        for (i = 0; i < v2OutputNum; ++i) {
            sink = MROutput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextOutputFormat.class, (String)(v2OutputPathPrefix + "_" + i)).build();
            v2.addDataSink("v2Output_" + i, sink);
        }
        VertexGroup uv12 = dag.createVertexGroup("uv12", new Vertex[]{v1, v2});
        for (int i2 = 0; i2 < uv12OutputNum; ++i2) {
            DataSinkDescriptor sink2 = MROutput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextOutputFormat.class, (String)(uv12OutputPathPrefix + "_" + i2)).build();
            uv12.addDataSink("uv12Output_" + i2, sink2);
        }
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)MultipleOutputProcessor.class.getName()).setUserPayload(new MultipleOutputProcessor.MultipleOutputProcessorConfig(V3OutputNamePrefix, v3OutputNum).toUserPayload())), (int)2);
        for (int i3 = 0; i3 < v3OutputNum; ++i3) {
            DataSinkDescriptor sink3 = MROutput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextOutputFormat.class, (String)(v3OutputPathPrefix + "_" + i3)).build();
            v3.addDataSink("v3Output_" + i3, sink3);
        }
        OrderedPartitionedKVEdgeConfig edgeConfig = OrderedPartitionedKVEdgeConfig.newBuilder((String)NullWritable.class.getName(), (String)Text.class.getName(), (String)HashPartitioner.class.getName()).setFromConfiguration((Configuration)tezConf).build();
        GroupInputEdge edge = GroupInputEdge.create((VertexGroup)uv12, (Vertex)v3, (EdgeProperty)edgeConfig.createDefaultEdgeProperty(), (InputDescriptor)InputDescriptor.create((String)ConcatenatedMergedKeyValuesInput.class.getName()));
        dag.addVertex(v1).addVertex(v2).addVertex(v3).addEdge(edge);
        return dag;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new MultipleCommitsExample(), (String[])args);
        System.exit(res);
    }

    public static class MultipleOutputProcessor
    extends SimpleMRProcessor {
        MultipleOutputProcessorConfig config;

        public MultipleOutputProcessor(ProcessorContext context) {
            super(context);
        }

        public void initialize() throws Exception {
            super.initialize();
            this.config = MultipleOutputProcessorConfig.fromUserPayload(this.getContext().getUserPayload());
        }

        public void run() throws Exception {
            KeyValueWriter writer;
            int i;
            for (i = 0; i < this.config.outputNum; ++i) {
                writer = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(this.config.outputNamePrefix + "_" + i)).getWriter();
                writer.write((Object)NullWritable.get(), (Object)new Text("dummy"));
            }
            for (i = 0; i < this.config.sharedOutputNum; ++i) {
                writer = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(this.config.sharedOutputNamePrefix + "_" + i)).getWriter();
                writer.write((Object)NullWritable.get(), (Object)new Text("dummy"));
            }
        }

        public static class MultipleOutputProcessorConfig
        implements Writable {
            String outputNamePrefix;
            int outputNum;
            String sharedOutputNamePrefix = null;
            int sharedOutputNum;

            public MultipleOutputProcessorConfig() {
            }

            public MultipleOutputProcessorConfig(String outputNamePrefix, int outputNum) {
                this.outputNamePrefix = outputNamePrefix;
                this.outputNum = outputNum;
            }

            public MultipleOutputProcessorConfig(String outputNamePrefix, int outputNum, String sharedOutputNamePrefix, int sharedOutputNum) {
                this.outputNamePrefix = outputNamePrefix;
                this.outputNum = outputNum;
                this.sharedOutputNamePrefix = sharedOutputNamePrefix;
                this.sharedOutputNum = sharedOutputNum;
            }

            public void write(DataOutput out) throws IOException {
                new Text(this.outputNamePrefix).write(out);
                out.writeInt(this.outputNum);
                if (this.sharedOutputNamePrefix != null) {
                    new BooleanWritable(true).write(out);
                    new Text(this.sharedOutputNamePrefix).write(out);
                    out.writeInt(this.sharedOutputNum);
                } else {
                    new BooleanWritable(false).write(out);
                }
            }

            public void readFields(DataInput in) throws IOException {
                Text outputNameText = new Text();
                outputNameText.readFields(in);
                this.outputNamePrefix = outputNameText.toString();
                this.outputNum = in.readInt();
                BooleanWritable hasSharedOutputs = new BooleanWritable();
                hasSharedOutputs.readFields(in);
                if (hasSharedOutputs.get()) {
                    Text sharedOutputNamePrefixText = new Text();
                    sharedOutputNamePrefixText.readFields(in);
                    this.sharedOutputNamePrefix = sharedOutputNamePrefixText.toString();
                    this.sharedOutputNum = in.readInt();
                }
            }

            public UserPayload toUserPayload() throws IOException {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.write(new DataOutputStream(out));
                return UserPayload.create((ByteBuffer)ByteBuffer.wrap(out.toByteArray()));
            }

            public static MultipleOutputProcessorConfig fromUserPayload(UserPayload payload) throws IOException {
                MultipleOutputProcessorConfig config = new MultipleOutputProcessorConfig();
                config.readFields(new DataInputStream(new ByteArrayInputStream(payload.deepCopyAsArray())));
                return config;
            }
        }
    }
}

