/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.conf.HadoopKeyValuesBasedBaseEdgeConfig;
import org.apache.tez.runtime.library.conf.OrderedGroupedKVInputConfig;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVOutputConfig;
import org.apache.tez.runtime.library.conf.Utils;
import org.apache.tez.runtime.library.output.OrderedPartitionedKVOutput;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedPartitionedKVEdgeConfig
extends HadoopKeyValuesBasedBaseEdgeConfig {
    private final OrderedPartitionedKVOutputConfig outputConf;
    private final OrderedGroupedKVInputConfig inputConf;

    private OrderedPartitionedKVEdgeConfig(OrderedPartitionedKVOutputConfig outputConfiguration, OrderedGroupedKVInputConfig inputConfiguration) {
        this.outputConf = outputConfiguration;
        this.inputConf = inputConfiguration;
    }

    public static Builder newBuilder(String keyClassName, String valueClassName, String partitionerClassName, @Nullable Map<String, String> partitionerConf) {
        return new Builder(keyClassName, valueClassName, partitionerClassName, partitionerConf);
    }

    public static Builder newBuilder(String keyClassName, String valueClassName, String partitionerClassName) {
        return OrderedPartitionedKVEdgeConfig.newBuilder(keyClassName, valueClassName, partitionerClassName, null);
    }

    @Override
    public UserPayload getOutputPayload() {
        return this.outputConf.toUserPayload();
    }

    @Override
    public String getOutputClassName() {
        return OrderedPartitionedKVOutput.class.getName();
    }

    @Override
    public UserPayload getInputPayload() {
        return this.inputConf.toUserPayload();
    }

    @Override
    public String getOutputHistoryText() {
        return this.outputConf.toHistoryText();
    }

    @Override
    public String getInputHistoryText() {
        return this.inputConf.toHistoryText();
    }

    @Override
    public String getInputClassName() {
        return this.inputConf.getInputClassName();
    }

    public EdgeProperty createDefaultEdgeProperty() {
        EdgeProperty edgeProperty = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)this.getOutputClassName()).setUserPayload(this.getOutputPayload())), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.getInputClassName()).setUserPayload(this.getInputPayload())));
        Utils.setEdgePropertyHistoryText(this, edgeProperty);
        return edgeProperty;
    }

    public EdgeProperty createDefaultCustomEdgeProperty(EdgeManagerPluginDescriptor edgeManagerDescriptor) {
        Preconditions.checkNotNull((Object)edgeManagerDescriptor, (Object)"EdgeManagerDescriptor cannot be null");
        EdgeProperty edgeProperty = EdgeProperty.create((EdgeManagerPluginDescriptor)edgeManagerDescriptor, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)this.getOutputClassName()).setUserPayload(this.getOutputPayload())), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.getInputClassName()).setUserPayload(this.getInputPayload())));
        Utils.setEdgePropertyHistoryText(this, edgeProperty);
        return edgeProperty;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Builder
    extends HadoopKeyValuesBasedBaseEdgeConfig.Builder<Builder> {
        private final OrderedPartitionedKVOutputConfig.Builder outputBuilder = new OrderedPartitionedKVOutputConfig.Builder();
        private final OrderedPartitionedKVOutputConfig.SpecificBuilder<Builder> specificOutputBuilder = new OrderedPartitionedKVOutputConfig.SpecificBuilder<Builder>(this, this.outputBuilder);
        private final OrderedGroupedKVInputConfig.Builder inputBuilder = new OrderedGroupedKVInputConfig.Builder();
        private final OrderedGroupedKVInputConfig.SpecificBuilder<Builder> specificInputBuilder = new OrderedGroupedKVInputConfig.SpecificBuilder<Builder>(this, this.inputBuilder);

        @InterfaceAudience.Private
        Builder(String keyClassName, String valueClassName, String partitionerClassName, Map<String, String> partitionerConf) {
            this.outputBuilder.setKeyClassName(keyClassName);
            this.outputBuilder.setValueClassName(valueClassName);
            this.outputBuilder.setPartitioner(partitionerClassName, partitionerConf);
            this.inputBuilder.setKeyClassName(keyClassName);
            this.inputBuilder.setValueClassName(valueClassName);
        }

        public Builder setKeyComparatorClass(String comparatorClassName) {
            return this.setKeyComparatorClass(comparatorClassName, null);
        }

        public Builder setKeyComparatorClass(String comparatorClassName, @Nullable Map<String, String> comparatorConf) {
            this.outputBuilder.setKeyComparatorClass(comparatorClassName, comparatorConf);
            this.inputBuilder.setKeyComparatorClass(comparatorClassName, comparatorConf);
            return this;
        }

        public Builder setKeySerializationClass(String serializationClassName, String comparatorClassName, @Nullable Map<String, String> serializerConf) {
            this.outputBuilder.setKeySerializationClass(serializationClassName, comparatorClassName, serializerConf);
            this.inputBuilder.setKeySerializationClass(serializationClassName, comparatorClassName, serializerConf);
            return this;
        }

        public Builder setValueSerializationClass(String serializationClassName, @Nullable Map<String, String> serializerConf) {
            this.outputBuilder.setValueSerializationClass(serializationClassName, serializerConf);
            this.inputBuilder.setValueSerializationClass(serializationClassName, serializerConf);
            return this;
        }

        @Override
        public Builder setCompression(boolean enabled, @Nullable String compressionCodec, @Nullable Map<String, String> codecConf) {
            this.outputBuilder.setCompression(enabled, compressionCodec, codecConf);
            this.inputBuilder.setCompression(enabled, compressionCodec, codecConf);
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(String key, String value) {
            this.outputBuilder.setAdditionalConfiguration(key, value);
            this.inputBuilder.setAdditionalConfiguration(key, value);
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(Map<String, String> confMap) {
            this.outputBuilder.setAdditionalConfiguration((Map)confMap);
            this.inputBuilder.setAdditionalConfiguration((Map)confMap);
            return this;
        }

        @Override
        public Builder setFromConfiguration(Configuration conf) {
            this.outputBuilder.setFromConfiguration(conf);
            this.inputBuilder.setFromConfiguration(conf);
            return this;
        }

        @Override
        public Builder setFromConfigurationUnfiltered(Configuration conf) {
            this.outputBuilder.setFromConfigurationUnfiltered(conf);
            this.inputBuilder.setFromConfigurationUnfiltered(conf);
            return this;
        }

        public OrderedPartitionedKVOutputConfig.SpecificBuilder<Builder> configureOutput() {
            return this.specificOutputBuilder;
        }

        public OrderedGroupedKVInputConfig.SpecificBuilder<Builder> configureInput() {
            return this.specificInputBuilder;
        }

        public OrderedPartitionedKVEdgeConfig build() {
            return new OrderedPartitionedKVEdgeConfig(this.outputBuilder.build(), this.inputBuilder.build());
        }
    }
}

