/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;

@InterfaceAudience.Private
class MapHost {
    private State state = State.IDLE;
    private final String host;
    private final int port;
    private final int partition;
    private List<InputAttemptIdentifier> maps = new ArrayList<InputAttemptIdentifier>();

    public MapHost(String host, int port, int partition) {
        this.host = host;
        this.port = port;
        this.partition = partition;
    }

    public int getPartitionId() {
        return this.partition;
    }

    public State getState() {
        return this.state;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostIdentifier() {
        return this.host + ":" + this.port;
    }

    public synchronized void addKnownMap(InputAttemptIdentifier srcAttempt) {
        this.maps.add(srcAttempt);
        if (this.state == State.IDLE) {
            this.state = State.PENDING;
        }
    }

    public synchronized List<InputAttemptIdentifier> getAndClearKnownMaps() {
        List<InputAttemptIdentifier> currentKnownMaps = this.maps;
        this.maps = new ArrayList<InputAttemptIdentifier>();
        return currentKnownMaps;
    }

    public synchronized void markBusy() {
        this.state = State.BUSY;
    }

    public synchronized void markPenalized() {
        this.state = State.PENALIZED;
    }

    public synchronized int getNumKnownMapOutputs() {
        return this.maps.size();
    }

    public synchronized State markAvailable() {
        this.state = this.maps.isEmpty() ? State.IDLE : State.PENDING;
        return this.state;
    }

    public String toString() {
        return this.getHostIdentifier();
    }

    public synchronized void penalize() {
        this.state = State.PENALIZED;
    }

    public static class HostPortPartition {
        final String host;
        final int port;
        final int partition;

        HostPortPartition(String host, int port, int partition) {
            this.host = host;
            this.port = port;
            this.partition = partition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.partition;
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostPortPartition other = (HostPortPartition)obj;
            if (this.partition != other.partition) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return this.port == other.port;
        }

        public String toString() {
            return "HostPortPartition [host=" + this.host + ", port=" + this.port + ", partition=" + this.partition + "]";
        }
    }

    public static class HostPort {
        final String host;
        final int port;

        HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostPort other = (HostPort)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return this.port == other.port;
        }

        public String toString() {
            return "HostPort [host=" + this.host + ", port=" + this.port + "]";
        }
    }

    public static enum State {
        IDLE,
        BUSY,
        PENDING,
        PENALIZED;

    }
}

