/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.MergedInputContext;
import org.apache.tez.runtime.api.MergedLogicalInput;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValuesReader;

@InterfaceAudience.Public
public class ConcatenatedMergedKeyValuesInput
extends MergedLogicalInput {
    public ConcatenatedMergedKeyValuesInput(MergedInputContext context, List<Input> inputs) {
        super(context, inputs);
    }

    public KeyValuesReader getReader() throws Exception {
        return new ConcatenatedMergedKeyValuesReader();
    }

    public void setConstituentInputIsReady(Input input) {
        this.informInputReady();
    }

    public class ConcatenatedMergedKeyValuesReader
    extends KeyValuesReader {
        private int currentReaderIndex = 0;
        private KeyValuesReader currentReader;

        @Override
        public boolean next() throws IOException {
            while (this.currentReader == null || !this.currentReader.next()) {
                if (this.currentReaderIndex == ConcatenatedMergedKeyValuesInput.this.getInputs().size()) {
                    this.hasCompletedProcessing();
                    this.completedProcessing = true;
                    return false;
                }
                try {
                    Reader reader = ((Input)ConcatenatedMergedKeyValuesInput.this.getInputs().get(this.currentReaderIndex)).getReader();
                    if (!(reader instanceof KeyValuesReader)) {
                        throw new TezUncheckedException("Expected KeyValuesReader. Got: " + reader.getClass().getName());
                    }
                    this.currentReader = (KeyValuesReader)reader;
                    ++this.currentReaderIndex;
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(e);
                }
            }
            return true;
        }

        @Override
        public Object getCurrentKey() throws IOException {
            return this.currentReader.getCurrentKey();
        }

        @Override
        public Iterable<Object> getCurrentValues() throws IOException {
            return this.currentReader.getCurrentValues();
        }
    }
}

