/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.task.local.output;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TezLocalTaskOutputFiles
extends TezTaskOutput {
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.runtime.framework.local.dirs");

    public TezLocalTaskOutputFiles(Configuration conf, String uniqueId) {
        super(conf, uniqueId);
    }

    @Override
    public Path getOutputFile() throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/file.out", this.conf);
    }

    @Override
    public Path getOutputFileForWrite(long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/file.out", size, this.conf);
    }

    @Override
    public Path getOutputFileForWrite() throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/file.out", this.conf);
    }

    @Override
    public Path getOutputFileForWriteInVolume(Path existing) {
        return new Path(existing.getParent(), "file.out");
    }

    @Override
    public Path getOutputIndexFile() throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/file.out.index", this.conf);
    }

    @Override
    public Path getOutputIndexFileForWrite(long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/file.out.index", size, this.conf);
    }

    @Override
    public Path getOutputIndexFileForWriteInVolume(Path existing) {
        return new Path(existing.getParent(), "file.out.index");
    }

    @Override
    public Path getSpillFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/spill" + spillNumber + ".out", this.conf);
    }

    @Override
    public Path getSpillFileForWrite(int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/spill" + spillNumber + ".out", size, this.conf);
    }

    @Override
    public Path getSpillIndexFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/spill" + spillNumber + ".out.index", this.conf);
    }

    @Override
    public Path getSpillIndexFileForWrite(int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/spill" + spillNumber + ".out.index", size, this.conf);
    }

    @Override
    public Path getInputFile(InputAttemptIdentifier mapId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(String.format("%s/task_%d.out", "output", mapId.getInputIdentifier().getInputIndex()), this.conf);
    }

    @Override
    public Path getInputFileForWrite(int taskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(this.getSpillFileName(taskId), size, this.conf);
    }

    @Override
    public String getSpillFileName(int spillNum) {
        return String.format("%s/task_%d.out", "output", spillNum);
    }

    @Override
    public void removeAll() throws IOException {
        this.deleteLocalFiles("output");
    }

    private String[] getLocalDirs() throws IOException {
        return this.conf.getStrings("tez.runtime.framework.local.dirs");
    }

    private void deleteLocalFiles(String subdir) throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal((Configuration)this.conf).delete(new Path(localDirs[i], subdir));
        }
    }
}

