/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.shuffle.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.shuffle.common.FetchedInput;
import org.apache.tez.runtime.library.shuffle.common.FetchedInputCallback;

public class LocalDiskFetchedInput
extends FetchedInput {
    private static final Log LOG = LogFactory.getLog(LocalDiskFetchedInput.class);
    private final Path inputFile;
    private final FileSystem localFS;
    private final long startOffset;

    public LocalDiskFetchedInput(long startOffset, long actualSize, long compressedSize, InputAttemptIdentifier inputAttemptIdentifier, Path inputFile, Configuration conf, FetchedInputCallback callbackHandler) throws IOException {
        super(FetchedInput.Type.DISK_DIRECT, actualSize, compressedSize, inputAttemptIdentifier, callbackHandler);
        this.startOffset = startOffset;
        this.inputFile = inputFile;
        this.localFS = FileSystem.getLocal((Configuration)conf);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Output Stream is not supported for " + this.toString());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        FSDataInputStream inputStream = this.localFS.open(this.inputFile);
        inputStream.seek(this.startOffset);
        return new BoundedInputStream((InputStream)inputStream, this.compressedSize);
    }

    @Override
    public void commit() {
        if (this.state == FetchedInput.State.PENDING) {
            this.state = FetchedInput.State.COMMITTED;
            this.notifyFetchComplete();
        }
    }

    @Override
    public void abort() {
        if (this.state == FetchedInput.State.PENDING) {
            this.state = FetchedInput.State.ABORTED;
            this.notifyFetchFailure();
        }
    }

    @Override
    public void free() {
        Preconditions.checkState((this.state == FetchedInput.State.COMMITTED || this.state == FetchedInput.State.ABORTED ? 1 : 0) != 0, (Object)"FetchedInput can only be freed after it is committed or aborted");
        if (this.state == FetchedInput.State.COMMITTED) {
            this.state = FetchedInput.State.FREED;
            this.notifyFreedResource();
        }
    }

    public String toString() {
        return "LocalDiskFetchedInput [inputFile path =" + this.inputFile + ", offset" + this.startOffset + ", actualSize=" + this.actualSize + ", compressedSize=" + this.compressedSize + ", inputAttemptIdentifier=" + this.inputAttemptIdentifier + ", type=" + (Object)((Object)this.type) + ", id=" + this.id + ", state=" + (Object)((Object)this.state) + "]";
    }

    @VisibleForTesting
    protected Path getInputFile() {
        return this.inputFile;
    }

    @VisibleForTesting
    protected long getStartOffset() {
        return this.startOffset;
    }

    @VisibleForTesting
    protected FileSystem getLocalFS() {
        return this.localFS;
    }
}

