/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.sort.impl.ExternalSorter;
import org.apache.tez.runtime.library.common.sort.impl.PipelinedSorter;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.common.sort.impl.dflt.DefaultSorter;
import org.apache.tez.runtime.library.shuffle.common.ShuffleUtils;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;

@InterfaceAudience.Public
public class OrderedPartitionedKVOutput
extends AbstractLogicalOutput {
    private static final Log LOG = LogFactory.getLog(OrderedPartitionedKVOutput.class);
    protected ExternalSorter sorter;
    protected Configuration conf;
    protected MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private long startTime;
    private long endTime;
    private boolean sendEmptyPartitionDetails;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private static final Set<String> confKeys = new HashSet<String>();

    public OrderedPartitionedKVOutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    public synchronized List<Event> initialize() throws IOException {
        this.startTime = System.nanoTime();
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        this.getContext().requestInitialMemory(ExternalSorter.getInitialMemoryRequirement(this.conf, this.getContext().getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        this.sendEmptyPartitionDetails = this.conf.getBoolean("tez.runtime.empty.partitions.info-via-events.enabled", true);
        return Collections.emptyList();
    }

    public synchronized void start() throws Exception {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            this.sorter = this.conf.getInt("tez.runtime.sort.threads", 1) > 1 ? new PipelinedSorter(this.getContext(), this.conf, this.getNumPhysicalOutputs(), this.memoryUpdateCallbackHandler.getMemoryAssigned()) : new DefaultSorter(this.getContext(), this.conf, this.getNumPhysicalOutputs(), this.memoryUpdateCallbackHandler.getMemoryAssigned());
            this.isStarted.set(true);
        }
    }

    public synchronized KeyValuesWriter getWriter() throws IOException {
        Preconditions.checkState((boolean)this.isStarted.get(), (Object)"Cannot get writer before starting the Output");
        return new KeyValuesWriter(){

            @Override
            public void write(Object key, Object value) throws IOException {
                OrderedPartitionedKVOutput.this.sorter.write(key, value);
            }

            @Override
            public void write(Object key, Iterable<Object> values) throws IOException {
                OrderedPartitionedKVOutput.this.sorter.write(key, values);
            }
        };
    }

    public synchronized void handleEvents(List<Event> outputEvents) {
    }

    public synchronized List<Event> close() throws IOException {
        if (this.sorter != null) {
            this.sorter.flush();
            this.sorter.close();
            this.endTime = System.nanoTime();
            return this.generateEventsOnClose();
        }
        LOG.warn((Object)("Attempting to close output " + this.getContext().getDestinationVertexName() + " before it was started"));
        return Collections.emptyList();
    }

    protected List<Event> generateEventsOnClose() throws IOException {
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        boolean outputGenerated = true;
        if (this.sendEmptyPartitionDetails) {
            Path indexFile = this.sorter.getMapOutput().getOutputIndexFile();
            TezSpillRecord spillRecord = new TezSpillRecord(indexFile, this.conf);
            BitSet emptyPartitionDetails = new BitSet();
            int emptyPartitions = 0;
            for (int i = 0; i < spillRecord.size(); ++i) {
                TezIndexRecord indexRecord = spillRecord.getIndex(i);
                if (indexRecord.hasData()) continue;
                emptyPartitionDetails.set(i);
                ++emptyPartitions;
            }
            boolean bl = outputGenerated = spillRecord.size() != emptyPartitions;
            if (emptyPartitions > 0) {
                ByteString emptyPartitionsBytesString = TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)emptyPartitionDetails));
                payloadBuilder.setEmptyPartitions(emptyPartitionsBytesString);
                LOG.info((Object)("EmptyPartition bitsetSize=" + emptyPartitionDetails.cardinality() + ", numOutputs=" + this.getNumPhysicalOutputs() + ", emptyPartitions=" + emptyPartitions + ", compressedSize=" + emptyPartitionsBytesString.size()));
            }
        }
        if (!this.sendEmptyPartitionDetails || outputGenerated) {
            String host = System.getenv(ApplicationConstants.Environment.NM_HOST.toString());
            ByteBuffer shuffleMetadata = this.getContext().getServiceProviderMetaData(ShuffleUtils.SHUFFLE_HANDLER_SERVICE_ID);
            int shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetadata);
            payloadBuilder.setHost(host);
            payloadBuilder.setPort(shufflePort);
            payloadBuilder.setPathComponent(this.getContext().getUniqueIdentifier());
        }
        payloadBuilder.setRunDuration((int)((this.endTime - this.startTime) / 1000L));
        ShuffleUserPayloads.DataMovementEventPayloadProto payloadProto = payloadBuilder.build();
        ByteBuffer payload = payloadProto.toByteString().asReadOnlyByteBuffer();
        long outputSize = this.getContext().getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES).getValue();
        ShuffleUserPayloads.VertexManagerEventPayloadProto.Builder vmBuilder = ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder();
        vmBuilder.setOutputSize(outputSize);
        VertexManagerEvent vmEvent = VertexManagerEvent.create((String)this.getContext().getDestinationVertexName(), (ByteBuffer)vmBuilder.build().toByteString().asReadOnlyByteBuffer());
        ArrayList events = Lists.newArrayListWithCapacity((int)(this.getNumPhysicalOutputs() + 1));
        events.add(vmEvent);
        CompositeDataMovementEvent csdme = CompositeDataMovementEvent.create((int)0, (int)this.getNumPhysicalOutputs(), (ByteBuffer)payload);
        events.add(csdme);
        return events;
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(confKeys);
    }

    static {
        confKeys.add("tez.runtime.ifile.readahead");
        confKeys.add("tez.runtime.ifile.readahead.bytes");
        confKeys.add("io.file.buffer.size");
        confKeys.add("tez.runtime.io.sort.factor");
        confKeys.add("tez.runtime.sort.spill.percent");
        confKeys.add("tez.runtime.io.sort.mb");
        confKeys.add("tez.runtime.index.cache.memory.limit.bytes");
        confKeys.add("tez.runtime.combine.min.spills");
        confKeys.add("tez.runtime.sort.threads");
        confKeys.add("tez.runtime.partitioner.class");
        confKeys.add("tez.runtime.combiner.class");
        confKeys.add("tez.runtime.internal.sorter.class");
        confKeys.add("tez.runtime.key.comparator.class");
        confKeys.add("tez.runtime.key.class");
        confKeys.add("tez.runtime.value.class");
        confKeys.add("tez.runtime.compress");
        confKeys.add("tez.runtime.compress.codec");
        confKeys.add("tez.runtime.empty.partitions.info-via-events.enabled");
        confKeys.add("tez.am.counters.max.keys");
        confKeys.add("tez.am.counters.group-name.max.keys");
        confKeys.add("tez.am.counters.name.max.keys");
        confKeys.add("tez.am.counters.groups.max.keys");
    }
}

