/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;

class ShuffleClientMetrics
implements Updater {
    private MetricsRecord shuffleMetrics = null;
    private int numFailedFetches = 0;
    private int numSuccessFetches = 0;
    private long numBytes = 0L;
    private int numThreadsBusy = 0;
    private final int numCopiers;

    ShuffleClientMetrics(String dagName, String vertexName, int taskIndex, Configuration conf, String user) {
        this.numCopiers = conf.getInt("tez.runtime.shuffle.parallel.copies", 20);
        MetricsContext metricsContext = MetricsUtil.getContext((String)"tez");
        this.shuffleMetrics = MetricsUtil.createRecord((MetricsContext)metricsContext, (String)"shuffleInput");
        this.shuffleMetrics.setTag("user", user);
        this.shuffleMetrics.setTag("dagName", dagName);
        this.shuffleMetrics.setTag("taskId", TezRuntimeUtils.getTaskIdentifier(vertexName, taskIndex));
        this.shuffleMetrics.setTag("sessionId", conf.get("tez.runtime.framework.metrics.session.id", ""));
        metricsContext.registerUpdater((Updater)this);
    }

    public synchronized void inputBytes(long numBytes) {
        this.numBytes += numBytes;
    }

    public synchronized void failedFetch() {
        ++this.numFailedFetches;
    }

    public synchronized void successFetch() {
        ++this.numSuccessFetches;
    }

    public synchronized void threadBusy() {
        ++this.numThreadsBusy;
    }

    public synchronized void threadFree() {
        --this.numThreadsBusy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        ShuffleClientMetrics shuffleClientMetrics = this;
        synchronized (shuffleClientMetrics) {
            this.shuffleMetrics.incrMetric("shuffle_input_bytes", this.numBytes);
            this.shuffleMetrics.incrMetric("shuffle_failed_fetches", this.numFailedFetches);
            this.shuffleMetrics.incrMetric("shuffle_success_fetches", this.numSuccessFetches);
            if (this.numCopiers != 0) {
                this.shuffleMetrics.setMetric("shuffle_fetchers_busy_percent", 100.0f * ((float)this.numThreadsBusy / (float)this.numCopiers));
            } else {
                this.shuffleMetrics.setMetric("shuffle_fetchers_busy_percent", 0);
            }
            this.numBytes = 0L;
            this.numSuccessFetches = 0;
            this.numFailedFetches = 0;
        }
        this.shuffleMetrics.update();
    }
}

