/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.conf.HadoopKeyValuesBasedBaseEdgeConfig;
import org.apache.tez.runtime.library.conf.UnorderedKVInputConfig;
import org.apache.tez.runtime.library.conf.UnorderedPartitionedKVOutputConfig;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.library.output.UnorderedPartitionedKVOutput;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class UnorderedPartitionedKVEdgeConfig
extends HadoopKeyValuesBasedBaseEdgeConfig {
    private final UnorderedPartitionedKVOutputConfig outputConf;
    private final UnorderedKVInputConfig inputConf;

    private UnorderedPartitionedKVEdgeConfig(UnorderedPartitionedKVOutputConfig outputConfiguration, UnorderedKVInputConfig inputConfiguration) {
        this.outputConf = outputConfiguration;
        this.inputConf = inputConfiguration;
    }

    public static Builder newBuilder(String keyClassName, String valueClassName, String partitionerClassName, @Nullable Map<String, String> partitionerConf) {
        return new Builder(keyClassName, valueClassName, partitionerClassName, partitionerConf);
    }

    public static Builder newBuilder(String keyClassName, String valueClassName, String partitionerClassName) {
        return UnorderedPartitionedKVEdgeConfig.newBuilder(keyClassName, valueClassName, partitionerClassName, null);
    }

    @Override
    public UserPayload getOutputPayload() {
        return this.outputConf.toUserPayload();
    }

    @Override
    public String getOutputClassName() {
        return UnorderedPartitionedKVOutput.class.getName();
    }

    @Override
    public UserPayload getInputPayload() {
        return this.inputConf.toUserPayload();
    }

    @Override
    public String getInputClassName() {
        return UnorderedKVInput.class.getName();
    }

    public EdgeProperty createDefaultEdgeProperty() {
        EdgeProperty edgeProperty = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)this.getOutputClassName()).setUserPayload(this.getOutputPayload())), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.getInputClassName()).setUserPayload(this.getInputPayload())));
        return edgeProperty;
    }

    public EdgeProperty createDefaultCustomEdgeProperty(EdgeManagerPluginDescriptor edgeManagerDescriptor) {
        Preconditions.checkNotNull((Object)edgeManagerDescriptor, (Object)"EdgeManagerDescriptor cannot be null");
        EdgeProperty edgeProperty = EdgeProperty.create((EdgeManagerPluginDescriptor)edgeManagerDescriptor, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)this.getOutputClassName()).setUserPayload(this.getOutputPayload())), (InputDescriptor)((InputDescriptor)InputDescriptor.create((String)this.getInputClassName()).setUserPayload(this.getInputPayload())));
        return edgeProperty;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Builder
    extends HadoopKeyValuesBasedBaseEdgeConfig.Builder<Builder> {
        private final UnorderedPartitionedKVOutputConfig.Builder outputBuilder = new UnorderedPartitionedKVOutputConfig.Builder();
        private final UnorderedPartitionedKVOutputConfig.SpecificBuilder<Builder> specificOutputBuilder = new UnorderedPartitionedKVOutputConfig.SpecificBuilder<Builder>(this, this.outputBuilder);
        private final UnorderedKVInputConfig.Builder inputBuilder = new UnorderedKVInputConfig.Builder();
        private final UnorderedKVInputConfig.SpecificBuilder<Builder> specificInputBuilder = new UnorderedKVInputConfig.SpecificBuilder<Builder>(this, this.inputBuilder);

        @InterfaceAudience.Private
        Builder(String keyClassName, String valueClassName, String partitionerClassName, Map<String, String> partitionerConf) {
            this.outputBuilder.setKeyClassName(keyClassName);
            this.outputBuilder.setValueClassName(valueClassName);
            this.outputBuilder.setPartitioner(partitionerClassName, partitionerConf);
            this.inputBuilder.setKeyClassName(keyClassName);
            this.inputBuilder.setValueClassName(valueClassName);
        }

        @Override
        public Builder setCompression(boolean enabled, @Nullable String compressionCodec, @Nullable Map<String, String> codecConf) {
            this.outputBuilder.setCompression(enabled, compressionCodec, codecConf);
            this.inputBuilder.setCompression(enabled, compressionCodec, codecConf);
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(String key, String value) {
            this.outputBuilder.setAdditionalConfiguration(key, value);
            this.inputBuilder.setAdditionalConfiguration(key, value);
            return this;
        }

        @Override
        public Builder setAdditionalConfiguration(Map<String, String> confMap) {
            this.outputBuilder.setAdditionalConfiguration((Map)confMap);
            this.inputBuilder.setAdditionalConfiguration((Map)confMap);
            return this;
        }

        @Override
        public Builder setFromConfiguration(Configuration conf) {
            this.outputBuilder.setFromConfiguration(conf);
            this.inputBuilder.setFromConfiguration(conf);
            return this;
        }

        public Builder setKeySerializationClass(String serializationClassName, @Nullable Map<String, String> serializerConf) {
            this.outputBuilder.setKeySerializationClass(serializationClassName, serializerConf);
            this.inputBuilder.setKeySerializationClass(serializationClassName, serializerConf);
            return this;
        }

        public Builder setValueSerializationClass(String serializationClassName, @Nullable Map<String, String> serializerConf) {
            this.outputBuilder.setValueSerializationClass(serializationClassName, serializerConf);
            this.inputBuilder.setValueSerializationClass(serializationClassName, serializerConf);
            return this;
        }

        public UnorderedPartitionedKVOutputConfig.SpecificBuilder<Builder> configureOutput() {
            return this.specificOutputBuilder;
        }

        public UnorderedKVInputConfig.SpecificBuilder<Builder> configureInput() {
            return this.specificInputBuilder;
        }

        public UnorderedPartitionedKVEdgeConfig build() {
            return new UnorderedPartitionedKVEdgeConfig(this.outputBuilder.build(), this.inputBuilder.build());
        }
    }
}

