/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.common.sort.impl.ExternalSorter;
import org.apache.tez.runtime.library.common.sort.impl.PipelinedSorter;
import org.apache.tez.runtime.library.common.sort.impl.dflt.DefaultSorter;
import org.apache.tez.runtime.library.shuffle.common.ShuffleUtils;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;

public class OnFileSortedOutput
implements LogicalOutput {
    protected ExternalSorter sorter;
    protected Configuration conf;
    protected int numOutputs;
    protected TezOutputContext outputContext;
    private long startTime;
    private long endTime;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public List<Event> initialize(TezOutputContext outputContext) throws IOException {
        this.startTime = System.nanoTime();
        this.outputContext = outputContext;
        this.conf = TezUtils.createConfFromUserPayload((byte[])outputContext.getUserPayload());
        this.conf.setStrings("tez.runtime.local.dirs", outputContext.getWorkDirs());
        this.sorter = this.conf.getInt("tez.runtime.sort.threads", 1) > 1 ? new PipelinedSorter() : new DefaultSorter();
        this.sorter.initialize(outputContext, this.conf, this.numOutputs);
        return Collections.emptyList();
    }

    public void start() throws Exception {
        if (!this.isStarted.getAndSet(true)) {
            this.sorter.start();
        }
    }

    public KeyValueWriter getWriter() throws IOException {
        return new KeyValueWriter(){

            @Override
            public void write(Object key, Object value) throws IOException {
                OnFileSortedOutput.this.sorter.write(key, value);
            }
        };
    }

    public void handleEvents(List<Event> outputEvents) {
    }

    public void setNumPhysicalOutputs(int numOutputs) {
        this.numOutputs = numOutputs;
    }

    public List<Event> close() throws IOException {
        this.sorter.flush();
        this.sorter.close();
        this.endTime = System.nanoTime();
        return this.generateEventsOnClose();
    }

    protected List<Event> generateEventsOnClose() throws IOException {
        String host = System.getenv(ApplicationConstants.Environment.NM_HOST.toString());
        ByteBuffer shuffleMetadata = this.outputContext.getServiceProviderMetaData(ShuffleUtils.SHUFFLE_HANDLER_SERVICE_ID);
        int shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetadata);
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        payloadBuilder.setHost(host);
        payloadBuilder.setPort(shufflePort);
        payloadBuilder.setPathComponent(this.outputContext.getUniqueIdentifier());
        payloadBuilder.setRunDuration((int)((this.endTime - this.startTime) / 1000L));
        ShuffleUserPayloads.DataMovementEventPayloadProto payloadProto = payloadBuilder.build();
        byte[] payloadBytes = payloadProto.toByteArray();
        long outputSize = this.outputContext.getCounters().findCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES).getValue();
        ShuffleUserPayloads.VertexManagerEventPayloadProto.Builder vmBuilder = ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder();
        vmBuilder.setOutputSize(outputSize);
        VertexManagerEvent vmEvent = new VertexManagerEvent(this.outputContext.getDestinationVertexName(), vmBuilder.build().toByteArray());
        ArrayList events = Lists.newArrayListWithCapacity((int)(this.numOutputs + 1));
        events.add(vmEvent);
        CompositeDataMovementEvent csdme = new CompositeDataMovementEvent(0, this.numOutputs, payloadBytes);
        events.add(csdme);
        return events;
    }
}

