/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.broadcast.input.BroadcastKVReader;
import org.apache.tez.runtime.library.broadcast.input.BroadcastShuffleManager;

public class ShuffledUnorderedKVInput
implements LogicalInput {
    private static final Log LOG = LogFactory.getLog(ShuffledUnorderedKVInput.class);
    private Configuration conf;
    private int numInputs = -1;
    private BroadcastShuffleManager shuffleManager;
    private final BlockingQueue<Event> pendingEvents = new LinkedBlockingQueue<Event>();
    private volatile long firstEventReceivedTime = -1L;
    private BroadcastKVReader kvReader;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public List<Event> initialize(TezInputContext inputContext) throws Exception {
        Preconditions.checkArgument((this.numInputs != -1 ? 1 : 0) != 0, (Object)"Number of Inputs has not been set");
        this.conf = TezUtils.createConfFromUserPayload((byte[])inputContext.getUserPayload());
        this.conf.setStrings("tez.runtime.local.dirs", inputContext.getWorkDirs());
        if (this.numInputs == 0) {
            return null;
        }
        this.shuffleManager = new BroadcastShuffleManager(inputContext, this.conf, this.numInputs);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        ShuffledUnorderedKVInput shuffledUnorderedKVInput = this;
        synchronized (shuffledUnorderedKVInput) {
            if (!this.isStarted.get()) {
                this.shuffleManager.run();
                this.kvReader = this.shuffleManager.createReader();
                LinkedList<Event> pending = new LinkedList<Event>();
                this.pendingEvents.drainTo(pending);
                if (pending.size() > 0) {
                    LOG.info((Object)("NoAutoStart delay in processing first event: " + (System.currentTimeMillis() - this.firstEventReceivedTime)));
                    this.shuffleManager.handleEvents(pending);
                }
                this.isStarted.set(true);
            }
        }
    }

    public KeyValueReader getReader() throws Exception {
        if (this.numInputs == 0) {
            return new KeyValueReader(){

                @Override
                public boolean next() throws IOException {
                    return false;
                }

                @Override
                public Object getCurrentKey() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }

                @Override
                public Object getCurrentValue() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }
            };
        }
        return this.kvReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) throws IOException {
        if (this.numInputs == 0) {
            throw new RuntimeException("No input events expected as numInputs is 0");
        }
        if (!this.isStarted.get()) {
            ShuffledUnorderedKVInput shuffledUnorderedKVInput = this;
            synchronized (shuffledUnorderedKVInput) {
                if (!this.isStarted.get()) {
                    if (this.firstEventReceivedTime == -1L) {
                        this.firstEventReceivedTime = System.currentTimeMillis();
                    }
                    this.pendingEvents.addAll(inputEvents);
                    return;
                }
            }
        }
        this.shuffleManager.handleEvents(inputEvents);
    }

    public List<Event> close() throws Exception {
        if (this.numInputs != 0) {
            this.shuffleManager.shutdown();
        }
        return null;
    }

    public void setNumPhysicalInputs(int numInputs) {
        this.numInputs = numInputs;
    }
}

