/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.ValuesIterator;
import org.apache.tez.runtime.library.common.shuffle.impl.Shuffle;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;

public class ShuffledMergedInput
implements LogicalInput {
    static final Log LOG = LogFactory.getLog(ShuffledMergedInput.class);
    protected TezInputContext inputContext;
    protected TezRawKeyValueIterator rawIter = null;
    protected Configuration conf;
    protected int numInputs = 0;
    protected Shuffle shuffle;
    private final BlockingQueue<Event> pendingEvents = new LinkedBlockingQueue<Event>();
    private volatile long firstEventReceivedTime = -1L;
    protected ValuesIterator vIter;
    private TezCounter inputKeyCounter;
    private TezCounter inputValueCounter;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public List<Event> initialize(TezInputContext inputContext) throws IOException {
        this.inputContext = inputContext;
        this.conf = TezUtils.createConfFromUserPayload((byte[])inputContext.getUserPayload());
        if (this.numInputs == 0) {
            return Collections.emptyList();
        }
        this.inputKeyCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.REDUCE_INPUT_GROUPS);
        this.inputValueCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.REDUCE_INPUT_RECORDS);
        this.conf.setStrings("tez.runtime.local.dirs", inputContext.getWorkDirs());
        this.shuffle = new Shuffle(inputContext, this.conf, this.numInputs);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        ShuffledMergedInput shuffledMergedInput = this;
        synchronized (shuffledMergedInput) {
            if (!this.isStarted.get()) {
                this.shuffle.run();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Initialized the handlers in shuffle..Safe to start processing..");
                }
                LinkedList<Event> pending = new LinkedList<Event>();
                this.pendingEvents.drainTo(pending);
                if (pending.size() > 0) {
                    LOG.info((Object)("NoAutoStart delay in processing first event: " + (System.currentTimeMillis() - this.firstEventReceivedTime)));
                    this.shuffle.handleEvents(pending);
                }
                this.isStarted.set(true);
            }
        }
    }

    public boolean isInputReady() {
        if (this.numInputs == 0) {
            return true;
        }
        return this.shuffle.isInputReady();
    }

    public void waitForInputReady() throws IOException, InterruptedException {
        if (this.numInputs == 0) {
            return;
        }
        this.rawIter = this.shuffle.waitForInput();
        this.createValuesIterator();
    }

    public List<Event> close() throws IOException {
        if (this.numInputs != 0 && this.rawIter != null) {
            this.rawIter.close();
        }
        return Collections.emptyList();
    }

    public KeyValuesReader getReader() throws IOException {
        if (this.numInputs == 0) {
            return new KeyValuesReader(){

                @Override
                public boolean next() throws IOException {
                    return false;
                }

                @Override
                public Object getCurrentKey() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }

                @Override
                public Iterable<Object> getCurrentValues() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }
            };
        }
        if (this.rawIter == null) {
            try {
                this.waitForInputReady();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for input ready", e);
            }
        }
        return new KeyValuesReader(){

            @Override
            public boolean next() throws IOException {
                return ShuffledMergedInput.this.vIter.moveToNext();
            }

            @Override
            public Object getCurrentKey() throws IOException {
                return ShuffledMergedInput.this.vIter.getKey();
            }

            @Override
            public Iterable<Object> getCurrentValues() throws IOException {
                return ShuffledMergedInput.this.vIter.getValues();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) {
        if (this.numInputs == 0) {
            throw new RuntimeException("No input events expected as numInputs is 0");
        }
        if (!this.isStarted.get()) {
            ShuffledMergedInput shuffledMergedInput = this;
            synchronized (shuffledMergedInput) {
                if (!this.isStarted.get()) {
                    if (this.firstEventReceivedTime == -1L) {
                        this.firstEventReceivedTime = System.currentTimeMillis();
                    }
                    this.pendingEvents.addAll(inputEvents);
                    return;
                }
            }
        }
        this.shuffle.handleEvents(inputEvents);
    }

    public void setNumPhysicalInputs(int numInputs) {
        this.numInputs = numInputs;
    }

    protected void createValuesIterator() throws IOException {
        this.vIter = new ValuesIterator(this.rawIter, ConfigUtils.getIntermediateInputKeyComparator(this.conf), ConfigUtils.getIntermediateInputKeyClass(this.conf), ConfigUtils.getIntermediateInputValueClass(this.conf), this.conf, this.inputKeyCounter, this.inputValueCounter);
    }
}

