/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.shuffle.impl.MapHost;
import org.apache.tez.runtime.library.common.shuffle.impl.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.impl.Shuffle;

class ShuffleScheduler {
    static ThreadLocal<Long> shuffleStart = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };
    private static final Log LOG = LogFactory.getLog(ShuffleScheduler.class);
    private static final int MAX_MAPS_AT_ONCE = 20;
    private static final long INITIAL_PENALTY = 10000L;
    private static final float PENALTY_GROWTH_RATE = 1.3f;
    private boolean[] finishedMaps;
    private final int numInputs;
    private int remainingMaps;
    private Map<String, MapHost> mapLocations = new HashMap<String, MapHost>();
    private ConcurrentMap<String, InputAttemptIdentifier> pathToIdentifierMap = new ConcurrentHashMap<String, InputAttemptIdentifier>();
    private Set<MapHost> pendingHosts = new HashSet<MapHost>();
    private Set<InputAttemptIdentifier> obsoleteMaps = new HashSet<InputAttemptIdentifier>();
    private final Random random = new Random(System.currentTimeMillis());
    private final DelayQueue<Penalty> penalties = new DelayQueue();
    private final Referee referee = new Referee();
    private final Map<InputAttemptIdentifier, IntWritable> failureCounts = new HashMap<InputAttemptIdentifier, IntWritable>();
    private final Map<String, IntWritable> hostFailures = new HashMap<String, IntWritable>();
    private final TezInputContext inputContext;
    private final Shuffle shuffle;
    private final int abortFailureLimit;
    private final TezCounter shuffledMapsCounter;
    private final TezCounter reduceShuffleBytes;
    private final TezCounter failedShuffleCounter;
    private final long startTime;
    private long lastProgressTime;
    private int maxMapRuntime = 0;
    private int maxFailedUniqueFetches = 5;
    private int maxFetchFailuresBeforeReporting;
    private long totalBytesShuffledTillNow = 0L;
    private DecimalFormat mbpsFormat = new DecimalFormat("0.00");
    private boolean reportReadErrorImmediately = true;

    public ShuffleScheduler(TezInputContext inputContext, Configuration conf, int numberOfInputs, Shuffle shuffle, TezCounter shuffledMapsCounter, TezCounter reduceShuffleBytes, TezCounter failedShuffleCounter) {
        this.inputContext = inputContext;
        this.numInputs = numberOfInputs;
        this.abortFailureLimit = Math.max(30, numberOfInputs / 10);
        this.remainingMaps = numberOfInputs;
        this.finishedMaps = new boolean[this.remainingMaps];
        this.shuffle = shuffle;
        this.shuffledMapsCounter = shuffledMapsCounter;
        this.reduceShuffleBytes = reduceShuffleBytes;
        this.failedShuffleCounter = failedShuffleCounter;
        this.lastProgressTime = this.startTime = System.currentTimeMillis();
        this.maxFailedUniqueFetches = Math.min(numberOfInputs, this.maxFailedUniqueFetches);
        this.referee.start();
        this.maxFetchFailuresBeforeReporting = conf.getInt("tez.runtime.shuffle.fetch.failures.limit", 10);
        this.reportReadErrorImmediately = conf.getBoolean("tez.runtime.shuffle.notify.readerror", true);
    }

    public synchronized void copySucceeded(InputAttemptIdentifier srcAttemptIdentifier, MapHost host, long bytes, long milis, MapOutput output) throws IOException {
        String taskIdentifier = TezRuntimeUtils.getTaskAttemptIdentifier(srcAttemptIdentifier.getInputIdentifier().getSrcTaskIndex(), srcAttemptIdentifier.getAttemptNumber());
        this.failureCounts.remove(taskIdentifier);
        this.hostFailures.remove(host.getHostName());
        if (!this.isInputFinished(srcAttemptIdentifier.getInputIdentifier().getSrcTaskIndex())) {
            output.commit();
            this.setInputFinished(srcAttemptIdentifier.getInputIdentifier().getSrcTaskIndex());
            this.shuffledMapsCounter.increment(1L);
            if (--this.remainingMaps == 0) {
                this.notifyAll();
            }
            this.lastProgressTime = System.currentTimeMillis();
            this.totalBytesShuffledTillNow += bytes;
            this.logProgress();
            this.reduceShuffleBytes.increment(bytes);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("src task: " + TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttemptIdentifier.getInputIdentifier().getSrcTaskIndex(), srcAttemptIdentifier.getAttemptNumber()) + " done"));
            }
        }
    }

    private void logProgress() {
        float mbs = (float)this.totalBytesShuffledTillNow / 1048576.0f;
        int mapsDone = this.numInputs - this.remainingMaps;
        long secsSinceStart = (System.currentTimeMillis() - this.startTime) / 1000L + 1L;
        float transferRate = mbs / (float)secsSinceStart;
        LOG.info((Object)("copy(" + mapsDone + " of " + this.numInputs + " at " + this.mbpsFormat.format(transferRate) + " MB/s)"));
    }

    public synchronized void copyFailed(InputAttemptIdentifier srcAttempt, MapHost host, boolean readError) {
        host.penalize();
        int failures = 1;
        if (this.failureCounts.containsKey(srcAttempt)) {
            IntWritable x = this.failureCounts.get(srcAttempt);
            x.set(x.get() + 1);
            failures = x.get();
        } else {
            this.failureCounts.put(srcAttempt, new IntWritable(1));
        }
        String hostname = host.getHostName();
        if (this.hostFailures.containsKey(hostname)) {
            IntWritable x = this.hostFailures.get(hostname);
            x.set(x.get() + 1);
        } else {
            this.hostFailures.put(hostname, new IntWritable(1));
        }
        if (failures >= this.abortFailureLimit) {
            IOException ioe = new IOException(failures + " failures downloading " + TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttempt.getInputIdentifier().getSrcTaskIndex(), srcAttempt.getAttemptNumber()));
            ioe.fillInStackTrace();
            this.shuffle.reportException(ioe);
        }
        this.checkAndInformJobTracker(failures, srcAttempt, readError);
        this.checkReducerHealth();
        long delay = (long)(10000.0 * Math.pow(1.3f, failures));
        this.penalties.add(new Penalty(host, delay));
        this.failedShuffleCounter.increment(1L);
    }

    private void checkAndInformJobTracker(int failures, InputAttemptIdentifier srcAttempt, boolean readError) {
        if (this.reportReadErrorImmediately && readError || failures % this.maxFetchFailuresBeforeReporting == 0) {
            LOG.info((Object)("Reporting fetch failure for " + TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttempt.getInputIdentifier().getSrcTaskIndex(), srcAttempt.getAttemptNumber()) + " to jobtracker."));
            ArrayList failedEvents = Lists.newArrayListWithCapacity((int)1);
            failedEvents.add(new InputReadErrorEvent("Fetch failure for " + TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttempt.getInputIdentifier().getSrcTaskIndex(), srcAttempt.getAttemptNumber()) + " to jobtracker.", srcAttempt.getInputIdentifier().getSrcTaskIndex(), srcAttempt.getAttemptNumber()));
            this.inputContext.sendEvents((List)failedEvents);
        }
    }

    private void checkReducerHealth() {
        boolean reducerStalled;
        int doneMaps;
        float MAX_ALLOWED_FAILED_FETCH_ATTEMPT_PERCENT = 0.5f;
        float MIN_REQUIRED_PROGRESS_PERCENT = 0.5f;
        float MAX_ALLOWED_STALL_TIME_PERCENT = 0.5f;
        long totalFailures = this.failedShuffleCounter.getValue();
        boolean reducerHealthy = (float)totalFailures / (float)(totalFailures + (long)(doneMaps = this.numInputs - this.remainingMaps)) < 0.5f;
        boolean reducerProgressedEnough = (float)doneMaps / (float)this.numInputs >= 0.5f;
        int stallDuration = (int)(System.currentTimeMillis() - this.lastProgressTime);
        int shuffleProgressDuration = (int)(this.lastProgressTime - this.startTime);
        int minShuffleRunDuration = shuffleProgressDuration > this.maxMapRuntime ? shuffleProgressDuration : this.maxMapRuntime;
        boolean bl = reducerStalled = (float)stallDuration / (float)minShuffleRunDuration >= 0.5f;
        if (!(this.failureCounts.size() < this.maxFailedUniqueFetches && this.failureCounts.size() != this.numInputs - doneMaps || reducerHealthy || reducerProgressedEnough && !reducerStalled)) {
            LOG.fatal((Object)"Shuffle failed with too many fetch failures and insufficient progress!");
            String errorMsg = "Exceeded MAX_FAILED_UNIQUE_FETCHES; bailing-out.";
            this.shuffle.reportException(new IOException(errorMsg));
        }
    }

    public synchronized void addKnownMapOutput(String hostName, int partitionId, String hostUrl, InputAttemptIdentifier srcAttempt) {
        String identifier = MapHost.createIdentifier(hostName, partitionId);
        MapHost host = this.mapLocations.get(identifier);
        if (host == null) {
            host = new MapHost(partitionId, hostName, hostUrl);
            assert (identifier.equals(host.getIdentifier()));
            this.mapLocations.put(identifier, host);
        }
        host.addKnownMap(srcAttempt);
        this.pathToIdentifierMap.put(this.getIdentifierFromPathAndReduceId(srcAttempt.getPathComponent(), partitionId), srcAttempt);
        if (host.getState() == MapHost.State.PENDING) {
            this.pendingHosts.add(host);
            this.notifyAll();
        }
    }

    public synchronized void obsoleteMapOutput(InputAttemptIdentifier srcAttempt) {
        this.obsoleteMaps.add(srcAttempt);
    }

    public synchronized void putBackKnownMapOutput(MapHost host, InputAttemptIdentifier srcAttempt) {
        host.addKnownMap(srcAttempt);
    }

    public synchronized MapHost getHost() throws InterruptedException {
        while (this.pendingHosts.isEmpty()) {
            this.wait();
        }
        MapHost host = null;
        Iterator<MapHost> iter = this.pendingHosts.iterator();
        int numToPick = this.random.nextInt(this.pendingHosts.size());
        for (int i = 0; i <= numToPick; ++i) {
            host = iter.next();
        }
        this.pendingHosts.remove(host);
        host.markBusy();
        LOG.info((Object)("Assigning " + host + " with " + host.getNumKnownMapOutputs() + " to " + Thread.currentThread().getName()));
        shuffleStart.set(System.currentTimeMillis());
        return host;
    }

    public InputAttemptIdentifier getIdentifierForFetchedOutput(String path, int reduceId) {
        return (InputAttemptIdentifier)this.pathToIdentifierMap.get(this.getIdentifierFromPathAndReduceId(path, reduceId));
    }

    public synchronized List<InputAttemptIdentifier> getMapsForHost(MapHost host) {
        InputAttemptIdentifier id;
        List<InputAttemptIdentifier> list = host.getAndClearKnownMaps();
        Iterator<InputAttemptIdentifier> itr = list.iterator();
        ArrayList<InputAttemptIdentifier> result = new ArrayList<InputAttemptIdentifier>();
        int includedMaps = 0;
        int totalSize = list.size();
        while (itr.hasNext()) {
            id = itr.next();
            if (this.obsoleteMaps.contains(id) || this.isInputFinished(id.getInputIdentifier().getSrcTaskIndex())) continue;
            result.add(id);
            if (++includedMaps < 20) continue;
            break;
        }
        while (itr.hasNext()) {
            id = itr.next();
            if (this.obsoleteMaps.contains(id) || this.isInputFinished(id.getInputIdentifier().getSrcTaskIndex())) continue;
            host.addKnownMap(id);
        }
        LOG.info((Object)("assigned " + includedMaps + " of " + totalSize + " to " + host + " to " + Thread.currentThread().getName()));
        return result;
    }

    public synchronized void freeHost(MapHost host) {
        if (host.getState() != MapHost.State.PENALIZED && host.markAvailable() == MapHost.State.PENDING) {
            this.pendingHosts.add(host);
            this.notifyAll();
        }
        LOG.info((Object)(host + " freed by " + Thread.currentThread().getName() + " in " + (System.currentTimeMillis() - shuffleStart.get()) + "s"));
    }

    public synchronized void resetKnownMaps() {
        this.mapLocations.clear();
        this.obsoleteMaps.clear();
        this.pendingHosts.clear();
        this.pathToIdentifierMap.clear();
    }

    public synchronized boolean isDone() {
        return this.remainingMaps == 0;
    }

    public synchronized boolean waitUntilDone(int millis) throws InterruptedException {
        if (this.remainingMaps > 0) {
            this.wait(millis);
            return this.remainingMaps == 0;
        }
        return true;
    }

    private String getIdentifierFromPathAndReduceId(String path, int reduceId) {
        return path + "_" + reduceId;
    }

    public void close() throws InterruptedException {
        this.referee.interrupt();
        this.referee.join();
    }

    public synchronized void informMaxMapRunTime(int duration) {
        if (duration > this.maxMapRuntime) {
            this.maxMapRuntime = duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputFinished(int inputIndex) {
        boolean[] blArray = this.finishedMaps;
        synchronized (this.finishedMaps) {
            this.finishedMaps[inputIndex] = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInputFinished(int inputIndex) {
        boolean[] blArray = this.finishedMaps;
        synchronized (this.finishedMaps) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.finishedMaps[inputIndex];
        }
    }

    private class Referee
    extends Thread {
        public Referee() {
            this.setName("ShufflePenaltyReferee");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    MapHost host = ((Penalty)((ShuffleScheduler)ShuffleScheduler.this).penalties.take()).host;
                    ShuffleScheduler shuffleScheduler = ShuffleScheduler.this;
                    synchronized (shuffleScheduler) {
                        if (host.markAvailable() == MapHost.State.PENDING) {
                            ShuffleScheduler.this.pendingHosts.add(host);
                            ShuffleScheduler.this.notifyAll();
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (Throwable t) {
                ShuffleScheduler.this.shuffle.reportException(t);
                return;
            }
        }
    }

    private static class Penalty
    implements Delayed {
        MapHost host;
        private long endTime;

        Penalty(MapHost host, long delay) {
            this.host = host;
            this.endTime = System.currentTimeMillis() + delay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long remainingTime = this.endTime - System.currentTimeMillis();
            return unit.convert(remainingTime, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long other = ((Penalty)o).endTime;
            return this.endTime == other ? 0 : (this.endTime < other ? -1 : 1);
        }
    }
}

