/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.impl.MergeManager;
import org.apache.tez.runtime.library.common.sort.impl.IFile;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryReader
extends IFile.Reader {
    private final InputAttemptIdentifier taskAttemptId;
    private final MergeManager merger;
    DataInputBuffer memDataIn = new DataInputBuffer();
    private int start;
    private int length;
    private int prevKeyPos;

    public InMemoryReader(MergeManager merger, InputAttemptIdentifier taskAttemptId, byte[] data, int start, int length) throws IOException {
        super(null, length - start, null, null, false, 0, -1);
        this.merger = merger;
        this.taskAttemptId = taskAttemptId;
        this.buffer = data;
        this.bufferSize = (int)this.fileLength;
        this.memDataIn.reset(this.buffer, start, length);
        this.start = start;
        this.length = length;
    }

    @Override
    public void reset(int offset) {
        this.memDataIn.reset(this.buffer, this.start + offset, this.length);
        this.bytesRead = offset;
        this.eof = false;
    }

    @Override
    public long getPosition() throws IOException {
        return this.bytesRead;
    }

    @Override
    public long getLength() {
        return this.fileLength;
    }

    private void dumpOnError() {
        File dumpFile = new File("../output/" + this.taskAttemptId + ".dump");
        System.err.println("Dumping corrupt map-output of " + this.taskAttemptId + " to " + dumpFile.getAbsolutePath());
        try {
            FileOutputStream fos = new FileOutputStream(dumpFile);
            fos.write(this.buffer, 0, this.bufferSize);
            fos.close();
        }
        catch (IOException ioe) {
            System.err.println("Failed to dump map-output of " + this.taskAttemptId);
        }
    }

    @Override
    public IFile.Reader.KeyState readRawKey(DataInputBuffer key) throws IOException {
        try {
            if (!this.positionToNextRecord((DataInput)this.memDataIn)) {
                return IFile.Reader.KeyState.NO_KEY;
            }
            int pos = this.memDataIn.getPosition();
            byte[] data = this.memDataIn.getData();
            if (this.currentKeyLength == -2) {
                key.reset(data, this.prevKeyPos, this.prevKeyLength);
                this.currentKeyLength = this.prevKeyLength;
                return IFile.Reader.KeyState.SAME_KEY;
            }
            key.reset(data, pos, this.currentKeyLength);
            this.prevKeyPos = pos;
            long skipped = this.memDataIn.skip((long)this.currentKeyLength);
            if (skipped != (long)this.currentKeyLength) {
                throw new IOException("Rec# " + this.recNo + ": Failed to skip past key of length: " + this.currentKeyLength);
            }
            this.bytesRead += (long)this.currentKeyLength;
            return IFile.Reader.KeyState.NEW_KEY;
        }
        catch (IOException ioe) {
            this.dumpOnError();
            throw ioe;
        }
    }

    @Override
    public void nextRawValue(DataInputBuffer value) throws IOException {
        try {
            int pos = this.memDataIn.getPosition();
            byte[] data = this.memDataIn.getData();
            value.reset(data, pos, this.currentValueLength);
            long skipped = this.memDataIn.skip((long)this.currentValueLength);
            if (skipped != (long)this.currentValueLength) {
                throw new IOException("Rec# " + this.recNo + ": Failed to skip past value of length: " + this.currentValueLength);
            }
            this.bytesRead += (long)this.currentValueLength;
            ++this.recNo;
        }
        catch (IOException ioe) {
            this.dumpOnError();
            throw ioe;
        }
    }

    @Override
    public void close() {
        this.dataIn = null;
        this.buffer = null;
        if (this.merger != null) {
            this.merger.unreserve(this.bufferSize);
        }
    }
}

