/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.task.local.output;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TezTaskOutputFiles
extends TezTaskOutput {
    private static final Log LOG = LogFactory.getLog(TezTaskOutputFiles.class);
    private static final String SPILL_FILE_PATTERN = "%s_spill_%d.out";
    private static final String SPILL_INDEX_FILE_PATTERN = "%s_spill_%d.out.index";
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.runtime.local.dirs");

    public TezTaskOutputFiles(Configuration conf, String uniqueId) {
        super(conf, uniqueId);
    }

    private Path getAttemptOutputDir() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAttemptOutputDir: output/" + this.uniqueId));
        }
        return new Path("output", this.uniqueId);
    }

    public Path getOutputFile() throws IOException {
        Path attemptOutput = new Path(this.getAttemptOutputDir(), "file.out");
        return this.lDirAlloc.getLocalPathToRead(attemptOutput.toString(), this.conf);
    }

    public Path getOutputFileForWrite(long size) throws IOException {
        Path attemptOutput = new Path(this.getAttemptOutputDir(), "file.out");
        return this.lDirAlloc.getLocalPathForWrite(attemptOutput.toString(), size, this.conf);
    }

    public Path getOutputFileForWrite() throws IOException {
        Path attemptOutput = new Path(this.getAttemptOutputDir(), "file.out");
        return this.lDirAlloc.getLocalPathForWrite(attemptOutput.toString(), this.conf);
    }

    public Path getOutputFileForWriteInVolume(Path existing) {
        Path outputDir = new Path(existing.getParent(), "output");
        Path attemptOutputDir = new Path(outputDir, this.uniqueId);
        return new Path(attemptOutputDir, "file.out");
    }

    public Path getOutputIndexFile() throws IOException {
        Path attemptIndexOutput = new Path(this.getAttemptOutputDir(), "file.out.index");
        return this.lDirAlloc.getLocalPathToRead(attemptIndexOutput.toString(), this.conf);
    }

    public Path getOutputIndexFileForWrite(long size) throws IOException {
        Path attemptIndexOutput = new Path(this.getAttemptOutputDir(), "file.out.index");
        return this.lDirAlloc.getLocalPathForWrite(attemptIndexOutput.toString(), size, this.conf);
    }

    public Path getOutputIndexFileForWriteInVolume(Path existing) {
        Path outputDir = new Path(existing.getParent(), "output");
        Path attemptOutputDir = new Path(outputDir, this.uniqueId);
        return new Path(attemptOutputDir, "file.out.index");
    }

    public Path getSpillFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(String.format(SPILL_FILE_PATTERN, this.uniqueId, spillNumber), this.conf);
    }

    public Path getSpillFileForWrite(int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format(SPILL_FILE_PATTERN, this.uniqueId, spillNumber), size, this.conf);
    }

    public Path getSpillIndexFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(String.format(SPILL_INDEX_FILE_PATTERN, this.uniqueId, spillNumber), this.conf);
    }

    public Path getSpillIndexFileForWrite(int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format(SPILL_INDEX_FILE_PATTERN, this.uniqueId, spillNumber), size, this.conf);
    }

    public Path getInputFile(InputAttemptIdentifier attemptIdentifier) throws IOException {
        throw new UnsupportedOperationException("Incompatible with LocalRunner");
    }

    public Path getInputFileForWrite(int srcTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format(SPILL_FILE_PATTERN, this.uniqueId, srcTaskId), size, this.conf);
    }

    public void removeAll() throws IOException {
        throw new UnsupportedOperationException("Incompatible with LocalRunner");
    }
}

