/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.task.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuesIterator<KEY, VALUE>
implements Iterator<VALUE> {
    protected TezRawKeyValueIterator in;
    private KEY key;
    private KEY nextKey;
    private VALUE value;
    private boolean hasNext;
    private boolean more;
    private RawComparator<KEY> comparator;
    protected Progressable reporter;
    private Deserializer<KEY> keyDeserializer;
    private Deserializer<VALUE> valDeserializer;
    private DataInputBuffer keyIn = new DataInputBuffer();
    private DataInputBuffer valueIn = new DataInputBuffer();
    private int ctr = 0;

    public ValuesIterator(TezRawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, Progressable reporter) throws IOException {
        this.in = in;
        this.comparator = comparator;
        this.reporter = reporter;
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        this.keyDeserializer = serializationFactory.getDeserializer(keyClass);
        this.keyDeserializer.open((InputStream)this.keyIn);
        this.valDeserializer = serializationFactory.getDeserializer(valClass);
        this.valDeserializer.open((InputStream)this.valueIn);
        this.readNextKey();
        this.key = this.nextKey;
        this.nextKey = null;
        this.hasNext = this.more;
    }

    TezRawKeyValueIterator getRawIterator() {
        return this.in;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public VALUE next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("iterate past last value");
        }
        try {
            this.readNextValue();
            this.readNextKey();
        }
        catch (IOException ie) {
            throw new RuntimeException("problem advancing post rec#" + this.ctr, ie);
        }
        this.reporter.progress();
        return this.value;
    }

    @Override
    public void remove() {
        throw new RuntimeException("not implemented");
    }

    public void nextKey() throws IOException {
        while (this.hasNext) {
            this.readNextKey();
        }
        ++this.ctr;
        KEY tmpKey = this.key;
        this.key = this.nextKey;
        this.nextKey = tmpKey;
        this.hasNext = this.more;
    }

    public boolean more() {
        return this.more;
    }

    public KEY getKey() {
        return this.key;
    }

    private void readNextKey() throws IOException {
        this.more = this.in.next();
        if (this.more) {
            DataInputBuffer nextKeyBytes = this.in.getKey();
            this.keyIn.reset(nextKeyBytes.getData(), nextKeyBytes.getPosition(), nextKeyBytes.getLength());
            this.nextKey = this.keyDeserializer.deserialize(this.nextKey);
            this.hasNext = this.key != null && this.comparator.compare(this.key, this.nextKey) == 0;
        } else {
            this.hasNext = false;
        }
    }

    private void readNextValue() throws IOException {
        DataInputBuffer nextValueBytes = this.in.getValue();
        this.valueIn.reset(nextValueBytes.getData(), nextValueBytes.getPosition(), nextValueBytes.getLength());
        this.value = this.valDeserializer.deserialize(this.value);
    }
}

