/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class IFileOutputStream
extends FilterOutputStream {
    private final DataChecksum sum = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)Integer.MAX_VALUE);
    private byte[] barray = new byte[this.sum.getChecksumSize()];
    private byte[] buffer = new byte[4096];
    private int offset = 0;
    private boolean closed = false;
    private boolean finished = false;

    public IFileOutputStream(OutputStream out) {
        super(out);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.sum.update(this.buffer, 0, this.offset);
        this.sum.writeValue(this.barray, 0, false);
        this.out.write(this.barray, 0, this.sum.getChecksumSize());
        this.out.flush();
    }

    private void checksum(byte[] b, int off, int len) {
        if (len >= this.buffer.length) {
            this.sum.update(this.buffer, 0, this.offset);
            this.offset = 0;
            this.sum.update(b, off, len);
            return;
        }
        int remaining = this.buffer.length - this.offset;
        if (len > remaining) {
            this.sum.update(this.buffer, 0, this.offset);
            this.offset = 0;
        }
        System.arraycopy(b, off, this.buffer, this.offset, len);
        this.offset += len;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checksum(b, off, len);
        this.out.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.barray[0] = (byte)(b & 0xFF);
        this.write(this.barray, 0, 1);
    }
}

