/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.comparator;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.tez.runtime.library.common.comparator.ProxyComparator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class TezBytesComparator
extends WritableComparator
implements ProxyComparator<BytesWritable> {
    public TezBytesComparator() {
        super(BytesWritable.class);
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return TezBytesComparator.compareBytes((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
    }

    @Override
    public int getProxy(BytesWritable key) {
        int prefix = 0;
        int len = key.getLength();
        byte[] content = key.getBytes();
        int b1 = 0;
        int b2 = 0;
        int b3 = 0;
        switch (len) {
            default: {
                b3 = content[2] & 0xFF;
            }
            case 2: {
                b2 = content[1] & 0xFF;
            }
            case 1: {
                b1 = content[0] & 0xFF;
            }
            case 0: 
        }
        prefix = b1 << 16 | b2 << 8 | b3;
        return prefix;
    }
}

