/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.api.Writer;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.writers.UnorderedPartitionedKVWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class UnorderedPartitionedKVOutput
extends AbstractLogicalOutput {
    private static final Logger LOG = LoggerFactory.getLogger(UnorderedPartitionedKVOutput.class);
    @VisibleForTesting
    Configuration conf;
    private MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private UnorderedPartitionedKVWriter kvWriter;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private static final Set<String> confKeys = new HashSet<String>();

    public UnorderedPartitionedKVOutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    public synchronized List<Event> initialize() throws Exception {
        this.conf = TezUtils.createConfFromBaseConfAndPayload((TaskContext)this.getContext());
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        this.conf.setInt("tez.runtime.framework.num.expected.partitions", this.getNumPhysicalOutputs());
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        this.getContext().requestInitialMemory(UnorderedPartitionedKVWriter.getInitialMemoryRequirement(this.conf, this.getContext().getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        return Collections.emptyList();
    }

    public synchronized void start() throws Exception {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            this.kvWriter = new UnorderedPartitionedKVWriter(this.getContext(), this.conf, this.getNumPhysicalOutputs(), this.memoryUpdateCallbackHandler.getMemoryAssigned());
            this.isStarted.set(true);
        }
    }

    public synchronized Writer getWriter() throws Exception {
        Preconditions.checkState((boolean)this.isStarted.get(), (Object)"Cannot get writer before starting the Output");
        return this.kvWriter;
    }

    public void handleEvents(List<Event> outputEvents) {
    }

    public synchronized List<Event> close() throws Exception {
        List<Event> returnEvents = null;
        if (this.isStarted.get()) {
            returnEvents = this.kvWriter.close();
            this.kvWriter = null;
        } else {
            LOG.warn(this.getContext().getInputOutputVertexNames() + ": Attempting to close output {} of type {} before it was started. Generating empty events", (Object)this.getContext().getDestinationVertexName(), (Object)((Object)((Object)this)).getClass().getSimpleName());
            returnEvents = new LinkedList<Event>();
            ShuffleUtils.generateEventsForNonStartedOutput(returnEvents, this.getNumPhysicalOutputs(), this.getContext(), false, true, TezCommonUtils.newBestCompressionDeflater());
        }
        long outputSize = this.getContext().getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES).getValue();
        this.getContext().getStatisticsReporter().reportDataSize(outputSize);
        long outputRecords = this.getContext().getCounters().findCounter((Enum)TaskCounter.OUTPUT_RECORDS).getValue();
        this.getContext().getStatisticsReporter().reportItemsProcessed(outputRecords);
        return returnEvents;
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(confKeys);
    }

    static {
        confKeys.add("tez.runtime.ifile.readahead");
        confKeys.add("tez.runtime.ifile.readahead.bytes");
        confKeys.add("io.file.buffer.size");
        confKeys.add("tez.runtime.index.cache.memory.limit.bytes");
        confKeys.add("tez.runtime.unordered.output.buffer.size-mb");
        confKeys.add("tez.runtime.unordered.output.max-per-buffer.size-bytes");
        confKeys.add("tez.runtime.partitioner.class");
        confKeys.add("tez.runtime.key.class");
        confKeys.add("tez.runtime.value.class");
        confKeys.add("tez.runtime.compress");
        confKeys.add("tez.runtime.compress.codec");
        confKeys.add("tez.runtime.empty.partitions.info-via-events.enabled");
        confKeys.add("tez.runtime.transfer.data-via-events.enabled");
        confKeys.add("tez.runtime.transfer.data-via-events.max-size");
        confKeys.add("tez.runtime.transfer.data-via-events.support.in-mem.file");
        confKeys.add("tez.runtime.convert.user-payload.to.history-text");
        confKeys.add("tez.runtime.pipelined-shuffle.enabled");
        confKeys.add("tez.runtime.enable.final-merge.in.output");
        confKeys.add("tez.counters.max");
        confKeys.add("tez.counters.group-name.max-length");
        confKeys.add("tez.counters.counter-name.max-length");
        confKeys.add("tez.counters.max.groups");
        confKeys.add("tez.runtime.cleanup.files.on.interrupt");
        confKeys.add("tez.runtime.report.partition.stats");
        confKeys.add("tez.am.shuffle.auxiliary-service.id");
        confKeys.add("tez.runtime.unordered-partitioned-kvwriter.buffer-merge-percent");
    }
}

