/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.library.vertexmanager.DestinationTaskInputsProperty;
import org.apache.tez.dag.library.vertexmanager.FairEdgeConfiguration;

public class FairShuffleEdgeManager
extends EdgeManagerPluginOnDemand {
    private FairEdgeConfiguration conf = null;
    private HashMap<Integer, DestinationTaskInputsProperty> mapping;

    public FairShuffleEdgeManager(EdgeManagerPluginContext context) {
        super(context);
    }

    public int getNumDestinationTaskPhysicalInputs(int destTaskIndex) {
        return this.mapping.get(destTaskIndex).getNumOfPhysicalInputs();
    }

    public int getNumSourceTaskPhysicalOutputs(int sourceTaskIndex) {
        return this.conf.getNumBuckets();
    }

    public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
        int numTasks = 0;
        for (DestinationTaskInputsProperty entry : this.mapping.values()) {
            if (!entry.isSourceTaskInRange(sourceTaskIndex)) continue;
            ++numTasks;
        }
        return numTasks;
    }

    public void initialize() {
        UserPayload userPayload = this.getContext().getUserPayload();
        if (userPayload == null || userPayload.getPayload() == null || userPayload.getPayload().limit() == 0) {
            throw new RuntimeException("Could not initialize FairShuffleEdgeManager from provided user payload");
        }
        try {
            this.conf = FairEdgeConfiguration.fromUserPayload(userPayload);
            this.mapping = this.conf.getRoutingTable();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Could not initialize FairShuffleEdgeManager from provided user payload", e);
        }
    }

    public int routeInputErrorEventToSource(int destinationTaskIndex, int destinationFailedInputIndex) {
        return this.mapping.get(destinationTaskIndex).getSourceTaskIndex(destinationFailedInputIndex);
    }

    public void prepareForRouting() throws Exception {
    }

    public EdgeManagerPluginOnDemand.EventRouteMetadata routeDataMovementEventToDestination(int sourceTaskIndex, int sourceOutputIndex, int destTaskIndex) throws Exception {
        DestinationTaskInputsProperty property = this.mapping.get(destTaskIndex);
        int targetIndex = property.getPhysicalInputIndex(sourceTaskIndex, sourceOutputIndex);
        if (targetIndex != -1) {
            return EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)1, (int[])new int[]{targetIndex});
        }
        return null;
    }

    private int[] getRange(int startValue, int count) {
        int[] values = new int[count];
        for (int i = 0; i < count; ++i) {
            values[i] = startValue + i;
        }
        return values;
    }

    @Nullable
    public EdgeManagerPluginOnDemand.CompositeEventRouteMetadata routeCompositeDataMovementEventToDestination(int sourceTaskIndex, int destinationTaskIndex) {
        DestinationTaskInputsProperty property = this.mapping.get(destinationTaskIndex);
        int firstPhysicalInputIndex = property.getFirstPhysicalInputIndex(sourceTaskIndex);
        if (firstPhysicalInputIndex >= 0) {
            return EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)property.getNumOfPartitions(), (int)firstPhysicalInputIndex, (int)property.getFirstPartitionId());
        }
        return null;
    }

    public EdgeManagerPluginOnDemand.EventRouteMetadata routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, int destinationTaskIndex) throws Exception {
        DestinationTaskInputsProperty property = this.mapping.get(destinationTaskIndex);
        int firstPhysicalInputIndex = property.getFirstPhysicalInputIndex(sourceTaskIndex);
        if (firstPhysicalInputIndex >= 0) {
            return EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)property.getNumOfPartitions(), (int[])this.getRange(firstPhysicalInputIndex, property.getNumOfPartitions()));
        }
        return null;
    }
}

