/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;

@InterfaceAudience.Private
public class FileChunk
implements Comparable<FileChunk> {
    private final long offset;
    private final long length;
    private final boolean isLocalFile;
    private final Path path;
    private final InputAttemptIdentifier identifier;

    public FileChunk(Path path, long offset, long length, boolean isLocalFile, InputAttemptIdentifier identifier) {
        this.path = path;
        this.offset = offset;
        this.length = length;
        this.isLocalFile = isLocalFile;
        this.identifier = identifier;
        if (isLocalFile) {
            Objects.requireNonNull(identifier);
        }
    }

    public FileChunk(Path path, long offset, long length) {
        this(path, offset, length, false, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileChunk that = (FileChunk)o;
        return this.path.equals((Object)that.path) && this.offset == that.offset && this.length == that.length;
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        return result;
    }

    @Override
    public int compareTo(FileChunk that) {
        long lc = this.length - that.length;
        if (lc != 0L) {
            return lc < 0L ? -1 : 1;
        }
        int c = this.path.compareTo((Object)that.path);
        if (c != 0) {
            return c;
        }
        lc = this.offset - that.offset;
        if (lc != 0L) {
            return lc < 0L ? -1 : 1;
        }
        return 0;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    public InputAttemptIdentifier getInputAttemptIdentifier() {
        return this.identifier;
    }
}

