/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezEntityDescriptor;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezCountersDelegate;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezTaskContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;

public class TezOutputContextImpl
extends TezTaskContextImpl
implements TezOutputContext {
    private final byte[] userPayload;
    private final String destinationVertexName;
    private final EventMetaData sourceInfo;
    private final int outputIndex;

    @InterfaceAudience.Private
    public TezOutputContextImpl(Configuration conf, int appAttemptNumber, TezUmbilical tezUmbilical, String dagName, String taskVertexName, String destinationVertexName, TezTaskAttemptID taskAttemptID, TezCounters counters, int outputIndex, @Nullable byte[] userPayload, RuntimeTask runtimeTask, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv, MemoryDistributor memDist, OutputDescriptor outputDescriptor) {
        super(conf, appAttemptNumber, dagName, taskVertexName, taskAttemptID, TezOutputContextImpl.wrapCounters(counters, taskVertexName, destinationVertexName, conf), runtimeTask, tezUmbilical, serviceConsumerMetadata, auxServiceEnv, memDist, (TezEntityDescriptor)outputDescriptor);
        Preconditions.checkNotNull((Object)outputIndex, (Object)"outputIndex is null");
        Preconditions.checkNotNull((Object)destinationVertexName, (Object)"destinationVertexName is null");
        this.userPayload = userPayload;
        this.outputIndex = outputIndex;
        this.destinationVertexName = destinationVertexName;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, taskVertexName, destinationVertexName, taskAttemptID);
    }

    private static TezCounters wrapCounters(TezCounters tezCounters, String taskVertexName, String edgeVertexName, Configuration conf) {
        if (conf.getBoolean("tez.task.generate.counters.per.io", false)) {
            return new TezCountersDelegate(tezCounters, taskVertexName, edgeVertexName, "OUTPUT");
        }
        return tezCounters;
    }

    public void sendEvents(List<Event> events) {
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event e : events) {
            TezEvent tEvt = new TezEvent(e, this.sourceInfo);
            tezEvents.add(tEvt);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    public byte[] getUserPayload() {
        return this.userPayload;
    }

    public String getDestinationVertexName() {
        return this.destinationVertexName;
    }

    public void fatalError(Throwable exception, String message) {
        super.signalFatalError(exception, message, this.sourceInfo);
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }
}

